/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.ndev.handlers;

import dev.norska.hexp.HarvestEXP;
import dev.norska.hexp.XMaterial;
import dev.norska.hexp.ndev.objects.MessageObject;
import dev.norska.hexp.ndev.objects.SoundObject;
import dev.norska.hexp.perms.HEXPPerm;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;

public class CacheHandler {
    private String editablePrefix;
    private HashMap<String, MessageObject> messageMap = new HashMap();
    private HashMap<String, SoundObject> soundMap = new HashMap();
    private Boolean scytherAutosellEnabled;
    private Boolean scytherAutocollectEnabled;
    private Boolean notifyForUpdates;
    private Boolean stripConsole;

    private boolean isVersionOrHigher(String minVersion) {
        String currentVersion = Bukkit.getBukkitVersion().split("-")[0];
        String[] currentParts = currentVersion.split("\\.");
        String[] minParts = minVersion.split("\\.");
        int length = Math.max(currentParts.length, minParts.length);
        for (int i = 0; i < length; ++i) {
            int minPart;
            int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = minPart = i < minParts.length ? Integer.parseInt(minParts[i]) : 0;
            if (currentPart > minPart) {
                return true;
            }
            if (currentPart >= minPart) continue;
            return false;
        }
        return true;
    }

    public void cache(HarvestEXP main) {
        this.cacheMessageFeedback(main);
        this.cacheSoundFeedback(main);
        this.editablePrefix = main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages.prefix");
        this.loadCropData(main);
        this.loadManuallyPlacedCrops(main);
        this.stripConsole = main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("stripConsole");
        this.notifyForUpdates = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("updates.notifications");
    }

    private void cacheMessageFeedback(HarvestEXP main) {
        if (!this.messageMap.isEmpty()) {
            this.messageMap.clear();
        }
        for (String section : main.getNHandler().getConfigurationHandler().getMsgFile().getConfigurationSection("messages").getKeys(false)) {
            MessageObject message = new MessageObject();
            this.messageMap.put(section, message);
            message = this.messageMap.get(section);
            message.setChatMessageEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".chatMessage.enabled"));
            message.setChatMessageCentered(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".chatMessage.centered"));
            message.setChatMessageContent(main.getNHandler().getConfigurationHandler().getMsgFile().getStringList("messages." + section + ".chatMessage.content"));
            message.setActionbarEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".actionbar.enabled"));
            message.setActionbarContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".actionbar.content"));
            message.setActionbarDuration(main.getNHandler().getConfigurationHandler().getMsgFile().getInt("messages." + section + ".actionbar.duration"));
            message.setTitleEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".titles.enabled"));
            message.setTitleContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".titles.titleContent"));
            message.setSubtitleContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".titles.subtitleContent"));
        }
    }

    private void cacheSoundFeedback(HarvestEXP main) {
        if (!this.soundMap.isEmpty()) {
            this.soundMap.clear();
        }
        for (String section : main.getNHandler().getConfigurationHandler().getSoundsFile().getConfigurationSection("sounds").getKeys(false)) {
            SoundObject sound = new SoundObject();
            this.soundMap.put(section, sound);
            sound = this.soundMap.get(section);
            sound.setEnabled(main.getNHandler().getConfigurationHandler().getSoundsFile().getBoolean("sounds." + section + ".enabled"));
            sound.setName(main.getNHandler().getConfigurationHandler().getSoundsFile().getString("sounds." + section + ".sound"));
            sound.setVolume((float)main.getNHandler().getConfigurationHandler().getSoundsFile().getDouble("sounds." + section + ".volume"));
            sound.setPitch((float)main.getNHandler().getConfigurationHandler().getSoundsFile().getDouble("sounds." + section + ".pitch"));
        }
    }

    private void loadManuallyPlacedCrops(HarvestEXP main) {
        for (String serializedLocation : main.getNHandler().getConfigurationHandler().getDataFile().getStringList("locations")) {
            Location loc = main.getHEXPUtils().deserializeLocation(serializedLocation);
            main.getHEXPUtils().getManuallyPlaced().add(loc);
        }
    }

    private void loadCropData(HarvestEXP main) {
        main.getCropProfileHandler().getPotato().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.POTATO.general.enabled"));
        main.getCropProfileHandler().getPotato().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.POTATO.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getPotato().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.POTATO.experience.dropOnBreak"));
        main.getCropProfileHandler().getPotato().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.POTATO.permission.enabled"));
        main.getCropProfileHandler().getPotato().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.POTATO.experience.amount"));
        main.getCropProfileHandler().getPotato().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.POTATO.worlds.blacklist"));
        main.getCropProfileHandler().getPotato().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_POTATO));
        main.getCropProfileHandler().getPotato().setMaterial(XMaterial.POTATOES.parseMaterial());
        main.getCropProfileHandler().getCarrot().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.CARROT.general.enabled"));
        main.getCropProfileHandler().getCarrot().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.CARROT.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getCarrot().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.CARROT.experience.dropOnBreak"));
        main.getCropProfileHandler().getCarrot().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.CARROT.permission.enabled"));
        main.getCropProfileHandler().getCarrot().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.CARROT.experience.amount"));
        main.getCropProfileHandler().getCarrot().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.CARROT.worlds.blacklist"));
        main.getCropProfileHandler().getCarrot().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_CARROT));
        main.getCropProfileHandler().getCarrot().setMaterial(XMaterial.CARROTS.parseMaterial());
        main.getCropProfileHandler().getWheat().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.WHEAT.general.enabled"));
        main.getCropProfileHandler().getWheat().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.WHEAT.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getWheat().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.WHEAT.experience.dropOnBreak"));
        main.getCropProfileHandler().getWheat().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.WHEAT.permission.enabled"));
        main.getCropProfileHandler().getWheat().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.WHEAT.experience.amount"));
        main.getCropProfileHandler().getWheat().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.WHEAT.worlds.blacklist"));
        main.getCropProfileHandler().getWheat().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_WHEAT));
        if (this.isVersionOrHigher("1.13")) {
            main.getCropProfileHandler().getWheat().setMaterial(XMaterial.WHEAT.parseMaterial());
        } else {
            main.getCropProfileHandler().getWheat().setMaterial(Material.matchMaterial((String)"CROPS"));
        }
        main.getCropProfileHandler().getNetherwart().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.NETHERWART.general.enabled"));
        main.getCropProfileHandler().getNetherwart().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.NETHERWART.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getNetherwart().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.NETHERWART.experience.dropOnBreak"));
        main.getCropProfileHandler().getNetherwart().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.NETHERWART.permission.enabled"));
        main.getCropProfileHandler().getNetherwart().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.NETHERWART.experience.amount"));
        main.getCropProfileHandler().getNetherwart().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.NETHERWART.worlds.blacklist"));
        main.getCropProfileHandler().getNetherwart().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_NETHERWART));
        if (this.isVersionOrHigher("1.13")) {
            main.getCropProfileHandler().getNetherwart().setMaterial(XMaterial.NETHER_WART.parseMaterial());
        } else {
            main.getCropProfileHandler().getNetherwart().setMaterial(Material.matchMaterial((String)"NETHER_WARTS"));
        }
        main.getCropProfileHandler().getBeetroot().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.BEETROOT.general.enabled"));
        main.getCropProfileHandler().getBeetroot().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.BEETROOT.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getBeetroot().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.BEETROOT.experience.dropOnBreak"));
        main.getCropProfileHandler().getBeetroot().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.BEETROOT.permission.enabled"));
        main.getCropProfileHandler().getBeetroot().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.BEETROOT.experience.amount"));
        main.getCropProfileHandler().getBeetroot().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.BEETROOT.worlds.blacklist"));
        main.getCropProfileHandler().getBeetroot().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_BEETROOT));
        if (this.isVersionOrHigher("1.13")) {
            main.getCropProfileHandler().getBeetroot().setMaterial(Material.BEETROOTS);
        } else {
            main.getCropProfileHandler().getBeetroot().setMaterial(Material.matchMaterial((String)"BEETROOT_BLOCK"));
        }
        main.getCropProfileHandler().getCocoabean().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.COCOABEAN.general.enabled"));
        main.getCropProfileHandler().getCocoabean().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.COCOABEAN.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getCocoabean().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.COCOABEAN.experience.dropOnBreak"));
        main.getCropProfileHandler().getCocoabean().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.COCOABEAN.permission.enabled"));
        main.getCropProfileHandler().getCocoabean().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.COCOABEAN.experience.amount"));
        main.getCropProfileHandler().getCocoabean().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.COCOABEAN.worlds.blacklist"));
        main.getCropProfileHandler().getCocoabean().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_COCOABEAN));
        if (this.isVersionOrHigher("1.13")) {
            main.getCropProfileHandler().getCocoabean().setMaterial(Material.COCOA);
        } else {
            main.getCropProfileHandler().getCocoabean().setMaterial(XMaterial.COCOA.parseMaterial());
        }
        main.getCropProfileHandler().getSweetberry().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.SWEETBERRY.general.enabled"));
        main.getCropProfileHandler().getSweetberry().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.SWEETBERRY.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getSweetberry().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.SWEETBERRY.experience.dropOnBreak"));
        main.getCropProfileHandler().getSweetberry().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.SWEETBERRY.permission.enabled"));
        main.getCropProfileHandler().getSweetberry().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.SWEETBERRY.experience.amount"));
        main.getCropProfileHandler().getSweetberry().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.SWEETBERRY.worlds.blacklist"));
        main.getCropProfileHandler().getSweetberry().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_SWEETBERRY));
        main.getCropProfileHandler().getSweetberry().setMaterial(XMaterial.SWEET_BERRY_BUSH.parseMaterial());
        main.getCropProfileHandler().getTorchflower().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.TORCHFLOWER.general.enabled"));
        main.getCropProfileHandler().getTorchflower().setDropOnlyIfRipe(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.TORCHFLOWER.experience.dropOnlyIfRipe"));
        main.getCropProfileHandler().getTorchflower().setDropOnlyIfNaturallyGrown(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.TORCHFLOWER.experience.dropOnlyIfNaturallyGrown"));
        main.getCropProfileHandler().getTorchflower().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.TORCHFLOWER.experience.dropOnBreak"));
        main.getCropProfileHandler().getTorchflower().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.TORCHFLOWER.permission.enabled"));
        main.getCropProfileHandler().getTorchflower().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.TORCHFLOWER.experience.amount"));
        main.getCropProfileHandler().getTorchflower().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.TORCHFLOWER.worlds.blacklist"));
        main.getCropProfileHandler().getTorchflower().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_TORCHFLOWER));
        main.getCropProfileHandler().getTorchflower().setMaterial(XMaterial.TORCHFLOWER.parseMaterial());
        main.getCropProfileHandler().getPumpkin().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.PUMPKIN.general.enabled"));
        main.getCropProfileHandler().getPumpkin().setDropOnlyIfNaturallyGrown(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.PUMPKIN.experience.dropOnlyIfNaturallyGrown"));
        main.getCropProfileHandler().getPumpkin().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.PUMPKIN.experience.dropOnBreak"));
        main.getCropProfileHandler().getPumpkin().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.PUMPKIN.permission.enabled"));
        main.getCropProfileHandler().getPumpkin().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.PUMPKIN.experience.amount"));
        main.getCropProfileHandler().getPumpkin().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.PUMPKIN.worlds.blacklist"));
        main.getCropProfileHandler().getPumpkin().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_PUMPKIN));
        if (this.isVersionOrHigher("1.13")) {
            main.getCropProfileHandler().getPumpkin().setMaterial(XMaterial.PUMPKIN.parseMaterial());
        } else {
            main.getCropProfileHandler().getPumpkin().setMaterial(Material.matchMaterial((String)"PUMPKIN"));
        }
        main.getCropProfileHandler().getMelon().setEnabled(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.MELON.general.enabled"));
        main.getCropProfileHandler().getMelon().setDropOnlyIfNaturallyGrown(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.MELON.experience.dropOnlyIfNaturallyGrown"));
        main.getCropProfileHandler().getMelon().setDropOnBreak(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.MELON.experience.dropOnBreak"));
        main.getCropProfileHandler().getMelon().setPermissionRequired(main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.MELON.permission.enabled"));
        main.getCropProfileHandler().getMelon().setExperienceAmount(main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.MELON.experience.amount"));
        main.getCropProfileHandler().getMelon().setWorldBlacklist(main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.MELON.worlds.blacklist"));
        main.getCropProfileHandler().getMelon().setPermission(main.getPermHandler().getPermMap().get((Object)HEXPPerm.USER_GAIN_MELON));
        main.getCropProfileHandler().getMelon().setMaterial(XMaterial.MELON.parseMaterial());
    }

    public String getEditablePrefix() {
        return this.editablePrefix;
    }

    public HashMap<String, MessageObject> getMessageMap() {
        return this.messageMap;
    }

    public HashMap<String, SoundObject> getSoundMap() {
        return this.soundMap;
    }

    public Boolean getScytherAutosellEnabled() {
        return this.scytherAutosellEnabled;
    }

    public Boolean getScytherAutocollectEnabled() {
        return this.scytherAutocollectEnabled;
    }

    public Boolean getNotifyForUpdates() {
        return this.notifyForUpdates;
    }

    public Boolean getStripConsole() {
        return this.stripConsole;
    }
}

