/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.profiles.objects.cache;

import dev.norska.hexp.profiles.objects.cache.CacheableProfileable;
import java.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class TimedCacheableProfileable
extends CacheableProfileable {
    private long lastUpdate;

    @NotNull
    protected Duration expiresAfter() {
        return Duration.ofHours(6L);
    }

    @Override
    public final boolean hasExpired(boolean renew) {
        if (super.hasExpired(renew)) {
            return true;
        }
        if (this.cache == null && this.lastError == null) {
            return true;
        }
        Duration expiresAfter = this.expiresAfter();
        if (expiresAfter.isZero()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.lastUpdate == 0L) {
            if (renew) {
                this.lastUpdate = now;
            }
            return true;
        }
        long diff = now - this.lastUpdate;
        if (diff >= expiresAfter.toMillis()) {
            if (renew) {
                this.lastUpdate = now;
            }
            return true;
        }
        return false;
    }
}

