/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hexp.utils;

import dev.norska.hexp.data.CropProfile;
import dev.norska.hexp.data.ProfileMelon;
import dev.norska.hexp.data.ProfilePumpkin;
import dev.norska.hexp.data.ProfileTorchflower;
import dev.norska.hexp.ndev.debug.NDebug;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class HEXPUtils {
    private List<Location> manuallyPlaced = new ArrayList<Location>();

    public Boolean checkIfBreakable(CropProfile profile, Block b, Player p) {
        if ((profile instanceof ProfileMelon || profile instanceof ProfilePumpkin || profile instanceof ProfileTorchflower) && profile.getDropOnlyIfNaturallyGrown().booleanValue()) {
            boolean naturallyGrown = !this.manuallyPlaced.contains(b.getLocation());
            NDebug.message(p, "RETURN " + naturallyGrown + " due to getDropOnlyIfNaturallyGrown - HEXPUtils");
            return naturallyGrown;
        }
        if (profile.getDropOnlyIfRipe().booleanValue()) {
            boolean ripe = profile.isRipe(b);
            NDebug.message(p, "RETURN " + ripe + " due to getDropOnlyIfRipe // Age Parameter " + b.getState().getBlockData() + " - HEXPUtils");
            return ripe;
        }
        return false;
    }

    public String serializeLocation(Location location) {
        return location.getWorld().getName() + "~" + location.getBlockX() + "~" + location.getBlockY() + "~" + location.getBlockZ();
    }

    public Location deserializeLocation(String locationString) {
        String[] splitString = locationString.split("~");
        String worldName = splitString[0];
        int X = Integer.parseInt(splitString[1]);
        int Y = Integer.parseInt(splitString[2]);
        int Z = Integer.parseInt(splitString[3]);
        return new Location(Bukkit.getWorld((String)worldName), (double)X, (double)Y, (double)Z);
    }

    public List<Location> getManuallyPlaced() {
        return this.manuallyPlaced;
    }
}

