/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.client.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import world.landfall.persona.client.gui.CharacterManagementScreen;
import world.landfall.persona.client.gui.UIErrorHandler;
import world.landfall.persona.client.gui.input.CharacterCreationInputProvider;
import world.landfall.persona.client.gui.input.CharacterCreationInputRegistry;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.PersonaNetworking;

public class CharacterCreationScreen
extends Screen {
    private static final int WIDTH = 200;
    private static final int BASE_HEIGHT = 100;
    private static final int INPUT_FIELD_HEIGHT = 20;
    private static final int INPUT_FIELD_SPACING = 10;
    private static final int LABEL_HEIGHT = 10;
    private static final int SECTION_SPACING = 15;
    private static final int PADDING = 10;
    private final Screen parent;
    private EditBox nameBox;
    private final Map<ResourceLocation, EditBox> inputFields = new HashMap<ResourceLocation, EditBox>();
    private Button createButton;

    public CharacterCreationScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.persona.create_character"));
        this.parent = Objects.requireNonNull(parent, "Parent screen cannot be null");
    }

    protected void init() {
        super.init();
        this.inputFields.clear();
        List<CharacterCreationInputProvider> providers = CharacterCreationInputRegistry.getAll();
        List<CharacterCreationInputProvider> visibleProviders = providers.stream().filter(CharacterCreationInputProvider::isVisible).toList();
        int totalHeight = 100 + visibleProviders.size() * 55;
        int guiLeft = (this.width - 200) / 2;
        int guiTop = (this.height - totalHeight) / 2;
        int currentY = guiTop + 10 + 10;
        this.nameBox = new EditBox(this.font, guiLeft + 10, currentY, 180, 20, (Component)Component.translatable((String)"screen.persona.character_name_prompt"));
        this.nameBox.setMaxLength(32);
        this.nameBox.setValue("");
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        currentY += 45;
        for (CharacterCreationInputProvider provider : visibleProviders) {
            EditBox inputField = provider.createEditBox(this.font, guiLeft + 10, currentY, 180, 20);
            this.addRenderableWidget((GuiEventListener)inputField);
            this.inputFields.put(provider.getId(), inputField);
            currentY += 45;
        }
        int buttonY = guiTop + totalHeight - 30 - 10;
        this.createButton = Button.builder((Component)Component.translatable((String)"button.persona.create"), button -> this.createCharacter()).bounds(guiLeft + 10, buttonY, 85, 20).build();
        this.addRenderableWidget((GuiEventListener)this.createButton);
        Button cancelButton = Button.builder((Component)Component.translatable((String)"button.persona.cancel"), button -> this.handleCancel()).bounds(guiLeft + 200 - 85 - 10, buttonY, 85, 20).build();
        this.addRenderableWidget((GuiEventListener)cancelButton);
    }

    private void handleCancel() {
        Optional<PlayerCharacterData> data;
        if (this.minecraft == null) {
            return;
        }
        if (this.parent instanceof CharacterManagementScreen && (data = Optional.ofNullable(this.minecraft.player).map(player -> (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA))).map(d -> d.getCharacterCount() == 0).orElse(false).booleanValue()) {
            this.minecraft.setScreen(null);
            return;
        }
        this.minecraft.setScreen(this.parent);
    }

    public void tick() {
        super.tick();
    }

    private void createCharacter() {
        String name = this.nameBox.getValue().trim();
        if (name.isEmpty()) {
            UIErrorHandler.showError("gui.persona.error.name_empty");
            return;
        }
        if (!CharacterProfile.isValidName(name)) {
            UIErrorHandler.showError("command.persona.error.invalid_name");
            return;
        }
        HashMap<ResourceLocation, CompoundTag> modDataMap = new HashMap<ResourceLocation, CompoundTag>();
        for (CharacterCreationInputProvider provider : CharacterCreationInputRegistry.getAll()) {
            ResourceLocation providerId = provider.getId();
            EditBox inputField = this.inputFields.get(providerId);
            if (inputField == null) continue;
            String input = inputField.getValue().trim();
            if (provider.isRequired() && input.isEmpty()) {
                UIErrorHandler.showError("gui.persona.error.required_field_empty", provider.getDisplayName());
                return;
            }
            if (input.isEmpty()) continue;
            if (!provider.validateInput(input)) {
                UIErrorHandler.showError(provider.getValidationErrorMessage(input).getString());
                return;
            }
            CompoundTag tag = new CompoundTag();
            provider.processInput(input, tag);
            modDataMap.put(providerId, tag);
        }
        this.createButton.active = false;
        PersonaNetworking.sendCreateWithModData(name, modDataMap, true);
    }

    public void handleSuccessfulCreation() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public void handleFailedCreation(String errorKey, Object ... args) {
        this.createButton.active = true;
        UIErrorHandler.showError(errorKey, args);
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Objects.requireNonNull(graphics, "GuiGraphics cannot be null");
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        List<CharacterCreationInputProvider> providers = CharacterCreationInputRegistry.getAll();
        List<CharacterCreationInputProvider> visibleProviders = providers.stream().filter(CharacterCreationInputProvider::isVisible).toList();
        int totalHeight = 100 + visibleProviders.size() * 55;
        int guiLeft = (this.width - 200) / 2;
        int guiTop = (this.height - totalHeight) / 2;
        graphics.drawCenteredString(this.font, this.title, this.width / 2, guiTop - 20, 0xFFFFFF);
        graphics.fill(guiLeft - 5, guiTop - 5, guiLeft + 200 + 5, guiTop + totalHeight + 5, Integer.MIN_VALUE);
        if (this.font != null) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"screen.persona.character_name"), guiLeft + 10, guiTop + 10, 0xFFFFFF);
            int currentY = guiTop + 10 + 10 + 20 + 15;
            for (CharacterCreationInputProvider provider : visibleProviders) {
                graphics.drawString(this.font, provider.getDisplayName(), guiLeft + 10, currentY, 0xFFFFFF);
                currentY += 45;
            }
        }
        this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTick));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.createCharacter();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

