/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import world.landfall.persona.Persona;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterFileStorage;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.CharacterTransactionManager;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.features.aging.AgingManager;
import world.landfall.persona.registry.GlobalCharacterRegistry;
import world.landfall.persona.registry.PersonaEvents;
import world.landfall.persona.registry.PersonaNetworking;
import world.landfall.persona.registry.RegistryPersistence;
import world.landfall.persona.statecraft.StatecraftAPI;
import world.landfall.persona.util.CharacterSwitchCooldownManager;
import world.landfall.persona.util.CharacterUtils;

public class CommandRegistry {
    private static void sendError(ServerPlayer player, Component message, boolean fromGui) {
        if (!fromGui) {
            player.sendSystemMessage((Component)message.copy().withStyle(style -> style.withColor(0xFF0000)));
        }
    }

    private static void sendSuccess(ServerPlayer player, Component message, boolean fromGui) {
        if (!fromGui) {
            player.sendSystemMessage(message);
        }
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder personaCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"persona").then(Commands.literal((String)"create").then(Commands.argument((String)"displayName", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::createCharacter)))).then(Commands.literal((String)"switch").then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::switchCharacter)))).then(Commands.literal((String)"list").executes(CommandRegistry::listCharacters))).then(Commands.literal((String)"delete").then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::deleteCharacter)))).then(Commands.literal((String)"rename").then(Commands.argument((String)"newName", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::renameCharacter)))).then(((LiteralArgumentBuilder)Commands.literal((String)"password").then(Commands.argument((String)"password", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::setStatecraftPassword))).executes(CommandRegistry::passwordHelp));
        LiteralArgumentBuilder debugCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"registry").executes(CommandRegistry::debugRegistry))).then(Commands.literal((String)"characterdata").then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::debugCharacterData)))).then(Commands.literal((String)"ageinfo").then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::debugAgeInfo)))).then(Commands.literal((String)"setdeceased").then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"isDeceased", (ArgumentType)BoolArgumentType.bool()).executes(CommandRegistry::debugSetDeceased))));
        personaCommand.then((ArgumentBuilder)debugCommand);
        LiteralArgumentBuilder adminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"listall").then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.word()).executes(CommandRegistry::adminListCharacters)))).then(Commands.literal((String)"forcedelete").then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::adminDeleteCharacter))))).then(Commands.literal((String)"forcerename").then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"characterNameOrUUID", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"newName", (ArgumentType)StringArgumentType.string()).executes(CommandRegistry::adminRenameCharacter)))))).then(Commands.literal((String)"clearcooldown").then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.word()).executes(CommandRegistry::adminClearCooldown)));
        personaCommand.then((ArgumentBuilder)adminCommand);
        dispatcher.register(personaCommand);
    }

    private static int createCharacter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String displayName = StringArgumentType.getString(context, (String)"displayName");
        HashMap<ResourceLocation, CompoundTag> modData = new HashMap<ResourceLocation, CompoundTag>();
        CommandRegistry.internalCreateCharacter(player, displayName, false, modData);
        return 1;
    }

    private static int switchCharacter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        CommandRegistry.switchCharacter(player, nameOrUUID, false);
        return 1;
    }

    private static int listCharacters(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null || characterData.getCharacters().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.persona.error.no_characters"), false);
            return 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\u00a76=== Your Characters ===\u00a7r\n");
        characterData.getCharacters().forEach((uuid, profile) -> {
            if (uuid.equals(characterData.getActiveCharacterId())) {
                sb.append("\u00a7a\u27a4 ");
            } else {
                sb.append("\u00a77\u2022 ");
            }
            sb.append("\u00a7f").append(profile.getDisplayName());
            sb.append(" \u00a78(").append(uuid.toString().substring(0, 8)).append(")");
            if (uuid.equals(characterData.getActiveCharacterId())) {
                sb.append(" \u00a7a(Active)");
            }
            sb.append("\u00a7r\n");
        });
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int deleteCharacter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        if (!((Boolean)Config.ENABLE_CHARACTER_DELETION.get()).booleanValue()) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.deletion_disabled"), false);
            return 0;
        }
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), false);
            return 0;
        }
        Long foundCharacterId = null;
        try {
            foundCharacterId = Long.parseLong(nameOrUUID);
        }
        catch (NumberFormatException e) {
            for (CharacterProfile profile : characterData.getCharacters().values()) {
                if (!profile.getDisplayName().equalsIgnoreCase(nameOrUUID)) continue;
                foundCharacterId = profile.getId();
                break;
            }
        }
        if (foundCharacterId == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}), false);
            return 0;
        }
        CharacterProfile targetProfile = characterData.getCharacter(foundCharacterId);
        if (targetProfile == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}), false);
            return 0;
        }
        if (foundCharacterId.equals(characterData.getActiveCharacterId())) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.delete_active"), false);
            return 0;
        }
        PersonaEvents.CharacterDeleteEvent deleteEvent = new PersonaEvents.CharacterDeleteEvent((Player)player, foundCharacterId);
        NeoForge.EVENT_BUS.post((Event)deleteEvent);
        if (deleteEvent.isCanceled()) {
            return 0;
        }
        String characterName = targetProfile.getDisplayName();
        boolean success = CharacterTransactionManager.deleteCharacter(player.getUUID(), foundCharacterId, characterName);
        if (!success) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.deletion_failed", (Object[])new Object[]{characterName}));
            return 0;
        }
        characterData.getCharacterIds().remove(foundCharacterId);
        if (characterData.getActiveCharacterId() != null && characterData.getActiveCharacterId().equals(foundCharacterId)) {
            characterData.setActiveCharacterId(null);
        }
        PersonaNetworking.sendToPlayer(characterData, player);
        CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)"command.persona.success.delete", (Object[])new Object[]{targetProfile.getDisplayName()}), false);
        return 1;
    }

    private static int renameCharacter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String newName = StringArgumentType.getString(context, (String)"newName");
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), false);
            return 0;
        }
        Long activeCharacterId = characterData.getActiveCharacterId();
        if (activeCharacterId == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.no_active_char"), false);
            return 0;
        }
        CharacterProfile activeProfile = characterData.getCharacter(activeCharacterId);
        if (activeProfile == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.active_char_not_found"), false);
            return 0;
        }
        if (!CharacterProfile.isValidName(newName)) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.invalid_name"), false);
            return 0;
        }
        if (!newName.equalsIgnoreCase(activeProfile.getDisplayName()) && GlobalCharacterRegistry.isNameTaken(newName)) {
            Optional<Long> existingCharId = GlobalCharacterRegistry.getCharacterIdByName(newName);
            Optional ownerUUID = existingCharId.flatMap(GlobalCharacterRegistry::getPlayerForCharacter);
            String errorKey = ownerUUID.isPresent() && ((UUID)ownerUUID.get()).equals(player.getUUID()) ? "command.persona.error.name_taken_self" : "command.persona.error.name_taken_other";
            CommandRegistry.sendError(player, (Component)Component.translatable((String)errorKey, (Object[])new Object[]{newName}), false);
            return 0;
        }
        String oldName = activeProfile.getDisplayName();
        GlobalCharacterRegistry.unregisterCharacter(activeCharacterId, oldName);
        activeProfile.setDisplayName(newName);
        GlobalCharacterRegistry.registerCharacter(activeCharacterId, player.getUUID(), newName);
        CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)"command.persona.success.renamed", (Object[])new Object[]{newName}), false);
        return 1;
    }

    private static int debugRegistry(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Map<Long, UUID> characterToPlayerMap = GlobalCharacterRegistry.getCharacterToPlayerMap();
        Map<String, Long> characterNameMap = GlobalCharacterRegistry.getCharacterNameMap();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\u00a76=== Character Registry Debug ===\u00a7r\n");
        sb.append("\n\u00a7eCharacter to Player Mappings:\u00a7r\n");
        if (characterToPlayerMap.isEmpty()) {
            sb.append("\u00a77  No character mappings found\u00a7r\n");
        } else {
            characterToPlayerMap.forEach((charId, playerId) -> {
                String characterName = characterNameMap.entrySet().stream().filter(entry -> ((Long)entry.getValue()).equals(charId)).map(Map.Entry::getKey).findFirst().orElse("Unknown");
                sb.append("\u00a77\u2022 \u00a7f").append(characterName).append(" \u00a78(").append(charId.toString().substring(0, 8)).append(")").append(" \u00a77\u2192 \u00a7f").append(playerId.toString().substring(0, 8)).append("\u00a7r\n");
            });
        }
        sb.append("\n\u00a7eCharacter Name Mappings:\u00a7r\n");
        if (characterNameMap.isEmpty()) {
            sb.append("\u00a77  No name mappings found\u00a7r\n");
        } else {
            characterNameMap.forEach((name, charId) -> sb.append("\u00a77\u2022 \u00a7f").append((String)name).append(" \u00a77\u2192 \u00a78").append(charId.toString().substring(0, 8)).append("\u00a7r\n"));
        }
        Path registryPath = RegistryPersistence.getRegistryPath();
        if (registryPath != null) {
            sb.append("\n\u00a7eRegistry File Location:\u00a7r\n");
            sb.append("\u00a77  ").append(registryPath).append("\u00a7r\n");
        }
        source.sendSuccess(() -> Component.literal((String)sb.toString()), false);
        return 1;
    }

    private static int adminListCharacters(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"playerName");
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.player_not_found", (Object[])new Object[]{playerName}));
            return 0;
        }
        PlayerCharacterData characterData = (PlayerCharacterData)targetPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null || characterData.getCharacterCount() == 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.persona.admin.no_characters", (Object[])new Object[]{playerName}), false);
            return 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\u00a76=== Characters for \u00a7f").append(playerName).append(" \u00a76===\u00a7r\n");
        characterData.getCharacterIds().forEach((uuid, displayName) -> {
            if (uuid.equals(characterData.getActiveCharacterId())) {
                sb.append("\u00a7a\u27a4 ");
            } else {
                sb.append("\u00a77\u2022 ");
            }
            sb.append("\u00a7f").append((String)displayName);
            sb.append(" \u00a78(").append(uuid.toString().substring(0, 8)).append(")");
            if (uuid.equals(characterData.getActiveCharacterId())) {
                sb.append(" \u00a7a(Active)");
            }
            sb.append("\u00a7r\n");
        });
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        return 1;
    }

    private static int adminDeleteCharacter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"playerName");
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.player_not_found", (Object[])new Object[]{playerName}));
            return 0;
        }
        PlayerCharacterData characterData = (PlayerCharacterData)targetPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.data_not_found"));
            return 0;
        }
        Long foundCharacterId = CommandRegistry.findCharacterId(nameOrUUID, characterData);
        if (foundCharacterId == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}));
            return 0;
        }
        CharacterProfile targetProfile = characterData.getCharacter(foundCharacterId);
        if (targetProfile == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}));
            return 0;
        }
        if (foundCharacterId.equals(characterData.getActiveCharacterId())) {
            Long oldActiveCharacterId = characterData.getActiveCharacterId();
            Optional<Long> newActiveId = characterData.getCharacterIds().keySet().stream().filter(id -> !id.equals(foundCharacterId)).findFirst();
            if (newActiveId.isPresent()) {
                characterData.setActiveCharacterId(newActiveId.get());
                NeoForge.EVENT_BUS.post((Event)new PersonaEvents.CharacterSwitchEvent((Player)targetPlayer, oldActiveCharacterId, newActiveId.get()));
            } else {
                characterData.setActiveCharacterId(null);
                NeoForge.EVENT_BUS.post((Event)new PersonaEvents.CharacterSwitchEvent((Player)targetPlayer, oldActiveCharacterId, null));
            }
        }
        String characterName = targetProfile.getDisplayName();
        boolean success = CharacterTransactionManager.deleteCharacter(targetPlayer.getUUID(), foundCharacterId, characterName);
        if (!success) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.deletion_failed", (Object[])new Object[]{characterName}));
            return 0;
        }
        characterData.getCharacterIds().remove(foundCharacterId);
        if (characterData.getActiveCharacterId() != null && characterData.getActiveCharacterId().equals(foundCharacterId)) {
            characterData.setActiveCharacterId(null);
        }
        PersonaNetworking.sendToPlayer(characterData, targetPlayer);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.persona.admin.success.delete", (Object[])new Object[]{characterName, playerName}), true);
        return 1;
    }

    private static int adminRenameCharacter(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"playerName");
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        String newName = StringArgumentType.getString(context, (String)"newName");
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.player_not_found", (Object[])new Object[]{playerName}));
            return 0;
        }
        PlayerCharacterData characterData = (PlayerCharacterData)targetPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.data_not_found"));
            return 0;
        }
        Long foundCharacterId = CommandRegistry.findCharacterId(nameOrUUID, characterData);
        if (foundCharacterId == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}));
            return 0;
        }
        CharacterProfile targetProfile = characterData.getCharacter(foundCharacterId);
        if (targetProfile == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}));
            return 0;
        }
        if (!CharacterProfile.isValidName(newName)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.invalid_name"));
            return 0;
        }
        if (!newName.equalsIgnoreCase(targetProfile.getDisplayName()) && GlobalCharacterRegistry.isNameTaken(newName)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.name_taken_other", (Object[])new Object[]{newName}));
            return 0;
        }
        String oldName = targetProfile.getDisplayName();
        GlobalCharacterRegistry.unregisterCharacter(foundCharacterId, oldName);
        targetProfile.setDisplayName(newName);
        GlobalCharacterRegistry.registerCharacter(foundCharacterId, targetPlayer.getUUID(), newName);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.persona.admin.success.rename", (Object[])new Object[]{oldName, newName, playerName}), true);
        return 1;
    }

    private static int adminClearCooldown(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"playerName");
        ServerPlayer targetPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName);
        if (targetPlayer == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.player_not_found", (Object[])new Object[]{playerName}));
            return 0;
        }
        CharacterSwitchCooldownManager.clearCooldown(targetPlayer);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.persona.admin.success.clear_cooldown", (Object[])new Object[]{playerName}), true);
        return 1;
    }

    private static Long findCharacterId(String nameOrUUID, PlayerCharacterData characterData) {
        try {
            return Long.parseLong(nameOrUUID);
        }
        catch (NumberFormatException e) {
            for (Map.Entry<Long, String> entry : characterData.getCharacterIds().entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(nameOrUUID)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    public static void createCharacter(ServerPlayer player, String displayName) {
        CommandRegistry.createCharacter(player, displayName, false);
    }

    public static void createCharacter(ServerPlayer player, String displayName, boolean fromGui) {
        CommandRegistry.internalCreateCharacter(player, displayName, fromGui, new HashMap<ResourceLocation, CompoundTag>());
    }

    public static void createCharacter(ServerPlayer player, String displayName, boolean fromGui, Map<ResourceLocation, CompoundTag> modData) {
        CommandRegistry.internalCreateCharacter(player, displayName, fromGui, modData);
    }

    private static void internalCreateCharacter(ServerPlayer player, String displayName, boolean fromGui, Map<ResourceLocation, CompoundTag> modData) {
        String successKey;
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.data_not_found", new String[0]);
            }
            return;
        }
        if (characterData.getNonDeceasedCharacterCount() >= (Integer)Config.MAX_CHARACTERS_PER_PLAYER.get()) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.max_characters", (Object[])new Object[]{Config.MAX_CHARACTERS_PER_PLAYER.get()}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.max_characters", String.valueOf(Config.MAX_CHARACTERS_PER_PLAYER.get()));
            }
            return;
        }
        if (!CharacterProfile.isValidName(displayName)) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.invalid_name"), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.invalid_name", new String[0]);
            }
            return;
        }
        if (GlobalCharacterRegistry.isNameTaken(displayName)) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.name_taken", (Object[])new Object[]{displayName}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.name_taken", displayName);
            }
            return;
        }
        CharacterProfile newProfile = new CharacterProfile(0L, displayName);
        if (modData != null && !modData.isEmpty()) {
            Persona.LOGGER.debug("[Persona] Applying modData to new character {}: {}", (Object)displayName, modData.keySet());
            modData.forEach(newProfile::setModData);
        }
        AgingManager.handleCharacterCreationWithModData(newProfile, modData);
        AgingManager.calculateAndUpdateAge(newProfile);
        Persona.LOGGER.debug("[Persona] Initial age calculation triggered for new character {}.", (Object)displayName);
        long createdCharacterId = CharacterTransactionManager.createCharacter(player.getUUID(), displayName, newProfile);
        if (createdCharacterId == -1L) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.creation_failed", (Object[])new Object[]{displayName}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.creation_failed", displayName);
            }
            return;
        }
        newProfile = new CharacterProfile(createdCharacterId, displayName, false);
        if (modData != null && !modData.isEmpty()) {
            modData.forEach(newProfile::setModData);
        }
        characterData.addCharacter(createdCharacterId, newProfile.getDisplayName());
        Persona.LOGGER.debug("[Persona] Posting CharacterCreateEvent for player: {}, character: {}", (Object)player.getName().getString(), (Object)newProfile.getDisplayName());
        NeoForge.EVENT_BUS.post((Event)new PersonaEvents.CharacterCreateEvent((Player)player, newProfile.getId(), newProfile));
        if (characterData.getActiveCharacterId() == null) {
            Long oldActiveCharacterId = characterData.getActiveCharacterId();
            characterData.setActiveCharacterId(createdCharacterId);
            successKey = "command.persona.success.create_set_active";
            Persona.LOGGER.debug("[Persona] Posting CharacterSwitchEvent for newly created character: {}", (Object)displayName);
            NeoForge.EVENT_BUS.post((Event)new PersonaEvents.CharacterSwitchEvent((Player)player, oldActiveCharacterId, createdCharacterId));
        } else {
            successKey = "command.persona.success.create";
        }
        if (fromGui) {
            PersonaNetworking.sendCreationResponseToPlayer(player, true, successKey, newProfile.getDisplayName(), String.valueOf(createdCharacterId));
        } else {
            CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)successKey, (Object[])new Object[]{newProfile.getDisplayName(), String.valueOf(createdCharacterId)}), false);
        }
        PersonaNetworking.sendToPlayer(characterData, player);
    }

    public static void switchCharacter(ServerPlayer player, String nameOrUUID) {
        CommandRegistry.switchCharacter(player, nameOrUUID, false);
    }

    public static void switchCharacter(ServerPlayer player, String nameOrUUID, boolean fromGui) {
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.data_not_found", new String[0]);
            }
            return;
        }
        if (!CharacterSwitchCooldownManager.canSwitchCharacter(player)) {
            int remainingSeconds = CharacterSwitchCooldownManager.getRemainingCooldownSeconds(player);
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.switch_cooldown", (Object[])new Object[]{remainingSeconds}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.switch_cooldown", String.valueOf(remainingSeconds));
            }
            return;
        }
        Long foundCharacterId = CommandRegistry.findCharacterId(nameOrUUID, characterData);
        if (foundCharacterId == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.not_found", nameOrUUID);
            }
            return;
        }
        CharacterProfile targetProfile = characterData.getCharacter(foundCharacterId);
        if (targetProfile == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.char_not_found_or_not_yours", nameOrUUID);
            }
            return;
        }
        if (targetProfile.isDeceased()) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.char_is_deceased", (Object[])new Object[]{targetProfile.getDisplayName()}), fromGui);
            return;
        }
        Long oldActiveCharacterId = characterData.getActiveCharacterId();
        if (foundCharacterId.equals(oldActiveCharacterId)) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.already_active", (Object[])new Object[]{targetProfile.getDisplayName()}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.already_active", targetProfile.getDisplayName());
            }
            return;
        }
        PersonaEvents.CharacterPreSwitchEvent preSwitchEvent = new PersonaEvents.CharacterPreSwitchEvent((Player)player, oldActiveCharacterId, foundCharacterId);
        Persona.LOGGER.debug("[Persona] Posting CharacterPreSwitchEvent for player: {}, from: {}, to: {}", new Object[]{player.getName().getString(), oldActiveCharacterId != null ? oldActiveCharacterId.toString() : "null", foundCharacterId.toString()});
        NeoForge.EVENT_BUS.post((Event)preSwitchEvent);
        CompletableFuture<Void> readyFuture = preSwitchEvent.getReady();
        try {
            readyFuture.get(5L, TimeUnit.SECONDS);
            Persona.LOGGER.debug("[Persona] CharacterPreSwitchEvent async gate completed successfully");
        }
        catch (Exception e) {
            Persona.LOGGER.warn("[Persona] CharacterPreSwitchEvent async gate timed out or failed: {}", (Object)e.getMessage());
        }
        characterData.setActiveCharacterId(foundCharacterId);
        CharacterProfile newActiveProfile = characterData.getCharacter(foundCharacterId);
        if (newActiveProfile != null) {
            AgingManager.triggerAgeUpdate(player, newActiveProfile);
            Persona.LOGGER.debug("[Persona] Triggered age update for {} during switch.", (Object)newActiveProfile.getDisplayName());
        }
        NeoForge.EVENT_BUS.post((Event)new PersonaEvents.CharacterSwitchEvent((Player)player, oldActiveCharacterId, foundCharacterId));
        CharacterSwitchCooldownManager.recordCharacterSwitch(player);
        PersonaNetworking.sendToPlayer(characterData, player);
        CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)"command.persona.success.switch", (Object[])new Object[]{targetProfile.getDisplayName()}), fromGui);
        if (fromGui) {
            PersonaNetworking.sendCreationResponseToPlayer(player, true, "command.persona.success.switch", targetProfile.getDisplayName());
        }
    }

    public static void deleteCharacter(ServerPlayer player, String nameOrUUID) {
        CommandRegistry.deleteCharacter(player, nameOrUUID, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteCharacter(ServerPlayer player, String nameOrUUID, boolean fromGui) {
        if (!((Boolean)Config.ENABLE_CHARACTER_DELETION.get()).booleanValue()) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.deletion_disabled"), fromGui);
            return;
        }
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), fromGui);
            return;
        }
        Long foundCharacterId = null;
        try {
            foundCharacterId = Long.parseLong(nameOrUUID);
        }
        catch (NumberFormatException e) {
            for (Map.Entry<Long, String> entry : characterData.getCharacterIds().entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(nameOrUUID)) continue;
                foundCharacterId = entry.getKey();
                break;
            }
        }
        if (foundCharacterId == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}), fromGui);
            return;
        }
        CharacterProfile targetProfile = characterData.getCharacter(foundCharacterId);
        if (targetProfile == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}), fromGui);
            return;
        }
        if (foundCharacterId.equals(characterData.getActiveCharacterId())) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.delete_active"), fromGui);
            return;
        }
        PersonaEvents.CharacterDeleteEvent deleteEvent = new PersonaEvents.CharacterDeleteEvent((Player)player, foundCharacterId);
        NeoForge.EVENT_BUS.post((Event)deleteEvent);
        if (deleteEvent.isCanceled()) {
            return;
        }
        String characterName = targetProfile.getDisplayName();
        boolean success = CharacterTransactionManager.deleteCharacter(player.getUUID(), foundCharacterId, characterName);
        if (!success) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.deletion_failed", (Object[])new Object[]{characterName}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.deletion_failed", characterName);
            }
            return;
        }
        characterData.removeCharacter(foundCharacterId);
        if (characterData.getActiveCharacterId() != null && characterData.getActiveCharacterId().equals(foundCharacterId)) {
            characterData.setActiveCharacterId(null);
        }
        CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)"command.persona.success.delete", (Object[])new Object[]{targetProfile.getDisplayName()}), fromGui);
        if (fromGui) {
            PersonaNetworking.sendCreationResponseToPlayer(player, true, "command.persona.success.delete", targetProfile.getDisplayName());
        }
        PersonaNetworking.sendToPlayer(characterData, player);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void collectItemsFromDeceased(ServerPlayer player, String nameOrUUID, boolean fromGui) {
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), fromGui);
            return;
        }
        Long foundCharacterId = null;
        try {
            foundCharacterId = Long.parseLong(nameOrUUID);
        }
        catch (NumberFormatException e) {
            for (Map.Entry<Long, String> entry : characterData.getCharacterIds().entrySet()) {
                if (!entry.getValue().equalsIgnoreCase(nameOrUUID)) continue;
                foundCharacterId = entry.getKey();
                break;
            }
        }
        if (foundCharacterId == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}), fromGui);
            return;
        }
        CharacterProfile targetProfile = characterData.getCharacter(foundCharacterId);
        if (targetProfile == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}), fromGui);
            return;
        }
        if (!targetProfile.isDeceased()) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.not_deceased", (Object[])new Object[]{targetProfile.getDisplayName()}), fromGui);
            return;
        }
        if (!targetProfile.hasInventory()) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.no_items_to_collect", (Object[])new Object[]{targetProfile.getDisplayName()}), fromGui);
            return;
        }
        PersonaEvents.CharacterDeleteEvent deleteEvent = new PersonaEvents.CharacterDeleteEvent((Player)player, foundCharacterId);
        NeoForge.EVENT_BUS.post((Event)deleteEvent);
        if (deleteEvent.isCanceled()) {
            return;
        }
        String characterName = targetProfile.getDisplayName();
        targetProfile.removeModData(ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"inventory"));
        CharacterFileStorage.saveCharacter(targetProfile);
        boolean deleteSuccess = CharacterFileStorage.deleteCharacter(foundCharacterId);
        if (!deleteSuccess) {
            Persona.LOGGER.warn("[CommandRegistry] Failed to delete character file for {} after collecting items", (Object)characterName);
        }
        characterData.removeCharacter(foundCharacterId);
        CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)"command.persona.success.items_collected_and_removed", (Object[])new Object[]{characterName}), fromGui);
        if (fromGui) {
            PersonaNetworking.sendCreationResponseToPlayer(player, true, "command.persona.success.items_collected_and_removed", characterName);
        }
        PersonaNetworking.sendToPlayer(characterData, player);
    }

    public static void renameCharacter(ServerPlayer player, String newName, boolean fromGui) {
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.data_not_found"), fromGui);
            return;
        }
        Long activeCharacterId = characterData.getActiveCharacterId();
        if (activeCharacterId == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.no_active_char"), fromGui);
            return;
        }
        CharacterProfile activeProfile = characterData.getCharacter(activeCharacterId);
        if (activeProfile == null) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.active_char_not_found"), fromGui);
            return;
        }
        if (!CharacterProfile.isValidName(newName)) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.invalid_name"), fromGui);
            return;
        }
        if (!newName.equalsIgnoreCase(activeProfile.getDisplayName()) && GlobalCharacterRegistry.isNameTaken(newName)) {
            Optional<Long> existingCharId = GlobalCharacterRegistry.getCharacterIdByName(newName);
            Optional ownerUUID = existingCharId.flatMap(GlobalCharacterRegistry::getPlayerForCharacter);
            String errorKey = ownerUUID.isPresent() && ((UUID)ownerUUID.get()).equals(player.getUUID()) ? "command.persona.error.name_taken_self" : "command.persona.error.name_taken_other";
            CommandRegistry.sendError(player, (Component)Component.translatable((String)errorKey, (Object[])new Object[]{newName}), fromGui);
            return;
        }
        String oldName = activeProfile.getDisplayName();
        boolean success = CharacterTransactionManager.updateCharacterName(activeCharacterId, oldName, newName);
        if (!success) {
            CommandRegistry.sendError(player, (Component)Component.translatable((String)"command.persona.error.rename_failed", (Object[])new Object[]{newName}), fromGui);
            if (fromGui) {
                PersonaNetworking.sendCreationResponseToPlayer(player, false, "command.persona.error.rename_failed", newName);
            }
            return;
        }
        characterData.getCharacterIds().put(activeCharacterId, newName);
        PersonaNetworking.sendToPlayer(characterData, player);
        CommandRegistry.sendSuccess(player, (Component)Component.translatable((String)"command.persona.success.renamed", (Object[])new Object[]{newName}), fromGui);
    }

    private static int debugCharacterData(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.data_not_found"));
            return 0;
        }
        CharacterProfile profile = CommandRegistry.findCharacterProfile(nameOrUUID, characterData, player);
        if (profile == null) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n\u00a76=== Character Data for %s (%s) ===\u00a7r\n", profile.getDisplayName(), profile.getId()));
        sb.append(String.format("\u00a7eDisplay Name:\u00a7r %s\n", profile.getDisplayName()));
        sb.append(String.format("\u00a7eID:\u00a7r %s\n", profile.getId()));
        sb.append("\n\u00a76=== ModData ===\u00a7r\n");
        Map<ResourceLocation, CompoundTag> allModData = profile.getModData();
        if (allModData.isEmpty()) {
            sb.append("No mod data found.\n");
        } else {
            allModData.forEach((key, tag) -> {
                sb.append(String.format("\u00a7e%s:\u00a7r\n", key.toString()));
                sb.append(CommandRegistry.tagToString((Tag)tag, 1));
            });
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        return 1;
    }

    private static String tagToString(Tag nbtTag, int indentLevel) {
        StringBuilder sb = new StringBuilder();
        String indent = "  ".repeat(indentLevel);
        if (nbtTag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbtTag;
            if (compoundTag.isEmpty()) {
                sb.append("{}\n");
            } else {
                sb.append("{\n");
                for (String key : compoundTag.getAllKeys()) {
                    sb.append(String.format("%s\u00a7b%s:\u00a7r ", indent, key));
                    sb.append(CommandRegistry.tagToString(compoundTag.get(key), indentLevel + 1));
                }
                sb.append("  ".repeat(indentLevel - 1) + "}\n");
            }
        } else {
            sb.append(nbtTag.getAsString().replace("\n", "\\n")).append("\n");
        }
        return sb.toString();
    }

    private static int debugAgeInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.data_not_found"));
            return 0;
        }
        CharacterProfile profile = CommandRegistry.findCharacterProfile(nameOrUUID, characterData, player);
        if (profile == null) {
            return 0;
        }
        long currentRealTimeMillis = System.currentTimeMillis();
        CompoundTag agingData = profile.getModData(AgingManager.AGING_DATA_KEY);
        long creationTimestampMillis = agingData != null && agingData.contains("CreationTimestampMillis") ? agingData.getLong("CreationTimestampMillis") : -1L;
        double configRatio = (Double)Config.TIME_PASSING_RATIO.get();
        double effectiveRealLifeDaysPerGameYear = configRatio <= 0.0 ? 1.0 : configRatio;
        double currentCalculatedAge = AgingManager.getCalculatedAge(profile);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n\u00a76=== Age Info for %s (Real-Time Based) ===\u00a7r\n", profile.getDisplayName()));
        sb.append(String.format("\u00a7eCurrent Real Time:\u00a7r %d ms\n", currentRealTimeMillis));
        sb.append(String.format("\u00a7eStored CREATION_TIMESTAMP_MILLIS:\u00a7r %d%s\n", creationTimestampMillis, creationTimestampMillis == -1L ? " (Not Set)" : ""));
        sb.append(String.format("\u00a7eConfig TIME_PASSING_RATIO (Real days per game year):\u00a7r %.2f\n", Config.TIME_PASSING_RATIO.get()));
        sb.append(String.format("\u00a7eEffective RealLifeDaysPerGameYearRatio:\u00a7r %.2f\n", effectiveRealLifeDaysPerGameYear));
        sb.append(String.format("\u00a7aCurrent Calculated Age:\u00a7r %.2f game years\n", currentCalculatedAge));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        return 1;
    }

    private static CharacterProfile findCharacterProfile(String nameOrUUID, PlayerCharacterData characterData, ServerPlayer playerForErrorMsg) {
        Long characterId = CommandRegistry.findCharacterId(nameOrUUID, characterData);
        if (characterId == null) {
            CommandRegistry.sendError(playerForErrorMsg, (Component)Component.translatable((String)"command.persona.error.not_found", (Object[])new Object[]{nameOrUUID}), false);
            return null;
        }
        CharacterProfile profile = characterData.getCharacter(characterId);
        if (profile == null) {
            CommandRegistry.sendError(playerForErrorMsg, (Component)Component.translatable((String)"command.persona.error.char_not_found_or_not_yours", (Object[])new Object[]{nameOrUUID}), false);
            return null;
        }
        return profile;
    }

    private static int debugSetDeceased(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String nameOrUUID = StringArgumentType.getString(context, (String)"characterNameOrUUID");
        boolean isDeceased = BoolArgumentType.getBool(context, (String)"isDeceased");
        PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (characterData == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.data_not_found"));
            return 0;
        }
        CharacterProfile profile = CommandRegistry.findCharacterProfile(nameOrUUID, characterData, player);
        if (profile == null) {
            return 0;
        }
        boolean success = CharacterUtils.setCharacterDeceased(player, profile.getId(), isDeceased);
        if (success) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.persona.debug.success.setdeceased", (Object[])new Object[]{profile.getDisplayName(), isDeceased}), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.persona.error.generic_error"));
        return 0;
    }

    private static int passwordHelp(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a76=== Statecraft Password Command ===\u00a7r"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7e/persona password <password>\u00a7f - Set your Statecraft web panel password"), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77This password is tied to your UUID and allows web panel access."), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77You can use your UUID and password to log into the Statecraft web panel."), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77Password must be at least 6 characters long."), false);
        return 1;
    }

    private static int setStatecraftPassword(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String password = StringArgumentType.getString(context, (String)"password");
        if (password.length() < 6) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cPassword must be at least 6 characters long."));
            return 0;
        }
        if (password.length() > 128) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cPassword is too long (maximum 128 characters)."));
            return 0;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            SecureRandom random = new SecureRandom();
            byte[] saltBytes = new byte[16];
            random.nextBytes(saltBytes);
            String salt = Base64.getEncoder().encodeToString(saltBytes);
            String saltedPassword = password + salt;
            byte[] hashBytes = digest.digest(saltedPassword.getBytes(StandardCharsets.UTF_8));
            String hash = Base64.getEncoder().encodeToString(hashBytes);
            StatecraftAPI api = StatecraftAPI.getInstance();
            boolean success = api.setPlayerPassword(player.getUUID(), hash, salt);
            if (success) {
                CharacterProfile activeProfile;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7aPassword set successfully!"), false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Your UUID: \u00a7e" + String.valueOf(player.getUUID()))), false);
                PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
                if (characterData != null && characterData.getActiveCharacterId() != null && (activeProfile = characterData.getCharacter(characterData.getActiveCharacterId())) != null) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Current character: \u00a7e" + activeProfile.getDisplayName())), false);
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77You can now use these credentials to log into the Statecraft web panel."), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cFailed to set password. Please check Statecraft connection."));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cFailed to set password: " + e.getMessage())));
            return 0;
        }
    }
}

