/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.figura;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;
import world.landfall.persona.features.figura.FiguraReflector;
import world.landfall.persona.features.figura.event.ClientPersonaSwitchedEvent;

public class FiguraClientEventListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void onPersonaSwitched(ClientPersonaSwitchedEvent event) {
        if (!FiguraReflector.isFiguraAvailable()) {
            LOGGER.debug("ClientPersonaSwitchedEvent received, but Figura integration is not active. Skipping.");
            return;
        }
        if (Minecraft.getInstance().player == null) {
            LOGGER.debug("ClientPersonaSwitchedEvent received, but player is null. Skipping Figura avatar switch.");
            return;
        }
        String characterDisplayName = event.getNewPersonaDisplayName();
        if (characterDisplayName != null && !characterDisplayName.isEmpty()) {
            LOGGER.debug("ClientPersonaSwitchedEvent: Persona switched to: '{}'. Attempting to apply corresponding Figura avatar.", (Object)characterDisplayName);
            FiguraReflector.performAvatarSwitch(characterDisplayName);
        } else {
            LOGGER.warn("ClientPersonaSwitchedEvent: Persona switched, but character display name from event was null or empty. Cannot apply Figura avatar.");
        }
    }

    public static void triggerFiguraAvatarSwitch(String characterDisplayName) {
        if (!FiguraReflector.isFiguraAvailable()) {
            LOGGER.debug("Request to switch Figura avatar to '{}', but Figura integration is disabled.", (Object)characterDisplayName);
            return;
        }
        if (Minecraft.getInstance().player == null) {
            LOGGER.warn("Request to switch Figura avatar to '{}', but player is null. Skipping.", (Object)characterDisplayName);
            return;
        }
        if (characterDisplayName != null && !characterDisplayName.isEmpty()) {
            LOGGER.debug("Persona system triggered Figura avatar switch for: '{}'.", (Object)characterDisplayName);
            FiguraReflector.performAvatarSwitch(characterDisplayName);
        } else {
            LOGGER.warn("Persona system triggered Figura avatar switch, but character display name was null or empty.");
        }
    }
}

