/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon;

import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.features.landfalladdon.ActionBarManager;
import world.landfall.persona.features.landfalladdon.PersonaLFEIntegration;
import world.landfall.persona.features.landfalladdon.origins.Origin;
import world.landfall.persona.features.landfalladdon.origins.OriginHandler;
import world.landfall.persona.util.CharacterUtils;

@EventBusSubscriber(modid="persona")
public final class GodfallEffectsHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation GODFALL_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"godfall_speed");
    private static final ResourceLocation GODFALL_STRENGTH_ID = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"godfall_strength");
    private static final Map<UUID, Boolean> playersInGodfall = new ConcurrentHashMap<UUID, Boolean>();
    private static volatile int tickCounter = 0;
    private static final int ACTION_BAR_UPDATE_INTERVAL = 20;
    private static final int EFFECT_DURATION_TICKS = 40;
    private static final double SPEED_BOOST_AMOUNT = 0.02;
    private static final double STRENGTH_BOOST_AMOUNT = 2.0;

    private GodfallEffectsHandler() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    @SubscribeEvent
    public static void onPlayerTick(@Nonnull PlayerTickEvent.Post event) {
        if (!((Boolean)Config.ENABLE_LANDFALL_ADDONS.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!PersonaLFEIntegration.isLFEAvailable()) {
            return;
        }
        try {
            GodfallEffectsHandler.processPlayerGodfallEffects(player2);
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error processing godfall effects for player {}: {}", new Object[]{player2.getName().getString(), e.getMessage(), e});
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(@Nonnull LivingDeathEvent event) {
        if (!((Boolean)Config.ENABLE_LANDFALL_ADDONS.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (!PersonaLFEIntegration.isLFEAvailable()) {
            return;
        }
        try {
            GodfallEffectsHandler.processNullbornGodfallDeath(player);
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error processing nullborn godfall death for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    private static void processPlayerGodfallEffects(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            PlayerCharacterData data = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
            if (data == null || data.getActiveCharacterId() == null) {
                return;
            }
            CharacterProfile profile = data.getCharacter(data.getActiveCharacterId());
            if (profile == null || profile.isDeceased()) {
                return;
            }
            boolean inGodfall = PersonaLFEIntegration.isPlayerInGodfallRegion((Player)player);
            UUID playerId = player.getUUID();
            Boolean wasInGodfall = playersInGodfall.get(playerId);
            playersInGodfall.put(playerId, inGodfall);
            Optional<Origin> originOpt = OriginHandler.getOrigin(profile);
            if (originOpt.isEmpty()) {
                if (wasInGodfall != null && wasInGodfall.booleanValue()) {
                    GodfallEffectsHandler.removeAllGodfallEffects(player);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[GodfallEffects] Removed godfall effects for player {} (no origin)", (Object)player.getName().getString());
                    }
                }
                return;
            }
            Origin origin = originOpt.get();
            if (inGodfall) {
                GodfallEffectsHandler.applyGodfallEffects(player, origin);
                if (origin == Origin.NULLBORN && ++tickCounter >= 20) {
                    tickCounter = 0;
                    ActionBarManager.updateActionBarWithCustomMessage(player, "\u00a7c\u00a7lYou are in a godfall zone. If you die, your core will be too unstable to transmit out.");
                }
            } else if (wasInGodfall != null && wasInGodfall.booleanValue()) {
                GodfallEffectsHandler.removeAllGodfallEffects(player);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[GodfallEffects] Removed godfall effects for player {} ({})", (Object)player.getName().getString(), (Object)origin.getDisplayName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error in processPlayerGodfallEffects for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    private static void applyGodfallEffects(@Nonnull ServerPlayer player, @Nonnull Origin origin) {
        Objects.requireNonNull(player, "Player cannot be null");
        Objects.requireNonNull(origin, "Origin cannot be null");
        try {
            switch (origin) {
                case DIVINET_TOUCHED: {
                    GodfallEffectsHandler.applyDivinetTouchedEffects(player);
                    break;
                }
                case NULLBORN: {
                    GodfallEffectsHandler.applyNullbornEffects(player);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error applying godfall effects for player {} (origin: {}): {}", new Object[]{player.getName().getString(), origin.getDisplayName(), e.getMessage(), e});
        }
    }

    private static void applyDivinetTouchedEffects(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            AttributeInstance speedAttr = player.getAttribute(Attributes.MOVEMENT_SPEED);
            if (speedAttr != null) {
                speedAttr.removeModifier(GODFALL_SPEED_ID);
                AttributeModifier speedModifier = new AttributeModifier(GODFALL_SPEED_ID, 0.02, AttributeModifier.Operation.ADD_VALUE);
                speedAttr.addPermanentModifier(speedModifier);
            } else {
                LOGGER.warn("[GodfallEffects] Player {} has no movement speed attribute", (Object)player.getName().getString());
            }
            AttributeInstance attackAttr = player.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attackAttr != null) {
                attackAttr.removeModifier(GODFALL_STRENGTH_ID);
                AttributeModifier strengthModifier = new AttributeModifier(GODFALL_STRENGTH_ID, 2.0, AttributeModifier.Operation.ADD_VALUE);
                attackAttr.addPermanentModifier(strengthModifier);
            } else {
                LOGGER.warn("[GodfallEffects] Player {} has no attack damage attribute", (Object)player.getName().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error applying Divinet-Touched effects for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    private static void applyNullbornEffects(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            MobEffectInstance weakness = new MobEffectInstance(MobEffects.WEAKNESS, 40, 0, false, false, false);
            player.addEffect(weakness);
            MobEffectInstance miningFatigue = new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 40, 0, false, false, false);
            player.addEffect(miningFatigue);
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error applying Nullborn effects for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    private static void removeAllGodfallEffects(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            AttributeInstance attackAttr;
            AttributeInstance speedAttr = player.getAttribute(Attributes.MOVEMENT_SPEED);
            if (speedAttr != null) {
                speedAttr.removeModifier(GODFALL_SPEED_ID);
            }
            if ((attackAttr = player.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                attackAttr.removeModifier(GODFALL_STRENGTH_ID);
            }
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error removing godfall effects for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    private static void processNullbornGodfallDeath(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            PlayerCharacterData data = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
            if (data == null || data.getActiveCharacterId() == null) {
                return;
            }
            CharacterProfile profile = data.getCharacter(data.getActiveCharacterId());
            if (profile == null || profile.isDeceased()) {
                return;
            }
            if (!PersonaLFEIntegration.isPlayerInGodfallRegion((Player)player)) {
                return;
            }
            Optional<Origin> originOpt = OriginHandler.getOrigin(profile);
            if (originOpt.isEmpty() || originOpt.get() != Origin.NULLBORN) {
                return;
            }
            boolean success = CharacterUtils.setCharacterDeceased(player, profile.getId(), true, true);
            if (success) {
                LOGGER.info("[GodfallEffects] Nullborn character '{}' died in godfall region - marked as immediately deceased (auto-switch delayed) for player {}", (Object)profile.getDisplayName(), (Object)player.getName().getString());
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u00a7lYour nullborn core was too unstable to transmit out of the godfall zone. Character '" + profile.getDisplayName() + "' is permanently deceased.")));
            } else {
                LOGGER.error("[GodfallEffects] Failed to mark nullborn character '{}' as deceased after godfall death for player {}", (Object)profile.getDisplayName(), (Object)player.getName().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error processing nullborn godfall death for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    public static void cleanupPlayer(@Nonnull UUID playerId) {
        Objects.requireNonNull(playerId, "Player ID cannot be null");
        try {
            Boolean wasTracked = playersInGodfall.remove(playerId);
            if (wasTracked != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("[GodfallEffects] Cleaned up godfall tracking for player {} (was in godfall: {})", (Object)playerId, (Object)wasTracked);
            }
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error cleaning up player {}: {}", new Object[]{playerId, e.getMessage(), e});
        }
    }

    public static int getTrackedPlayerCount() {
        try {
            return playersInGodfall.size();
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error getting tracked player count: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public static long getPlayersInGodfallCount() {
        try {
            return playersInGodfall.values().stream().filter(Objects::nonNull).filter(Boolean::booleanValue).count();
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error counting players in godfall: {}", (Object)e.getMessage(), (Object)e);
            return 0L;
        }
    }

    public static void clearAllTracking() {
        try {
            int clearedCount = playersInGodfall.size();
            playersInGodfall.clear();
            LOGGER.info("[GodfallEffects] Cleared all godfall tracking data ({} entries)", (Object)clearedCount);
        }
        catch (Exception e) {
            LOGGER.error("[GodfallEffects] Error clearing all tracking data: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

