/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon.shells;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import world.landfall.persona.features.landfalladdon.shells.Shell;

public class ShellManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<Shell> SHELLS_LIST = List.of(Shell.values());
    private static final String UNKNOWN_ORIGIN = "UNKNOWN_ORIGIN";

    public static Shell getRandomShell(String characterOrigin) {
        if (SHELLS_LIST.isEmpty()) {
            LOGGER.error("Shell enum has no values - this should never happen");
            throw new IllegalStateException("No shells available in Shell enum");
        }
        String effectiveOrigin = ShellManager.sanitizeOrigin(characterOrigin);
        LOGGER.debug("Getting random shell for origin: {}", (Object)effectiveOrigin);
        try {
            List<Shell> weightedList = ShellManager.buildWeightedShellList(effectiveOrigin);
            if (weightedList.isEmpty()) {
                LOGGER.debug("No weighted shells found for origin {}, falling back to non-NEUTRAL shells", (Object)effectiveOrigin);
                return ShellManager.getFallbackShell();
            }
            Shell selectedShell = weightedList.get(ThreadLocalRandom.current().nextInt(weightedList.size()));
            LOGGER.debug("Selected shell {} for origin {}", (Object)selectedShell, (Object)effectiveOrigin);
            return selectedShell;
        }
        catch (Exception e) {
            LOGGER.error("Error selecting random shell for origin {}, falling back to NEUTRAL", (Object)effectiveOrigin, (Object)e);
            return Shell.NEUTRAL;
        }
    }

    private static String sanitizeOrigin(String characterOrigin) {
        if (characterOrigin == null || characterOrigin.isBlank()) {
            return UNKNOWN_ORIGIN;
        }
        return characterOrigin.trim().toUpperCase();
    }

    private static List<Shell> buildWeightedShellList(String effectiveOrigin) {
        Objects.requireNonNull(effectiveOrigin, "effectiveOrigin cannot be null");
        ArrayList<Shell> weightedList = new ArrayList<Shell>();
        boolean hasNonNeutralWeights = false;
        for (Shell shell : SHELLS_LIST) {
            if (shell == Shell.NEUTRAL || shell.getWeight(effectiveOrigin) <= 0) continue;
            hasNonNeutralWeights = true;
            break;
        }
        for (Shell shell : SHELLS_LIST) {
            int weight = shell.getWeight(effectiveOrigin);
            if (shell == Shell.NEUTRAL && hasNonNeutralWeights || weight <= 0) continue;
            for (int i = 0; i < weight; ++i) {
                weightedList.add(shell);
            }
        }
        return weightedList;
    }

    private static Shell getFallbackShell() {
        List<Shell> nonNeutralShells = SHELLS_LIST.stream().filter(s -> s != Shell.NEUTRAL).toList();
        if (!nonNeutralShells.isEmpty()) {
            Shell fallback = nonNeutralShells.get(ThreadLocalRandom.current().nextInt(nonNeutralShells.size()));
            LOGGER.debug("Using fallback shell: {}", (Object)fallback);
            return fallback;
        }
        LOGGER.debug("No non-NEUTRAL shells available, using NEUTRAL");
        return Shell.NEUTRAL;
    }

    public static List<Shell> getAllShells() {
        return SHELLS_LIST;
    }

    public static boolean isValidShell(Shell shell) {
        return shell != null && SHELLS_LIST.contains((Object)shell);
    }
}

