/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.location;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.slf4j.Logger;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterFileStorage;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.PersonaEvents;

@EventBusSubscriber(modid="persona")
public class LocationHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation LOCATION_KEY = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"location");

    @SubscribeEvent
    public static void onCreate(PersonaEvents.CharacterCreateEvent event) {
        if (!((Boolean)Config.ENABLE_LOCATION_SYSTEM.get()).booleanValue()) {
            return;
        }
        try {
            LOGGER.debug("[LocationHandler] Create event for player: {}, character: {}", (Object)event.getPlayer().getName().getString(), (Object)event.getCharacterId());
            CharacterProfile profile = event.getProfile();
            if (profile != null) {
                profile.setModData(LOCATION_KEY, new CompoundTag());
                LOGGER.debug("[LocationHandler] Initialized empty location data for character: {}", (Object)event.getCharacterId());
            } else {
                LOGGER.warn("[LocationHandler] CharacterProfile is null for character: {}. Cannot initialize location data.", (Object)event.getCharacterId());
            }
        }
        catch (Exception e) {
            LOGGER.error("[LocationHandler] Error in CharacterCreateEvent handler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPreSwitch(PersonaEvents.CharacterPreSwitchEvent event) {
        if (!((Boolean)Config.ENABLE_LOCATION_SYSTEM.get()).booleanValue()) {
            event.getReady().complete(null);
            return;
        }
        try {
            Player player = event.getPlayer();
            if (!(player instanceof ServerPlayer)) {
                LOGGER.warn("[LocationHandler] Player is not a ServerPlayer, skipping location save.");
                event.getReady().complete(null);
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayer player2 = serverPlayer;
            UUID playerId = player2.getUUID();
            Long fromCharacterId = event.getFromCharacterId();
            LOGGER.debug("[LocationHandler] PreSwitch event for player: {} (ID: {}), from character: {}", new Object[]{player2.getName().getString(), playerId, fromCharacterId});
            if (fromCharacterId != null) {
                PlayerCharacterData characterData = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
                if (characterData == null) {
                    LOGGER.error("[LocationHandler] PlayerCharacterData is null for player {}. Cannot save location.", (Object)playerId);
                    event.getReady().complete(null);
                    return;
                }
                CharacterProfile fromProfile = characterData.getCharacter(fromCharacterId);
                if (fromProfile != null) {
                    fromProfile.setModData(LOCATION_KEY, LocationHandler.saveLocation(player2));
                    CharacterFileStorage.saveCharacter(fromProfile);
                    LOGGER.debug("[LocationHandler] Saved location for character {}. Player: {}", (Object)fromCharacterId, (Object)playerId);
                } else {
                    LOGGER.warn("[LocationHandler] 'From' CharacterProfile is null for character: {}. Cannot save location.", (Object)fromCharacterId);
                }
            } else {
                LOGGER.debug("[LocationHandler] No 'from' character ID, nothing to save for location.");
            }
        }
        catch (Exception e) {
            LOGGER.error("[LocationHandler] Error in PreSwitch event handler for location", (Throwable)e);
        }
        finally {
            event.getReady().complete(null);
        }
    }

    @SubscribeEvent
    public static void onSwitch(PersonaEvents.CharacterSwitchEvent event) {
        if (!((Boolean)Config.ENABLE_LOCATION_SYSTEM.get()).booleanValue()) {
            return;
        }
        try {
            Player player = event.getPlayer();
            if (!(player instanceof ServerPlayer)) {
                LOGGER.warn("[LocationHandler] Player is not a ServerPlayer, skipping location load.");
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayer player2 = serverPlayer;
            UUID playerId = player2.getUUID();
            Long toCharacterId = event.getToCharacterId();
            LOGGER.debug("[LocationHandler] Switch event for player: {} (ID: {}), to character: {}", new Object[]{player2.getName().getString(), playerId, toCharacterId});
            if (toCharacterId != null) {
                PlayerCharacterData characterData = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
                if (characterData == null) {
                    LOGGER.error("[LocationHandler] PlayerCharacterData is null for player {}. Cannot load location.", (Object)playerId);
                    return;
                }
                CharacterProfile toProfile = characterData.getCharacter(toCharacterId);
                if (toProfile != null) {
                    CompoundTag locationTag = toProfile.getModData(LOCATION_KEY);
                    if (locationTag != null && !locationTag.isEmpty()) {
                        LocationHandler.loadLocation(player2, locationTag);
                        LOGGER.debug("[LocationHandler] Loaded location for character {}. Player: {}", (Object)toCharacterId, (Object)playerId);
                    } else {
                        LOGGER.debug("[LocationHandler] No location data found for character {}, player remains at current location. Player: {}", (Object)toCharacterId, (Object)playerId);
                    }
                } else {
                    LOGGER.warn("[LocationHandler] 'To' CharacterProfile is null for character: {}. Cannot load location.", (Object)toCharacterId);
                }
            } else {
                LOGGER.warn("[LocationHandler] 'To' character ID is null. Cannot load location.");
            }
        }
        catch (Exception e) {
            LOGGER.error("[LocationHandler] Error in Switch event handler for location", (Throwable)e);
        }
    }

    public static CompoundTag saveLocation(ServerPlayer player) {
        CompoundTag locationTag = new CompoundTag();
        locationTag.putDouble("x", player.getX());
        locationTag.putDouble("y", player.getY());
        locationTag.putDouble("z", player.getZ());
        locationTag.putFloat("yaw", player.getYRot());
        locationTag.putFloat("pitch", player.getXRot());
        locationTag.putString("dimension", player.level().dimension().location().toString());
        LOGGER.debug("[LocationHandler] Saved location: Dim={}, X={}, Y={}, Z={} for player {}", new Object[]{locationTag.getString("dimension"), locationTag.getDouble("x"), locationTag.getDouble("y"), locationTag.getDouble("z"), player.getName().getString()});
        return locationTag;
    }

    private static void loadLocation(ServerPlayer player, CompoundTag locationTag) {
        double x = locationTag.getDouble("x");
        double y = locationTag.getDouble("y");
        double z = locationTag.getDouble("z");
        float yaw = locationTag.getFloat("yaw");
        float pitch = locationTag.getFloat("pitch");
        ResourceLocation dimensionKey = ResourceLocation.parse((String)locationTag.getString("dimension"));
        ServerLevel targetLevel = player.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionKey));
        if (targetLevel == null) {
            LOGGER.warn("[LocationHandler] Dimension {} not found for player {}. Player will remain in current dimension {}. Attempting to teleport to coordinates in current dimension.", new Object[]{dimensionKey, player.getName().getString(), player.level().dimension().location()});
            targetLevel = player.serverLevel();
        }
        if (player.level() == targetLevel) {
            player.teleportTo(x, y, z);
            player.setYRot(yaw);
            player.setXRot(pitch);
            LOGGER.debug("[LocationHandler] Teleported player {} to X={}, Y={}, Z={}, Yaw={}, Pitch={} in current dimension {}", new Object[]{player.getName().getString(), x, y, z, Float.valueOf(yaw), Float.valueOf(pitch), targetLevel.dimension().location()});
        } else {
            player.teleportTo(targetLevel, x, y, z, yaw, pitch);
            LOGGER.debug("[LocationHandler] Teleported player {} to X={}, Y={}, Z={}, Yaw={}, Pitch={} in dimension {}", new Object[]{player.getName().getString(), x, y, z, Float.valueOf(yaw), Float.valueOf(pitch), targetLevel.dimension().location()});
        }
    }

    static {
        LOGGER.debug("LocationHandler loaded for Persona.");
    }
}

