/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.registry;

import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import world.landfall.persona.Persona;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.GlobalCharacterRegistry;
import world.landfall.persona.registry.PersonaNetworking;

@EventBusSubscriber(modid="persona")
public class PersonaEvents {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerCharacterData data = (PlayerCharacterData)serverPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
            if (data != null) {
                GlobalCharacterRegistry.syncRegistry(serverPlayer);
            } else {
                Persona.LOGGER.warn("[Persona] Player {} missing character data on login.", (Object)serverPlayer.getName().getString());
            }
        } else if (player != null) {
            Persona.LOGGER.debug("[Persona] Non-ServerPlayer type ({}) logged in, character data: {}", (Object)player.getClass().getSimpleName(), (Object)(player.getData(PlayerCharacterCapability.CHARACTER_DATA) != null ? 1 : 0));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerCharacterData data;
        Player player = event.getEntity();
        if (player != null && (data = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA)) != null) {
            data.clearClientCache();
            Persona.LOGGER.debug("[Persona] Cleared client cache for player {}", (Object)player.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        PlayerCharacterData originalData = (PlayerCharacterData)original.getData(PlayerCharacterCapability.CHARACTER_DATA);
        PlayerCharacterData cloneData = (PlayerCharacterData)clone.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (originalData != null && cloneData != null) {
            cloneData.copyFrom(originalData);
            Persona.LOGGER.debug("[Persona] Copied PlayerCharacterData from original to clone for player {}. Characters: {} active: {}", new Object[]{clone.getName().getString(), cloneData.getCharacterCount(), cloneData.getActiveCharacterId()});
            if (clone instanceof ServerPlayer) {
                ServerPlayer serverClone = (ServerPlayer)clone;
                PersonaNetworking.sendToPlayer(cloneData, serverClone);
            }
        } else {
            Persona.LOGGER.warn("[Persona] Failed to copy PlayerCharacterData on clone. Original null: {} clone null: {}", (Object)(originalData == null ? 1 : 0), (Object)(cloneData == null ? 1 : 0));
        }
    }

    public static class CharacterDeleteEvent
    extends Event {
        private final Player player;
        private final Long characterId;
        private boolean canceled = false;

        public CharacterDeleteEvent(Player player, Long characterId) {
            this.player = player;
            this.characterId = characterId;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Long getCharacterId() {
            return this.characterId;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }

    public static class CharacterSwitchEvent
    extends Event {
        private final Player player;
        private final Long fromCharacterId;
        private final Long toCharacterId;

        public CharacterSwitchEvent(Player player, Long fromCharacterId, Long toCharacterId) {
            this.player = player;
            this.fromCharacterId = fromCharacterId;
            this.toCharacterId = toCharacterId;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Long getFromCharacterId() {
            return this.fromCharacterId;
        }

        public Long getToCharacterId() {
            return this.toCharacterId;
        }
    }

    public static class CharacterPreSwitchEvent
    extends Event {
        private final Player player;
        private final Long fromCharacterId;
        private final Long toCharacterId;
        private final CompletableFuture<Void> ready;

        public CharacterPreSwitchEvent(Player player, Long fromCharacterId, Long toCharacterId) {
            this.player = player;
            this.fromCharacterId = fromCharacterId;
            this.toCharacterId = toCharacterId;
            this.ready = new CompletableFuture();
        }

        public Player getPlayer() {
            return this.player;
        }

        public Long getFromCharacterId() {
            return this.fromCharacterId;
        }

        public Long getToCharacterId() {
            return this.toCharacterId;
        }

        public CompletableFuture<Void> getReady() {
            return this.ready;
        }
    }

    public static class CharacterCreateEvent
    extends Event {
        private final Player player;
        private final Long characterId;
        private final CharacterProfile profile;

        public CharacterCreateEvent(Player player, Long characterId, CharacterProfile profile) {
            this.player = player;
            this.characterId = characterId;
            this.profile = profile;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Long getCharacterId() {
            return this.characterId;
        }

        public CharacterProfile getProfile() {
            return this.profile;
        }
    }
}

