/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.aging;

import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;
import world.landfall.persona.client.event.CollectCharacterInfoEvent;
import world.landfall.persona.config.ClientSyncedConfig;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.features.aging.AgingManager;

public class AgingClientEvents {
    private static final DecimalFormat AGE_FORMAT = new DecimalFormat("0.#");

    @SubscribeEvent
    public static void onCollectCharacterInfo(CollectCharacterInfoEvent event) {
        if (!ClientSyncedConfig.isAgingSystemEnabled()) {
            return;
        }
        CharacterProfile profile = event.getCharacterProfile();
        double age = AgingManager.getCalculatedAge(profile);
        if (age > 0.0) {
            String formattedAge = AGE_FORMAT.format(age);
            MutableComponent ageComponent = Component.literal((String)("(Age: " + formattedAge + ")")).withStyle(ChatFormatting.GRAY);
            event.addInfo((Component)ageComponent);
        }
    }
}

