/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.display;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import world.landfall.persona.Persona;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.PersonaEvents;
import world.landfall.persona.statecraft.StatecraftAPI;

@EventBusSubscriber(modid="persona")
public class DisplayNameManager {
    @SubscribeEvent
    public static void onCharacterSwitch(PersonaEvents.CharacterSwitchEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Persona.LOGGER.debug("[Persona] DisplayNameManager.onCharacterSwitch for player: {}", (Object)serverPlayer.getName().getString());
        PlayerCharacterData data = (PlayerCharacterData)serverPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            Persona.LOGGER.warn("[Persona] Player {} has no PlayerCharacterData in onCharacterSwitch.", (Object)serverPlayer.getName().getString());
            return;
        }
        Long activeCharacterId = data.getActiveCharacterId();
        if (activeCharacterId == null) {
            Persona.LOGGER.debug("[Persona] No active character for player {} in onCharacterSwitch, resetting to vanilla name.", (Object)serverPlayer.getName().getString());
            serverPlayer.setCustomName(null);
            serverPlayer.setCustomNameVisible(false);
            serverPlayer.refreshDisplayName();
            serverPlayer.refreshTabListName();
            if (serverPlayer.server != null) {
                ClientboundPlayerInfoUpdatePacket updatePacket = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, serverPlayer);
                serverPlayer.server.getPlayerList().broadcastAll((Packet)updatePacket);
            }
            return;
        }
        CharacterProfile profile = data.getCharacter(activeCharacterId);
        if (profile == null || profile.getDisplayName() == null || profile.getDisplayName().isEmpty()) {
            Persona.LOGGER.debug("[Persona] No valid profile/name for active character on switch for {}. Resetting to vanilla.", (Object)serverPlayer.getName().getString());
            serverPlayer.setCustomName(null);
            serverPlayer.setCustomNameVisible(false);
        } else {
            MutableComponent displayName = Component.literal((String)profile.getDisplayName());
            serverPlayer.setCustomName((Component)displayName);
            serverPlayer.setCustomNameVisible(true);
            Persona.LOGGER.debug("[Persona] Set custom name to '{}' for {}", (Object)profile.getDisplayName(), (Object)serverPlayer.getName().getString());
            String characterName = profile.getDisplayName();
            UUID playerUuid = serverPlayer.getUUID();
            CompletableFuture.runAsync(() -> {
                try {
                    long result = StatecraftAPI.getInstance().recordDisplayName(playerUuid, characterName);
                    if (result != -1L) {
                        Persona.LOGGER.debug("[DisplayNameManager] Updated lastSeen for character '{}' (ID: {}) in Statecraft", (Object)characterName, (Object)result);
                    }
                }
                catch (Exception e) {
                    Persona.LOGGER.warn("[DisplayNameManager] Failed to update lastSeen for character '{}' in Statecraft: {}", (Object)characterName, (Object)e.getMessage());
                }
            });
        }
        serverPlayer.refreshDisplayName();
        serverPlayer.refreshTabListName();
        Persona.LOGGER.debug("[Persona] Called refreshDisplayName & refreshTabListName for {}", (Object)serverPlayer.getName().getString());
        if (serverPlayer.server != null) {
            ClientboundPlayerInfoUpdatePacket updatePacket = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, serverPlayer);
            serverPlayer.server.getPlayerList().broadcastAll((Packet)updatePacket);
            Persona.LOGGER.debug("[Persona] Sent UPDATE_DISPLAY_NAME packet for {}", (Object)serverPlayer.getName().getString());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onNameFormat(PlayerEvent.NameFormat event) {
        Player player;
        if (!((Boolean)Config.ENABLE_NAME_SYSTEM.get()).booleanValue() || !((player = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player2 = player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        Long activeCharacterId = data.getActiveCharacterId();
        if (activeCharacterId == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(activeCharacterId);
        if (profile != null && profile.getDisplayName() != null && !profile.getDisplayName().isEmpty()) {
            event.setDisplayname((Component)Component.literal((String)profile.getDisplayName()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onTabListNameFormat(PlayerEvent.TabListNameFormat event) {
        Player player;
        if (!((Boolean)Config.ENABLE_NAME_SYSTEM.get()).booleanValue() || !((player = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player2 = player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        Long activeCharacterId = data.getActiveCharacterId();
        if (activeCharacterId == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(activeCharacterId);
        if (profile != null && profile.getDisplayName() != null && !profile.getDisplayName().isEmpty()) {
            MutableComponent displayName;
            if (((Boolean)Config.SHOW_USERNAME_IN_TABLIST.get()).booleanValue()) {
                String colorCode = (String)Config.TABLIST_NAME_COLOR.get();
                String characterName = "\u00a7" + colorCode + profile.getDisplayName();
                String username = "\u00a77(" + player2.getName().getString() + ")";
                displayName = Component.literal((String)(characterName + " " + username));
            } else {
                displayName = Component.literal((String)profile.getDisplayName());
            }
            PlayerTeam team = player2.getTeam();
            if (team != null) {
                displayName = PlayerTeam.formatNameForTeam((Team)team, (Component)displayName);
            }
            event.setDisplayName((Component)displayName);
        }
    }
}

