/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.figura;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import world.landfall.persona.features.figura.event.FiguraAvatarSwitchEvent;

public class FiguraReflector {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String FIGURA_MOD_CLASS = "org.figuramc.figura.FiguraMod";
    private static final String GET_LOCAL_PLAYER_UUID_METHOD = "getLocalPlayerUUID";
    private static final String FETCHER_CLASS = "org.figuramc.figura.avatar.local.LocalAvatarFetcher";
    private static final String GET_LOCAL_AVATAR_DIRECTORY_METHOD = "getLocalAvatarDirectory";
    private static final String MANAGER_CLASS = "org.figuramc.figura.avatar.AvatarManager";
    private static final String LOAD_LOCAL_AVATAR_METHOD = "loadLocalAvatar";
    private static final String GET_LOADED_AVATAR_METHOD = "getLoadedAvatar";
    private static final String GET_AVATAR_FOR_PLAYER_METHOD = "getAvatarForPlayer";
    private static final String NETWORK_STUFF_CLASS = "org.figuramc.figura.backend2.NetworkStuff";
    private static final String UPLOAD_AVATAR_METHOD = "uploadAvatar";
    private static final Deque<Long> UPLOAD_TIMESTAMPS = new ArrayDeque<Long>();
    private static final long RATE_LIMIT_WINDOW_MS = 120000L;
    private static final int MAX_UPLOADS_IN_WINDOW = 10;
    private static Boolean figuraAvailable = null;

    public static boolean isFiguraAvailable() {
        if (figuraAvailable == null) {
            try {
                Class.forName(FIGURA_MOD_CLASS);
                Class.forName(FETCHER_CLASS);
                Class.forName(MANAGER_CLASS);
                Class.forName(NETWORK_STUFF_CLASS);
                figuraAvailable = true;
                LOGGER.info("Figura classes detected. Figura integration enabled.");
            }
            catch (ClassNotFoundException e) {
                figuraAvailable = false;
                LOGGER.info("Figura classes not detected. Figura integration disabled.");
            }
        }
        return figuraAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performAvatarSwitch(String avatarFolderName) {
        if (!FiguraReflector.isFiguraAvailable()) {
            NeoForge.EVENT_BUS.post((Event)new FiguraAvatarSwitchEvent(avatarFolderName, false, false, "Figura mod not detected."));
            return;
        }
        boolean success = false;
        Object eventMessage = "Avatar switch initiated for '" + avatarFolderName + "'.";
        try {
            Class<?> fetcherClass = Class.forName(FETCHER_CLASS);
            Method getLocalAvatarDirectoryMethod = fetcherClass.getMethod(GET_LOCAL_AVATAR_DIRECTORY_METHOD, new Class[0]);
            Path baseDir = (Path)getLocalAvatarDirectoryMethod.invoke(null, new Object[0]);
            Path fullPath = baseDir.resolve(avatarFolderName);
            if (!Files.isDirectory(fullPath, new LinkOption[0])) {
                eventMessage = "Figura avatar folder not found: " + String.valueOf(fullPath);
                LOGGER.warn((String)eventMessage);
                NeoForge.EVENT_BUS.post((Event)new FiguraAvatarSwitchEvent(avatarFolderName, false, true, (String)eventMessage));
                return;
            }
            if (!FiguraReflector.canUploadInternal()) {
                eventMessage = "Figura upload rate limit reached. Try again later.";
                LOGGER.warn((String)eventMessage);
                NeoForge.EVENT_BUS.post((Event)new FiguraAvatarSwitchEvent(avatarFolderName, false, true, (String)eventMessage));
                return;
            }
            LOGGER.debug("Attempting to load Figura avatar from: {}", (Object)fullPath);
            boolean loadInitiated = FiguraReflector.loadAvatarInternal(fullPath);
            if (loadInitiated) {
                LOGGER.debug("Figura avatar load initiated for '{}'. Waiting for it to be ready for upload.", (Object)avatarFolderName);
                FiguraReflector.waitForLoadAndUploadInternal(avatarFolderName, 10000L);
                success = true;
            } else {
                eventMessage = "Failed to initiate Figura avatar load for '" + avatarFolderName + "'. Check logs for details.";
            }
        }
        catch (Exception e) {
            LOGGER.error("Critical error during Figura avatar switch for '{}'", (Object)avatarFolderName, (Object)e);
            eventMessage = "Exception during avatar switch: " + e.getMessage();
            success = false;
        }
        finally {
            NeoForge.EVENT_BUS.post((Event)new FiguraAvatarSwitchEvent(avatarFolderName, success, true, (String)eventMessage));
        }
    }

    private static boolean loadAvatarInternal(Path avatarPath) {
        try {
            Class<?> managerClass = Class.forName(MANAGER_CLASS);
            Method loadLocalAvatarMethod = managerClass.getMethod(LOAD_LOCAL_AVATAR_METHOD, Path.class);
            loadLocalAvatarMethod.invoke(null, avatarPath);
            LOGGER.debug("Figura's loadLocalAvatar method invoked for: {}", (Object)avatarPath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to invoke Figura's loadLocalAvatar method for '{}'", (Object)avatarPath, (Object)e);
            return false;
        }
    }

    private static boolean isCurrentAvatarLoadedInternal() {
        try {
            Class<?> figuraModClass = Class.forName(FIGURA_MOD_CLASS);
            Method getLocalPlayerUUIDMethod = figuraModClass.getMethod(GET_LOCAL_PLAYER_UUID_METHOD, new Class[0]);
            UUID localPlayerUUID = (UUID)getLocalPlayerUUIDMethod.invoke(null, new Object[0]);
            if (localPlayerUUID == null) {
                LOGGER.warn("Could not get local player UUID from FiguraMod.");
                return false;
            }
            Class<?> avatarManagerClass = Class.forName(MANAGER_CLASS);
            Method getLoadedAvatarMethod = avatarManagerClass.getMethod(GET_LOADED_AVATAR_METHOD, UUID.class);
            Object avatar = getLoadedAvatarMethod.invoke(null, localPlayerUUID);
            return avatar != null;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking if Figura avatar is loaded", (Throwable)e);
            return false;
        }
    }

    private static boolean canUploadInternal() {
        long now = System.currentTimeMillis();
        UPLOAD_TIMESTAMPS.removeIf(timestamp -> now - timestamp > 120000L);
        return UPLOAD_TIMESTAMPS.size() < 10;
    }

    private static void uploadCurrentAvatarInternal() {
        try {
            Class<?> figuraModClass = Class.forName(FIGURA_MOD_CLASS);
            Method getLocalPlayerUUIDMethod = figuraModClass.getMethod(GET_LOCAL_PLAYER_UUID_METHOD, new Class[0]);
            UUID localPlayerUUID = (UUID)getLocalPlayerUUIDMethod.invoke(null, new Object[0]);
            if (localPlayerUUID == null) {
                LOGGER.warn("Cannot upload avatar: Local player UUID is null.");
                return;
            }
            Class<?> avatarManagerClass = Class.forName(MANAGER_CLASS);
            Method getAvatarForPlayerMethod = avatarManagerClass.getMethod(GET_AVATAR_FOR_PLAYER_METHOD, UUID.class);
            Object avatar = getAvatarForPlayerMethod.invoke(null, localPlayerUUID);
            if (avatar == null) {
                LOGGER.warn("Cannot upload avatar: No avatar is currently loaded for UUID {}.", (Object)localPlayerUUID);
                return;
            }
            Class<?> networkStuffClass = Class.forName(NETWORK_STUFF_CLASS);
            Method uploadAvatarMethod = networkStuffClass.getMethod(UPLOAD_AVATAR_METHOD, avatar.getClass());
            uploadAvatarMethod.invoke(null, avatar);
            UPLOAD_TIMESTAMPS.addLast(System.currentTimeMillis());
            LOGGER.debug("Figura's uploadAvatar method invoked for player UUID: {}", (Object)localPlayerUUID);
        }
        catch (Exception e) {
            LOGGER.error("Failed to invoke Figura's uploadAvatar method", (Throwable)e);
        }
    }

    private static void waitForLoadAndUploadInternal(final String avatarFolderNameForLogging, final long timeoutMillis) {
        final long startTime = System.currentTimeMillis();
        Runnable checkTask = new Runnable(){

            @Override
            public void run() {
                if (FiguraReflector.isCurrentAvatarLoadedInternal()) {
                    LOGGER.debug("Avatar '{}' confirmed loaded. Proceeding with upload.", (Object)avatarFolderNameForLogging);
                    if (FiguraReflector.canUploadInternal()) {
                        FiguraReflector.uploadCurrentAvatarInternal();
                    } else {
                        LOGGER.warn("Avatar '{}' loaded, but upload rate limit reached. Upload skipped.", (Object)avatarFolderNameForLogging);
                    }
                    return;
                }
                if (System.currentTimeMillis() - startTime > timeoutMillis) {
                    LOGGER.warn("Timeout waiting for Figura avatar '{}' to load. Upload will not proceed.", (Object)avatarFolderNameForLogging);
                    return;
                }
                if (Minecraft.getInstance() != null) {
                    Minecraft.getInstance().tell((Runnable)this);
                } else {
                    LOGGER.error("Minecraft instance is null, cannot reschedule avatar load check for '{}'.", (Object)avatarFolderNameForLogging);
                }
            }
        };
        if (Minecraft.getInstance() != null) {
            Minecraft.getInstance().tell(checkTask);
        } else {
            LOGGER.error("Minecraft instance is null, cannot initially schedule avatar load check for '{}'.", (Object)avatarFolderNameForLogging);
        }
    }
}

