/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import world.landfall.persona.Persona;
import world.landfall.persona.client.network.ClientNetworkHandler;
import world.landfall.persona.command.CommandRegistry;
import world.landfall.persona.config.ClientSyncedConfig;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.GlobalCharacterRegistry;

@EventBusSubscriber(modid="persona", bus=EventBusSubscriber.Bus.MOD)
public class PersonaNetworking {
    private static final ResourceLocation SYNC_TO_CLIENT_ID = ResourceLocation.tryParse((String)"persona:sync_to_client");
    private static final ResourceLocation SYNC_TO_SERVER_ID = ResourceLocation.tryParse((String)"persona:sync_to_server");
    private static final ResourceLocation ACTION_ID = ResourceLocation.tryParse((String)"persona:character_action");
    private static final ResourceLocation SYNC_REQUEST_ID = ResourceLocation.tryParse((String)"persona:sync_request");
    private static final ResourceLocation CREATION_RESPONSE_ID = ResourceLocation.tryParse((String)"persona:creation_response");
    private static final ResourceLocation CREATE_WITH_MODDATA_ID = ResourceLocation.tryParse((String)"persona:create_with_moddata");
    private static final ResourceLocation SERVER_CONFIG_SYNC_ID = ResourceLocation.tryParse((String)"persona:server_config_sync");
    private static CustomPacketPayload.Type<SyncToClientPayload> SYNC_TO_CLIENT_TYPE = null;
    private static CustomPacketPayload.Type<SyncToServerPayload> SYNC_TO_SERVER_TYPE = null;
    private static CustomPacketPayload.Type<CharacterActionPayload> ACTION_PACKET_TYPE = null;
    private static CustomPacketPayload.Type<SyncRequestPayload> SYNC_REQUEST_TYPE = null;
    private static CustomPacketPayload.Type<CharacterCreationResponsePayload> CREATION_RESPONSE_TYPE = null;
    private static CustomPacketPayload.Type<CharacterCreateWithModDataPayload> CREATE_WITH_MODDATA_TYPE = null;
    private static CustomPacketPayload.Type<ServerConfigSyncPayload> SERVER_CONFIG_SYNC_TYPE = null;
    private static StreamCodec<RegistryFriendlyByteBuf, SyncToClientPayload> SYNC_TO_CLIENT_CODEC = null;
    private static StreamCodec<RegistryFriendlyByteBuf, SyncToServerPayload> SYNC_TO_SERVER_CODEC = null;
    private static StreamCodec<RegistryFriendlyByteBuf, CharacterActionPayload> ACTION_PACKET_CODEC = null;
    private static StreamCodec<RegistryFriendlyByteBuf, SyncRequestPayload> SYNC_REQUEST_CODEC = null;
    private static StreamCodec<RegistryFriendlyByteBuf, CharacterCreationResponsePayload> CREATION_RESPONSE_CODEC = null;
    private static StreamCodec<RegistryFriendlyByteBuf, CharacterCreateWithModDataPayload> CREATE_WITH_MODDATA_CODEC = null;
    private static StreamCodec<RegistryFriendlyByteBuf, ServerConfigSyncPayload> SERVER_CONFIG_SYNC_CODEC = null;

    @SubscribeEvent
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        if (SYNC_TO_CLIENT_TYPE != null || SYNC_TO_SERVER_TYPE != null || ACTION_PACKET_TYPE != null || CREATION_RESPONSE_TYPE != null || CREATE_WITH_MODDATA_TYPE != null || SERVER_CONFIG_SYNC_TYPE != null) {
            Persona.LOGGER.warn("[Persona] Attempted to register payload handlers more than once. Skipping.");
            return;
        }
        try {
            PayloadRegistrar registrar = event.registrar("persona");
            SYNC_TO_CLIENT_TYPE = new CustomPacketPayload.Type(SYNC_TO_CLIENT_ID);
            SYNC_TO_CLIENT_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), SyncToClientPayload::new);
            registrar.playToClient(SYNC_TO_CLIENT_TYPE, SYNC_TO_CLIENT_CODEC, SyncToClientPayload.Handler::handleClientPacket);
            SYNC_TO_SERVER_TYPE = new CustomPacketPayload.Type(SYNC_TO_SERVER_ID);
            SYNC_TO_SERVER_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), SyncToServerPayload::new);
            registrar.playToServer(SYNC_TO_SERVER_TYPE, SYNC_TO_SERVER_CODEC, SyncToServerPayload.Handler::handleServerPacket);
            ACTION_PACKET_TYPE = new CustomPacketPayload.Type(ACTION_ID);
            ACTION_PACKET_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), CharacterActionPayload::new);
            registrar.playToServer(ACTION_PACKET_TYPE, ACTION_PACKET_CODEC, CharacterActionPayload.Handler::handleServerPacket);
            CREATE_WITH_MODDATA_TYPE = new CustomPacketPayload.Type(CREATE_WITH_MODDATA_ID);
            CREATE_WITH_MODDATA_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), CharacterCreateWithModDataPayload::new);
            registrar.playToServer(CREATE_WITH_MODDATA_TYPE, CREATE_WITH_MODDATA_CODEC, CharacterCreateWithModDataPayload.Handler::handleServerPacket);
            SYNC_REQUEST_TYPE = new CustomPacketPayload.Type(SYNC_REQUEST_ID);
            SYNC_REQUEST_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), SyncRequestPayload::new);
            registrar.playToServer(SYNC_REQUEST_TYPE, SYNC_REQUEST_CODEC, SyncRequestPayload.Handler::handleServerPacket);
            CREATION_RESPONSE_TYPE = new CustomPacketPayload.Type(CREATION_RESPONSE_ID);
            CREATION_RESPONSE_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), CharacterCreationResponsePayload::new);
            registrar.playToClient(CREATION_RESPONSE_TYPE, CREATION_RESPONSE_CODEC, CharacterCreationResponsePayload.Handler::handleClientPacket);
            SERVER_CONFIG_SYNC_TYPE = new CustomPacketPayload.Type(SERVER_CONFIG_SYNC_ID);
            SERVER_CONFIG_SYNC_CODEC = StreamCodec.of((buf, payload) -> payload.write((FriendlyByteBuf)buf), ServerConfigSyncPayload::new);
            registrar.playToClient(SERVER_CONFIG_SYNC_TYPE, SERVER_CONFIG_SYNC_CODEC, ServerConfigSyncPayload.Handler::handleClientPacket);
            Persona.LOGGER.debug("[Persona] Payload handlers registered successfully.");
        }
        catch (Exception e) {
            Persona.LOGGER.error("[Persona] Failed to register payload handlers", (Throwable)e);
            SYNC_TO_CLIENT_TYPE = null;
            SYNC_TO_CLIENT_CODEC = null;
            SYNC_TO_SERVER_TYPE = null;
            SYNC_TO_SERVER_CODEC = null;
            ACTION_PACKET_TYPE = null;
            ACTION_PACKET_CODEC = null;
            SYNC_REQUEST_TYPE = null;
            SYNC_REQUEST_CODEC = null;
            CREATION_RESPONSE_TYPE = null;
            CREATION_RESPONSE_CODEC = null;
            CREATE_WITH_MODDATA_TYPE = null;
            CREATE_WITH_MODDATA_CODEC = null;
            SERVER_CONFIG_SYNC_TYPE = null;
            SERVER_CONFIG_SYNC_CODEC = null;
        }
    }

    public static void sendToPlayer(PlayerCharacterData data, ServerPlayer player) {
        if (SYNC_TO_CLIENT_TYPE == null) {
            Persona.LOGGER.error("[Persona] Cannot send packet, network not initialized");
            return;
        }
        Map<Long, CharacterProfile> characters = data.getCharacters();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncToClientPayload(data, characters), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(PlayerCharacterData data) {
        if (SYNC_TO_SERVER_TYPE == null) {
            Persona.LOGGER.error("[Persona] Cannot send packet, network not initialized");
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncToServerPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendActionToServer(Action action, String data) {
        PersonaNetworking.sendActionToServer(action, data, false);
    }

    public static void sendActionToServer(Action action, String data, boolean fromGui) {
        PersonaNetworking.sendActionToServer(action, data, -1, fromGui);
    }

    public static void sendActionToServer(Action action, String data, int startingAge, boolean fromGui) {
        if (ACTION_PACKET_TYPE == null || ACTION_PACKET_CODEC == null) {
            throw new IllegalStateException("Attempted to send action packet before packet types were initialized");
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CharacterActionPayload(action, data, startingAge, fromGui), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void requestCharacterSync() {
        if (SYNC_REQUEST_TYPE == null) {
            Persona.LOGGER.error("[Persona] Cannot send sync request, network not initialized");
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncRequestPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendCreationResponseToPlayer(ServerPlayer player, boolean success, String messageKey, String ... messageArgs) {
        if (CREATION_RESPONSE_TYPE == null) {
            Persona.LOGGER.error("[Persona] Cannot send creation response, network not initialized");
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CharacterCreationResponsePayload(success, messageKey, messageArgs), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendCreateWithModData(String characterName, Map<ResourceLocation, CompoundTag> modData, boolean fromGui) {
        if (CREATE_WITH_MODDATA_TYPE == null || CREATE_WITH_MODDATA_CODEC == null) {
            throw new IllegalStateException("Attempted to send createWithModData packet before packet types were initialized");
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CharacterCreateWithModDataPayload(characterName, modData, fromGui), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendServerConfigToPlayer(ServerPlayer player) {
        if (SERVER_CONFIG_SYNC_TYPE == null) {
            Persona.LOGGER.error("[Persona] Cannot send server config, network not initialized");
            return;
        }
        boolean agingEnabled = (Boolean)Config.ENABLE_AGING_SYSTEM.get();
        boolean inventoryEnabled = (Boolean)Config.ENABLE_INVENTORY_SYSTEM.get();
        boolean locationEnabled = (Boolean)Config.ENABLE_LOCATION_SYSTEM.get();
        boolean landfallEnabled = (Boolean)Config.ENABLE_LANDFALL_ADDONS.get();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ServerConfigSyncPayload(agingEnabled, inventoryEnabled, locationEnabled, landfallEnabled), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record SyncToClientPayload(PlayerCharacterData data, Map<Long, CharacterProfile> characters) implements CustomPacketPayload
    {
        public SyncToClientPayload(RegistryFriendlyByteBuf buf) {
            this(PlayerCharacterData.deserialize(buf.readNbt()), SyncToClientPayload.readCharacterMap(buf));
        }

        private static Map<Long, CharacterProfile> readCharacterMap(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            HashMap<Long, CharacterProfile> characters = new HashMap<Long, CharacterProfile>(size);
            for (int i = 0; i < size; ++i) {
                Long characterId = buf.readLong();
                CompoundTag characterData = buf.readNbt();
                if (characterData == null) continue;
                CharacterProfile character = CharacterProfile.deserialize(characterData);
                characters.put(characterId, character);
            }
            return characters;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeNbt((Tag)this.data.serialize());
            buf.writeVarInt(this.characters.size());
            this.characters.forEach((id, character) -> {
                buf.writeLong(id.longValue());
                buf.writeNbt((Tag)character.serialize());
            });
        }

        public CustomPacketPayload.Type<SyncToClientPayload> type() {
            if (SYNC_TO_CLIENT_TYPE == null) {
                throw new IllegalStateException("Attempted to use SYNC_TO_CLIENT_TYPE before it was initialized");
            }
            return SYNC_TO_CLIENT_TYPE;
        }

        public static class Handler {
            public static void handleClientPacket(SyncToClientPayload payload, IPayloadContext context) {
                context.enqueueWork(() -> Optional.ofNullable(context.player()).ifPresent(player -> {
                    PlayerCharacterData currentData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
                    if (currentData != null) {
                        currentData.copyFrom(payload.data());
                        payload.characters().values().forEach(currentData::cacheCharacter);
                    }
                }));
            }
        }
    }

    public record SyncToServerPayload(PlayerCharacterData data) implements CustomPacketPayload
    {
        public SyncToServerPayload(RegistryFriendlyByteBuf buf) {
            this(PlayerCharacterData.deserialize(buf.readNbt()));
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeNbt((Tag)this.data.serialize());
        }

        public CustomPacketPayload.Type<SyncToServerPayload> type() {
            if (SYNC_TO_SERVER_TYPE == null) {
                throw new IllegalStateException("Attempted to use SYNC_TO_SERVER_TYPE before it was initialized");
            }
            return SYNC_TO_SERVER_TYPE;
        }

        public static class Handler {
            public static void handleServerPacket(SyncToServerPayload payload, IPayloadContext context) {
                Optional.ofNullable(context.player()).ifPresent(player -> {
                    ServerPlayer serverPlayer;
                    PlayerCharacterData currentData;
                    if (player instanceof ServerPlayer && (currentData = (PlayerCharacterData)(serverPlayer = (ServerPlayer)player).getData(PlayerCharacterCapability.CHARACTER_DATA)) != null) {
                        currentData.setActiveCharacterId(payload.data().getActiveCharacterId());
                        GlobalCharacterRegistry.syncRegistry(serverPlayer);
                    }
                });
            }
        }
    }

    public static enum Action {
        CREATE,
        SWITCH,
        DELETE,
        COLLECT_ITEMS;

    }

    public record CharacterActionPayload(Action action, String data, int startingAge, boolean fromGui) implements CustomPacketPayload
    {
        private static final int MAX_STRING_LENGTH = 256;

        public CharacterActionPayload(RegistryFriendlyByteBuf buf) {
            this(CharacterActionPayload.readAction(buf), CharacterActionPayload.readBoundedString(buf, 256), buf.readInt(), buf.readBoolean());
        }

        private static String readBoundedString(RegistryFriendlyByteBuf buf, int maxLength) {
            String str = buf.readUtf();
            if (str.length() > maxLength) {
                throw new IllegalArgumentException("String length exceeds maximum allowed: " + str.length() + " > " + maxLength);
            }
            return str;
        }

        private static Action readAction(RegistryFriendlyByteBuf buf) {
            byte actionOrdinal = buf.readByte();
            Action[] actions = Action.values();
            if (actionOrdinal < 0 || actionOrdinal >= actions.length) {
                throw new IllegalArgumentException("Invalid action ordinal: " + actionOrdinal);
            }
            return actions[actionOrdinal];
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeByte(this.action.ordinal());
            buf.writeUtf(this.data);
            buf.writeInt(this.startingAge);
            buf.writeBoolean(this.fromGui);
        }

        public CustomPacketPayload.Type<CharacterActionPayload> type() {
            if (ACTION_PACKET_TYPE == null) {
                throw new IllegalStateException("Attempted to use ACTION_PACKET_TYPE before it was initialized");
            }
            return ACTION_PACKET_TYPE;
        }

        public static class Handler {
            public static void handleServerPacket(CharacterActionPayload payload, IPayloadContext context) {
                Optional.ofNullable(context.player()).ifPresent(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        switch (payload.action().ordinal()) {
                            case 0: {
                                try {
                                    CommandRegistry.createCharacter(serverPlayer, payload.data(), payload.fromGui());
                                }
                                catch (Exception e) {
                                    Persona.LOGGER.error("[Persona] Failed to create character via network action", (Throwable)e);
                                    PersonaNetworking.sendCreationResponseToPlayer(serverPlayer, false, "gui.persona.error.generic_creation_fail", new String[0]);
                                }
                                break;
                            }
                            case 1: {
                                try {
                                    CommandRegistry.switchCharacter(serverPlayer, payload.data(), payload.fromGui());
                                }
                                catch (Exception e) {
                                    Persona.LOGGER.error("[Persona] Failed to switch character", (Throwable)e);
                                }
                                break;
                            }
                            case 2: {
                                try {
                                    CommandRegistry.deleteCharacter(serverPlayer, payload.data(), payload.fromGui());
                                }
                                catch (Exception e) {
                                    Persona.LOGGER.error("[Persona] Failed to delete character", (Throwable)e);
                                }
                                break;
                            }
                            case 3: {
                                try {
                                    CommandRegistry.collectItemsFromDeceased(serverPlayer, payload.data(), payload.fromGui());
                                    break;
                                }
                                catch (Exception e) {
                                    Persona.LOGGER.error("[Persona] Failed to collect items from deceased character", (Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    public record SyncRequestPayload() implements CustomPacketPayload
    {
        public SyncRequestPayload(RegistryFriendlyByteBuf buf) {
            this();
        }

        public void write(FriendlyByteBuf buf) {
        }

        public CustomPacketPayload.Type<SyncRequestPayload> type() {
            if (SYNC_REQUEST_TYPE == null) {
                throw new IllegalStateException("Attempted to use SYNC_REQUEST_TYPE before it was initialized");
            }
            return SYNC_REQUEST_TYPE;
        }

        public static class Handler {
            public static void handleServerPacket(SyncRequestPayload payload, IPayloadContext context) {
                Optional.ofNullable(context.player()).ifPresent(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        GlobalCharacterRegistry.syncRegistry(serverPlayer);
                    }
                });
            }
        }
    }

    public record CharacterCreationResponsePayload(boolean success, String messageKey, String[] messageArgs) implements CustomPacketPayload
    {
        private static final int MAX_MESSAGE_KEY_LENGTH = 128;
        private static final int MAX_MESSAGE_ARG_LENGTH = 256;
        private static final int MAX_MESSAGE_ARGS = 10;

        public CharacterCreationResponsePayload(RegistryFriendlyByteBuf buf) {
            this(buf.readBoolean(), CharacterCreationResponsePayload.readBoundedMessageKey(buf), CharacterCreationResponsePayload.readBoundedMessageArgs(buf));
        }

        private static String readBoundedMessageKey(RegistryFriendlyByteBuf buf) {
            String str = buf.readUtf();
            if (str.length() > 128) {
                throw new IllegalArgumentException("Message key length exceeds maximum allowed: " + str.length() + " > 128");
            }
            return str;
        }

        private static String[] readBoundedMessageArgs(RegistryFriendlyByteBuf buf) {
            return (String[])buf.readArray(size -> {
                if (size > 10) {
                    throw new IllegalArgumentException("Too many message arguments: " + size + " > 10");
                }
                return new String[size];
            }, b -> {
                String str = b.readUtf();
                if (str.length() > 256) {
                    throw new IllegalArgumentException("Message arg length exceeds maximum allowed: " + str.length() + " > 256");
                }
                return str;
            });
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.success);
            buf.writeUtf(this.messageKey);
            buf.writeArray((Object[])this.messageArgs, FriendlyByteBuf::writeUtf);
        }

        public CustomPacketPayload.Type<CharacterCreationResponsePayload> type() {
            if (CREATION_RESPONSE_TYPE == null) {
                throw new IllegalStateException("Attempted to use CREATION_RESPONSE_TYPE before it was initialized");
            }
            return CREATION_RESPONSE_TYPE;
        }

        public static class Handler {
            public static void handleClientPacket(CharacterCreationResponsePayload payload, IPayloadContext context) {
                context.enqueueWork(() -> {
                    try {
                        String messageKey = payload.messageKey();
                        if (messageKey != null && (messageKey.contains("switch") || messageKey.contains("cooldown") || messageKey.contains("already_active"))) {
                            ClientNetworkHandler.handleCharacterSwitchResponse(payload.success(), payload.messageKey(), payload.messageArgs());
                        } else if (messageKey != null && messageKey.contains("delete")) {
                            ClientNetworkHandler.handleCharacterDeletionResponse(payload.success(), payload.messageKey(), payload.messageArgs());
                        } else if (messageKey != null && (messageKey.contains("items_collected") || messageKey.contains("inventory"))) {
                            ClientNetworkHandler.handleItemsCollectionResponse(payload.success(), payload.messageKey(), payload.messageArgs());
                        } else {
                            ClientNetworkHandler.handleCharacterCreationResponse(payload.success(), payload.messageKey(), payload.messageArgs());
                        }
                    }
                    catch (Exception e) {
                        System.err.println("[PersonaNetworking] Error handling character response: " + e.getMessage());
                    }
                });
            }
        }
    }

    public record CharacterCreateWithModDataPayload(String characterName, Map<ResourceLocation, CompoundTag> modData, boolean fromGui) implements CustomPacketPayload
    {
        private static final int MAX_CHARACTER_NAME_LENGTH = 256;
        private static final int MAX_MOD_DATA_ENTRIES = 50;

        public CharacterCreateWithModDataPayload(RegistryFriendlyByteBuf buf) {
            this(CharacterCreateWithModDataPayload.readBoundedCharacterName(buf), CharacterCreateWithModDataPayload.readModDataMap(buf), buf.readBoolean());
        }

        private static String readBoundedCharacterName(RegistryFriendlyByteBuf buf) {
            String str = buf.readUtf();
            if (str.length() > 256) {
                throw new IllegalArgumentException("Character name length exceeds maximum allowed: " + str.length() + " > 256");
            }
            return str;
        }

        private static Map<ResourceLocation, CompoundTag> readModDataMap(RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            if (size < 0 || size > 50) {
                throw new IllegalArgumentException("Invalid modData size: " + size);
            }
            HashMap<ResourceLocation, CompoundTag> modData = new HashMap<ResourceLocation, CompoundTag>(size);
            for (int i = 0; i < size; ++i) {
                ResourceLocation key = buf.readResourceLocation();
                CompoundTag value = buf.readNbt();
                if (value == null) continue;
                modData.put(key, value);
            }
            return modData;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeUtf(this.characterName);
            buf.writeVarInt(this.modData.size());
            this.modData.forEach((key, value) -> {
                buf.writeResourceLocation(key);
                buf.writeNbt((Tag)value);
            });
            buf.writeBoolean(this.fromGui);
        }

        public CustomPacketPayload.Type<CharacterCreateWithModDataPayload> type() {
            if (CREATE_WITH_MODDATA_TYPE == null) {
                throw new IllegalStateException("Attempted to use CREATE_WITH_MODDATA_TYPE before it was initialized");
            }
            return CREATE_WITH_MODDATA_TYPE;
        }

        public static class Handler {
            public static void handleServerPacket(CharacterCreateWithModDataPayload payload, IPayloadContext context) {
                Optional.ofNullable(context.player()).ifPresent(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        try {
                            CommandRegistry.createCharacter(serverPlayer, payload.characterName(), payload.fromGui(), payload.modData());
                        }
                        catch (Exception e) {
                            Persona.LOGGER.error("[Persona] Failed to create character with modData", (Throwable)e);
                            PersonaNetworking.sendCreationResponseToPlayer(serverPlayer, false, "gui.persona.error.generic_creation_fail", new String[0]);
                        }
                    }
                });
            }
        }
    }

    public record ServerConfigSyncPayload(boolean isAgingEnabled, boolean isInventoryEnabled, boolean isLocationEnabled, boolean isLandfallAddonsEnabled) implements CustomPacketPayload
    {
        public ServerConfigSyncPayload(RegistryFriendlyByteBuf buf) {
            this(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.isAgingEnabled);
            buf.writeBoolean(this.isInventoryEnabled);
            buf.writeBoolean(this.isLocationEnabled);
            buf.writeBoolean(this.isLandfallAddonsEnabled);
        }

        public CustomPacketPayload.Type<ServerConfigSyncPayload> type() {
            if (SERVER_CONFIG_SYNC_TYPE == null) {
                throw new IllegalStateException("Attempted to use SERVER_CONFIG_SYNC_TYPE before it was initialized");
            }
            return SERVER_CONFIG_SYNC_TYPE;
        }

        public static class Handler {
            public static void handleClientPacket(ServerConfigSyncPayload payload, IPayloadContext context) {
                context.enqueueWork(() -> {
                    ClientSyncedConfig.updateAgingSystemStatus(payload.isAgingEnabled());
                    ClientSyncedConfig.updateInventorySystemStatus(payload.isInventoryEnabled());
                    ClientSyncedConfig.updateLocationSystemStatus(payload.isLocationEnabled());
                    ClientSyncedConfig.updateLandfallAddonsStatus(payload.isLandfallAddonsEnabled());
                });
            }
        }
    }
}

