/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.registry;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import world.landfall.persona.Persona;

public class RegistryPersistence {
    private static final String REGISTRY_FILE = "character_registry.dat";
    private static Path registryPath;

    public static void initialize(Path configDir) {
        try {
            Path personaDir = configDir.resolve("persona").normalize();
            if (!personaDir.toFile().exists()) {
                personaDir.toFile().mkdirs();
            }
            registryPath = personaDir.resolve(REGISTRY_FILE).normalize();
            Persona.LOGGER.debug("[Persona] Registry file initialized at {}", (Object)registryPath);
        }
        catch (Exception e) {
            Persona.LOGGER.error("[Persona] Failed to initialize registry file", (Throwable)e);
            throw new RuntimeException("Failed to initialize registry file", e);
        }
    }

    public static Path getRegistryPath() {
        return registryPath;
    }

    public static void saveRegistry(Map<Long, UUID> characterToPlayerMap, Map<String, Long> characterNameMap) {
        if (registryPath == null) {
            Persona.LOGGER.error("[Persona] Cannot save registry: path not initialized");
            return;
        }
        try {
            CompoundTag root = new CompoundTag();
            ListTag characterPlayerList = new ListTag();
            characterToPlayerMap.forEach((charId, playerId) -> {
                CompoundTag entry = new CompoundTag();
                entry.putLong("characterId", charId.longValue());
                entry.putString("playerId", playerId.toString());
                characterPlayerList.add((Object)entry);
            });
            root.put("characterToPlayerMap", (Tag)characterPlayerList);
            ListTag characterNameList = new ListTag();
            characterNameMap.forEach((name, charId) -> {
                CompoundTag entry = new CompoundTag();
                entry.putString("name", name);
                entry.putLong("characterId", charId.longValue());
                characterNameList.add((Object)entry);
            });
            root.put("characterNameMap", (Tag)characterNameList);
            NbtIo.writeCompressed((CompoundTag)root, (Path)registryPath);
            Persona.LOGGER.debug("[Persona] Registry saved successfully");
        }
        catch (IOException e) {
            Persona.LOGGER.error("[Persona] Failed to save registry", (Throwable)e);
        }
    }

    public static RegistryData loadRegistry() {
        RegistryData data = new RegistryData();
        if (registryPath == null) {
            Persona.LOGGER.error("[Persona] Cannot load registry: path not initialized");
            return data;
        }
        if (!registryPath.toFile().exists()) {
            Persona.LOGGER.debug("[Persona] No existing registry file found, starting fresh");
            return data;
        }
        try {
            CompoundTag root = NbtIo.readCompressed((Path)registryPath, (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (root != null) {
                ListTag characterPlayerList = root.getList("characterToPlayerMap", 10);
                for (int i = 0; i < characterPlayerList.size(); ++i) {
                    CompoundTag entry = characterPlayerList.getCompound(i);
                    Long characterId = entry.getLong("characterId");
                    UUID playerId = UUID.fromString(entry.getString("playerId"));
                    data.characterToPlayerMap.put(characterId, playerId);
                }
                ListTag characterNameList = root.getList("characterNameMap", 10);
                for (int i = 0; i < characterNameList.size(); ++i) {
                    CompoundTag entry = characterNameList.getCompound(i);
                    String name = entry.getString("name");
                    Long characterId = entry.getLong("characterId");
                    data.characterNameMap.put(name.toLowerCase(), characterId);
                }
                Persona.LOGGER.debug("[Persona] Registry loaded successfully");
            }
        }
        catch (IOException e) {
            Persona.LOGGER.error("[Persona] Failed to load registry", (Throwable)e);
        }
        return data;
    }

    public static class RegistryData {
        public final ConcurrentHashMap<Long, UUID> characterToPlayerMap = new ConcurrentHashMap();
        public final ConcurrentHashMap<String, Long> characterNameMap = new ConcurrentHashMap();
    }
}

