/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import world.landfall.persona.command.CommandRegistry;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.features.aging.AgingClientEvents;
import world.landfall.persona.features.figura.FiguraClientEventListener;
import world.landfall.persona.features.figura.FiguraReflector;
import world.landfall.persona.features.landfalladdon.death.DeathHandler;
import world.landfall.persona.registry.GlobalCharacterRegistry;
import world.landfall.persona.registry.PersonaEvents;
import world.landfall.persona.registry.PersonaNetworking;
import world.landfall.persona.util.NameListManager;

@Mod(value="persona")
public class Persona {
    public static final String MODID = "persona";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Persona(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigReload);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        NeoForge.EVENT_BUS.register(DeathHandler.class);
        NeoForge.EVENT_BUS.register(PersonaEvents.class);
        NameListManager.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("[Persona] Initializing core systems...");
        GlobalCharacterRegistry.initialize();
        NameListManager.reloadLists();
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == Config.SPEC) {
            LOGGER.info("[Persona] Reloading config...");
            CharacterProfile.updateNamePattern();
        }
    }

    public void registerCommands(RegisterCommandsEvent event) {
        CommandRegistry.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LOGGER.info("[Persona] Commands registered.");
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PersonaNetworking.sendServerConfigToPlayer(serverPlayer);
        }
    }

    @EventBusSubscriber(modid="persona", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("[Persona] Client setup complete for {}", (Object)Minecraft.getInstance().getUser().getName());
            NeoForge.EVENT_BUS.addListener(AgingClientEvents::onCollectCharacterInfo);
            event.enqueueWork(() -> {
                if (FiguraReflector.isFiguraAvailable()) {
                    LOGGER.info("[Persona-Figura] Figura integration is active. Registering event listener for ClientPersonaSwitchedEvent.");
                    NeoForge.EVENT_BUS.register(FiguraClientEventListener.class);
                } else {
                    LOGGER.info("[Persona-Figura] Figura integration is disabled (Figura mod not found).");
                }
            });
        }
    }
}

