/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.client.gui.input;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import world.landfall.persona.Persona;
import world.landfall.persona.client.gui.input.CharacterCreationInputProvider;

public class CharacterCreationInputRegistry {
    private static final Map<ResourceLocation, CharacterCreationInputProvider> providers = new ConcurrentHashMap<ResourceLocation, CharacterCreationInputProvider>();

    public static boolean register(CharacterCreationInputProvider provider) {
        if (provider == null) {
            return false;
        }
        ResourceLocation id = provider.getId();
        if (providers.containsKey(id)) {
            Persona.LOGGER.warn("[Persona] Attempted to register duplicate CharacterCreationInputProvider with ID: {}", (Object)id);
            return false;
        }
        providers.put(id, provider);
        Persona.LOGGER.debug("[Persona] Registered CharacterCreationInputProvider: {}", (Object)id);
        return true;
    }

    public static CharacterCreationInputProvider unregister(ResourceLocation id) {
        if (id == null) {
            return null;
        }
        return providers.remove(id);
    }

    public static List<CharacterCreationInputProvider> getAll() {
        ArrayList<CharacterCreationInputProvider> sortedProviders = new ArrayList<CharacterCreationInputProvider>(providers.values());
        sortedProviders.sort(Comparator.comparingInt(CharacterCreationInputProvider::getPriority));
        return sortedProviders;
    }

    public static CharacterCreationInputProvider get(ResourceLocation id) {
        return providers.get(id);
    }

    public static void clear() {
        providers.clear();
    }

    public static int size() {
        return providers.size();
    }
}

