/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.aging;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import world.landfall.persona.Persona;
import world.landfall.persona.client.gui.input.CharacterCreationInputProvider;
import world.landfall.persona.config.ClientSyncedConfig;
import world.landfall.persona.config.Config;

public class AgingInputProvider
implements CharacterCreationInputProvider {
    private static final ResourceLocation ID = ResourceLocation.parse((String)"persona:aging_input");
    private static final Component DISPLAY_NAME = Component.translatable((String)"screen.persona.starting_age");
    private static final Component ERROR_FORMAT = Component.translatable((String)"gui.persona.error.invalid_age_format");
    private static final Component ERROR_TOO_YOUNG = Component.translatable((String)"gui.persona.error.age_too_young");
    private static final Component ERROR_TOO_OLD = Component.translatable((String)"gui.persona.error.age_too_old");
    private static final String STARTING_AGE_KEY = "StartingAge";

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Component getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public Component getPromptText() {
        double minAge = (Double)Config.MIN_CHARACTER_AGE.get();
        double maxAge = (Double)Config.MAX_CHARACTER_AGE.get();
        double defaultAge = (Double)Config.DEFAULT_CHARACTER_AGE.get();
        return Component.translatable((String)"screen.persona.starting_age_prompt", (Object[])new Object[]{String.format("%.1f", minAge), String.format("%.1f", maxAge), String.format("%.1f", defaultAge)});
    }

    @Override
    public EditBox createEditBox(Font font, int x, int y, int width, int height) {
        EditBox ageBox = new EditBox(font, x, y, width, height, this.getPromptText());
        ageBox.setMaxLength(7);
        ageBox.setValue(String.format("%.1f", Config.DEFAULT_CHARACTER_AGE.get()));
        ageBox.setFilter(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        return ageBox;
    }

    @Override
    public boolean validateInput(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            double age = Double.parseDouble(input);
            double minAge = (Double)Config.MIN_CHARACTER_AGE.get();
            double maxAge = (Double)Config.MAX_CHARACTER_AGE.get();
            return age >= minAge && age <= maxAge;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Component getValidationErrorMessage(String input) {
        if (input.isEmpty()) {
            return Component.empty();
        }
        try {
            double age = Double.parseDouble(input);
            double minAge = (Double)Config.MIN_CHARACTER_AGE.get();
            double maxAge = (Double)Config.MAX_CHARACTER_AGE.get();
            if (age < minAge) {
                return ERROR_TOO_YOUNG;
            }
            if (age > maxAge) {
                return ERROR_TOO_OLD;
            }
            return Component.empty();
        }
        catch (NumberFormatException e) {
            return ERROR_FORMAT;
        }
    }

    @Override
    public void processInput(String input, CompoundTag tag) {
        double age;
        if (input.isEmpty()) {
            age = (Double)Config.DEFAULT_CHARACTER_AGE.get();
            Persona.LOGGER.debug("[Persona] No starting age provided, using default: {}", (Object)age);
        } else {
            try {
                age = Double.parseDouble(input);
                age = Math.max((Double)Config.MIN_CHARACTER_AGE.get(), Math.min((Double)Config.MAX_CHARACTER_AGE.get(), age));
                Persona.LOGGER.debug("[Persona] Setting starting age to {}", (Object)age);
            }
            catch (NumberFormatException e) {
                age = (Double)Config.DEFAULT_CHARACTER_AGE.get();
                Persona.LOGGER.warn("[Persona] Invalid age format ({}), using default: {}", (Object)input, (Object)age);
            }
        }
        tag.putDouble(STARTING_AGE_KEY, age);
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean isVisible() {
        return ClientSyncedConfig.isAgingSystemEnabled();
    }
}

