/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.inventory;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.slf4j.Logger;

public class CuriosIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CURIOS_MOD_ID = "curios";
    private static Boolean curiosLoaded = null;
    private static boolean initializationFailed = false;
    private static Class<?> curiosApiClass;
    private static Class<?> iCuriosItemHandlerClass;
    private static Method getCuriosInventoryMethod;
    private static Method getCuriosMethod;

    public static boolean isLoaded() {
        if (curiosLoaded != null) {
            return curiosLoaded;
        }
        if (!ModList.get().isLoaded(CURIOS_MOD_ID)) {
            LOGGER.debug("[CuriosIntegration] Curios mod not found, integration disabled");
            curiosLoaded = false;
            return false;
        }
        try {
            CuriosIntegration.initializeCuriosReflection();
            curiosLoaded = true;
            LOGGER.info("[CuriosIntegration] Curios API initialized successfully");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[CuriosIntegration] Failed to initialize Curios API, integration disabled", (Throwable)e);
            curiosLoaded = false;
            initializationFailed = true;
            return false;
        }
    }

    private static void initializeCuriosReflection() throws Exception {
        curiosApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
        iCuriosItemHandlerClass = Class.forName("top.theillusivec4.curios.api.type.capability.ICuriosItemHandler");
        getCuriosInventoryMethod = curiosApiClass.getMethod("getCuriosInventory", LivingEntity.class);
        getCuriosMethod = iCuriosItemHandlerClass.getMethod("getCurios", new Class[0]);
        LOGGER.debug("[CuriosIntegration] All Curios API methods loaded successfully");
    }

    public static CompoundTag saveCuriosInventory(ServerPlayer player) {
        CompoundTag curiosTag = new CompoundTag();
        if (!CuriosIntegration.isLoaded() || initializationFailed) {
            return curiosTag;
        }
        try {
            Optional curiosInventoryOpt = (Optional)getCuriosInventoryMethod.invoke(null, player);
            if (curiosInventoryOpt.isEmpty()) {
                LOGGER.debug("[CuriosIntegration] No Curios inventory found for player {}", (Object)player.getName().getString());
                return curiosTag;
            }
            Object curiosInventory = curiosInventoryOpt.get();
            Map curiosMap = (Map)getCuriosMethod.invoke(curiosInventory, new Object[0]);
            ListTag curiosItemsList = new ListTag();
            int itemCount = 0;
            for (Map.Entry entry : curiosMap.entrySet()) {
                String identifier = (String)entry.getKey();
                Object stacksHandler = entry.getValue();
                Method getStacksMethod = stacksHandler.getClass().getMethod("getStacks", new Class[0]);
                Object handler = getStacksMethod.invoke(stacksHandler, new Object[0]);
                Method getSlotsMethod = handler.getClass().getMethod("getSlots", new Class[0]);
                Method getStackInSlotMethod = handler.getClass().getMethod("getStackInSlot", Integer.TYPE);
                int slots = (Integer)getSlotsMethod.invoke(handler, new Object[0]);
                for (int slot = 0; slot < slots; ++slot) {
                    ItemStack stack = (ItemStack)getStackInSlotMethod.invoke(handler, slot);
                    if (stack.isEmpty()) continue;
                    ++itemCount;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.putString("Identifier", identifier);
                    itemTag.putInt("Slot", slot);
                    itemTag.put("Item", stack.save((HolderLookup.Provider)player.registryAccess(), (Tag)new CompoundTag()));
                    curiosItemsList.add((Object)itemTag);
                }
            }
            curiosTag.put("CuriosItems", (Tag)curiosItemsList);
            LOGGER.debug("[CuriosIntegration] Saved {} Curios items for player {}", (Object)itemCount, (Object)player.getName().getString());
        }
        catch (Exception e) {
            LOGGER.error("[CuriosIntegration] Error saving Curios inventory for player {}", (Object)player.getName().getString(), (Object)e);
        }
        return curiosTag;
    }

    public static void loadCuriosInventory(ServerPlayer player, CompoundTag curiosTag) {
        if (!CuriosIntegration.isLoaded() || initializationFailed || curiosTag == null || !curiosTag.contains("CuriosItems")) {
            return;
        }
        try {
            Optional curiosInventoryOpt = (Optional)getCuriosInventoryMethod.invoke(null, player);
            if (curiosInventoryOpt.isEmpty()) {
                LOGGER.warn("[CuriosIntegration] No Curios inventory found for player {}, cannot load items", (Object)player.getName().getString());
                return;
            }
            Object curiosInventory = curiosInventoryOpt.get();
            Map curiosMap = (Map)getCuriosMethod.invoke(curiosInventory, new Object[0]);
            ListTag curiosItemsList = curiosTag.getList("CuriosItems", 10);
            int loadedCount = 0;
            int failedCount = 0;
            for (int i = 0; i < curiosItemsList.size(); ++i) {
                CompoundTag itemTag = curiosItemsList.getCompound(i);
                String identifier = itemTag.getString("Identifier");
                int slot = itemTag.getInt("Slot");
                try {
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)player.registryAccess(), (CompoundTag)itemTag.getCompound("Item"));
                    if (stack.isEmpty()) continue;
                    Object stacksHandler = curiosMap.get(identifier);
                    if (stacksHandler != null) {
                        Method getStacksMethod = stacksHandler.getClass().getMethod("getStacks", new Class[0]);
                        Object handler = getStacksMethod.invoke(stacksHandler, new Object[0]);
                        Method getSlotsMethod = handler.getClass().getMethod("getSlots", new Class[0]);
                        Method setStackInSlotMethod = handler.getClass().getMethod("setStackInSlot", Integer.TYPE, ItemStack.class);
                        int slots = (Integer)getSlotsMethod.invoke(handler, new Object[0]);
                        if (slot >= 0 && slot < slots) {
                            setStackInSlotMethod.invoke(handler, slot, stack);
                            ++loadedCount;
                            continue;
                        }
                        LOGGER.warn("[CuriosIntegration] Invalid slot {} for Curios identifier {} for player {}", new Object[]{slot, identifier, player.getName().getString()});
                        ++failedCount;
                        continue;
                    }
                    LOGGER.warn("[CuriosIntegration] Curios identifier '{}' not found for player {}, item not loaded", (Object)identifier, (Object)player.getName().getString());
                    ++failedCount;
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("[CuriosIntegration] Error loading Curios item at identifier '{}', slot {} for player {}", new Object[]{identifier, slot, player.getName().getString(), e});
                    ++failedCount;
                }
            }
            if (failedCount > 0) {
                LOGGER.warn("[CuriosIntegration] Loaded {} Curios items with {} failures for player {}", new Object[]{loadedCount, failedCount, player.getName().getString()});
            } else {
                LOGGER.debug("[CuriosIntegration] Successfully loaded {} Curios items for player {}", (Object)loadedCount, (Object)player.getName().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("[CuriosIntegration] Error loading Curios inventory for player {}", (Object)player.getName().getString(), (Object)e);
        }
    }

    public static void clearCuriosInventory(ServerPlayer player) {
        if (!CuriosIntegration.isLoaded() || initializationFailed) {
            return;
        }
        try {
            Optional curiosInventoryOpt = (Optional)getCuriosInventoryMethod.invoke(null, player);
            if (curiosInventoryOpt.isEmpty()) {
                LOGGER.debug("[CuriosIntegration] No Curios inventory found for player {}, nothing to clear", (Object)player.getName().getString());
                return;
            }
            Object curiosInventory = curiosInventoryOpt.get();
            Map curiosMap = (Map)getCuriosMethod.invoke(curiosInventory, new Object[0]);
            int clearedCount = 0;
            for (Map.Entry entry : curiosMap.entrySet()) {
                Object stacksHandler = entry.getValue();
                Method getStacksMethod = stacksHandler.getClass().getMethod("getStacks", new Class[0]);
                Object handler = getStacksMethod.invoke(stacksHandler, new Object[0]);
                Method getSlotsMethod = handler.getClass().getMethod("getSlots", new Class[0]);
                Method setStackInSlotMethod = handler.getClass().getMethod("setStackInSlot", Integer.TYPE, ItemStack.class);
                int slots = (Integer)getSlotsMethod.invoke(handler, new Object[0]);
                for (int slot = 0; slot < slots; ++slot) {
                    setStackInSlotMethod.invoke(handler, slot, ItemStack.EMPTY);
                    ++clearedCount;
                }
            }
            LOGGER.debug("[CuriosIntegration] Cleared {} Curios slots for player {}", (Object)clearedCount, (Object)player.getName().getString());
        }
        catch (Exception e) {
            LOGGER.error("[CuriosIntegration] Error clearing Curios inventory for player {}", (Object)player.getName().getString(), (Object)e);
        }
    }

    public static boolean isCuriosInventoryEmpty(ServerPlayer player) {
        if (!CuriosIntegration.isLoaded() || initializationFailed) {
            return true;
        }
        try {
            Optional curiosInventoryOpt = (Optional)getCuriosInventoryMethod.invoke(null, player);
            if (curiosInventoryOpt.isEmpty()) {
                return true;
            }
            Object curiosInventory = curiosInventoryOpt.get();
            Map curiosMap = (Map)getCuriosMethod.invoke(curiosInventory, new Object[0]);
            for (Map.Entry entry : curiosMap.entrySet()) {
                Object stacksHandler = entry.getValue();
                Method getStacksMethod = stacksHandler.getClass().getMethod("getStacks", new Class[0]);
                Object handler = getStacksMethod.invoke(stacksHandler, new Object[0]);
                Method getSlotsMethod = handler.getClass().getMethod("getSlots", new Class[0]);
                Method getStackInSlotMethod = handler.getClass().getMethod("getStackInSlot", Integer.TYPE);
                int slots = (Integer)getSlotsMethod.invoke(handler, new Object[0]);
                for (int slot = 0; slot < slots; ++slot) {
                    ItemStack stack = (ItemStack)getStackInSlotMethod.invoke(handler, slot);
                    if (stack.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[CuriosIntegration] Error checking if Curios inventory is empty for player {}", (Object)player.getName().getString(), (Object)e);
            return true;
        }
    }
}

