/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.inventory;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterFileStorage;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.features.inventory.CuriosIntegration;
import world.landfall.persona.registry.PersonaEvents;

@EventBusSubscriber(modid="persona")
public class InventoryHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation INVENTORY_KEY = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"inventory");
    private static final ConcurrentHashMap<UUID, ReentrantLock> playerLocks = new ConcurrentHashMap();

    private static ReentrantLock getPlayerLock(UUID playerId) {
        return playerLocks.computeIfAbsent(playerId, k -> new ReentrantLock());
    }

    public static void cleanupPlayerLock(UUID playerId) {
        playerLocks.remove(playerId);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            InventoryHandler.cleanupPlayerLock(serverPlayer.getUUID());
            LOGGER.debug("[InventoryHandler] Cleaned up player lock for {}", (Object)serverPlayer.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onCreate(PersonaEvents.CharacterCreateEvent event) {
        if (!((Boolean)Config.ENABLE_INVENTORY_SYSTEM.get()).booleanValue()) {
            return;
        }
        try {
            LOGGER.debug("[InventoryHandler] Create event for player: {}, character: {}", (Object)event.getPlayer().getName().getString(), (Object)event.getCharacterId());
            CharacterProfile profile = event.getProfile();
            if (profile != null) {
                Player player = event.getPlayer();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlayerCharacterData characterData = (PlayerCharacterData)serverPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
                    if (characterData != null && characterData.getActiveCharacterId() == null) {
                        CompoundTag currentInventory = InventoryHandler.saveInventory(serverPlayer);
                        profile.setModData(INVENTORY_KEY, currentInventory);
                        LOGGER.debug("[InventoryHandler] Transferred player's current inventory to first character: {} ({} items)", (Object)event.getCharacterId(), (Object)currentInventory.getList("Items", 10).size());
                    } else {
                        profile.setModData(INVENTORY_KEY, new CompoundTag());
                        LOGGER.debug("[InventoryHandler] Initialized empty inventory data for character: {}", (Object)event.getCharacterId());
                    }
                } else {
                    profile.setModData(INVENTORY_KEY, new CompoundTag());
                    LOGGER.debug("[InventoryHandler] Initialized empty inventory data for character: {}", (Object)event.getCharacterId());
                }
            } else {
                LOGGER.warn("[InventoryHandler] CharacterProfile is null in CreateEvent for character: {}. Cannot initialize inventory data.", (Object)event.getCharacterId());
            }
        }
        catch (Exception e) {
            LOGGER.error("[InventoryHandler] Error in CharacterCreateEvent handler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPreSwitch(PersonaEvents.CharacterPreSwitchEvent event) {
        if (!((Boolean)Config.ENABLE_INVENTORY_SYSTEM.get()).booleanValue()) {
            event.getReady().complete(null);
            return;
        }
        try {
            block19: {
                Player player = event.getPlayer();
                if (!(player instanceof ServerPlayer)) {
                    LOGGER.warn("[InventoryHandler] Player is not a ServerPlayer, skipping inventory save.");
                    event.getReady().complete(null);
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerPlayer player2 = serverPlayer;
                UUID playerId = player2.getUUID();
                Long fromCharacterId = event.getFromCharacterId();
                LOGGER.debug("[InventoryHandler] PreSwitch event for player: {} (ID: {}), from character: {}", new Object[]{player2.getName().getString(), playerId, fromCharacterId});
                ReentrantLock playerLock = InventoryHandler.getPlayerLock(playerId);
                playerLock.lock();
                try {
                    if (fromCharacterId != null) {
                        PlayerCharacterData characterData = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
                        if (characterData == null) {
                            LOGGER.error("[InventoryHandler] PlayerCharacterData is null for player {}. Cannot save inventory.", (Object)playerId);
                            playerLock.unlock();
                            event.getReady().complete(null);
                            return;
                        }
                        CharacterProfile fromProfile = characterData.getCharacter(fromCharacterId);
                        if (fromProfile != null) {
                            CompoundTag inventoryTag = InventoryHandler.saveInventory(player2);
                            CompoundTag previousInventoryTag = fromProfile.getModData(INVENTORY_KEY);
                            fromProfile.setModData(INVENTORY_KEY, inventoryTag);
                            boolean saveSuccess = false;
                            try {
                                saveSuccess = CharacterFileStorage.saveCharacter(fromProfile);
                                if (!saveSuccess) {
                                    LOGGER.error("[InventoryHandler] Failed to save character file for {}. Rolling back inventory data.", (Object)fromCharacterId);
                                    if (previousInventoryTag != null) {
                                        fromProfile.setModData(INVENTORY_KEY, previousInventoryTag);
                                    } else {
                                        fromProfile.removeModData(INVENTORY_KEY);
                                    }
                                } else {
                                    LOGGER.debug("[InventoryHandler] Saved inventory for character {} ({} items). Player: {}", new Object[]{fromCharacterId, inventoryTag.getList("Items", 10).size(), playerId});
                                }
                                break block19;
                            }
                            catch (Exception e) {
                                LOGGER.error("[InventoryHandler] Exception while saving character file for {}. Rolling back.", (Object)fromCharacterId, (Object)e);
                                if (previousInventoryTag != null) {
                                    fromProfile.setModData(INVENTORY_KEY, previousInventoryTag);
                                } else {
                                    fromProfile.removeModData(INVENTORY_KEY);
                                }
                                throw e;
                            }
                        }
                        LOGGER.warn("[InventoryHandler] 'From' CharacterProfile is null for character: {}. Cannot save inventory.", (Object)fromCharacterId);
                        break block19;
                    }
                    LOGGER.debug("[InventoryHandler] No 'from' character ID, nothing to save for inventory.");
                }
                finally {
                    playerLock.unlock();
                }
            }
            event.getReady().complete(null);
        }
        catch (Exception e) {
            LOGGER.error("[InventoryHandler] Error in PreSwitch event handler for inventory", (Throwable)e);
            event.getReady().complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onSwitch(PersonaEvents.CharacterSwitchEvent event) {
        block15: {
            if (!((Boolean)Config.ENABLE_INVENTORY_SYSTEM.get()).booleanValue()) {
                return;
            }
            try {
                Player player = event.getPlayer();
                if (!(player instanceof ServerPlayer)) {
                    LOGGER.warn("[InventoryHandler] Player is not a ServerPlayer, skipping inventory load.");
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerPlayer player2 = serverPlayer;
                UUID playerId = player2.getUUID();
                Long toCharacterId = event.getToCharacterId();
                LOGGER.debug("[InventoryHandler] Switch event for player: {} (ID: {}), to character: {}", new Object[]{player2.getName().getString(), playerId, toCharacterId});
                ReentrantLock playerLock = InventoryHandler.getPlayerLock(playerId);
                playerLock.lock();
                try {
                    if (toCharacterId != null) {
                        PlayerCharacterData characterData = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
                        if (characterData == null) {
                            LOGGER.error("[InventoryHandler] PlayerCharacterData is null for player {}. Cannot load inventory. Clearing inventory.", (Object)playerId);
                            InventoryHandler.clearInventorySafely(player2);
                            return;
                        }
                        CharacterProfile toProfile = characterData.getCharacter(toCharacterId);
                        if (toProfile != null) {
                            CompoundTag inventoryTag = toProfile.getModData(INVENTORY_KEY);
                            if (inventoryTag != null && !inventoryTag.isEmpty()) {
                                InventoryHandler.loadInventory(player2, inventoryTag);
                                LOGGER.debug("[InventoryHandler] Loaded inventory for character {} ({} items). Player: {}", new Object[]{toCharacterId, inventoryTag.getList("Items", 10).size(), playerId});
                            } else {
                                LOGGER.debug("[InventoryHandler] No inventory data found for character {}, clearing inventory. Player: {}", (Object)toCharacterId, (Object)playerId);
                                InventoryHandler.clearInventorySafely(player2);
                            }
                        } else {
                            LOGGER.warn("[InventoryHandler] 'To' CharacterProfile is null for character: {}. Cannot load inventory. Clearing inventory.", (Object)toCharacterId);
                            InventoryHandler.clearInventorySafely(player2);
                        }
                    } else {
                        LOGGER.warn("[InventoryHandler] 'To' character ID is null. Clearing inventory as a precaution.");
                        InventoryHandler.clearInventorySafely(player2);
                    }
                }
                finally {
                    playerLock.unlock();
                }
            }
            catch (Exception e) {
                LOGGER.error("[InventoryHandler] Error in Switch event handler for inventory", (Throwable)e);
                Player player = event.getPlayer();
                if (!(player instanceof ServerPlayer)) break block15;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                InventoryHandler.clearInventorySafely(serverPlayer);
                LOGGER.error("[InventoryHandler] Cleared inventory for player {} due to error.", (Object)serverPlayer.getName().getString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onDelete(PersonaEvents.CharacterDeleteEvent event) {
        if (!((Boolean)Config.ENABLE_INVENTORY_SYSTEM.get()).booleanValue()) {
            return;
        }
        try {
            Player player = event.getPlayer();
            if (!(player instanceof ServerPlayer)) {
                LOGGER.warn("[InventoryHandler] Player is not a ServerPlayer, skipping inventory transfer check.");
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Long characterId = event.getCharacterId();
            UUID playerId = serverPlayer.getUUID();
            LOGGER.debug("[InventoryHandler] Delete event for player: {}, character: {}", (Object)serverPlayer.getName().getString(), (Object)characterId);
            ReentrantLock playerLock = InventoryHandler.getPlayerLock(playerId);
            playerLock.lock();
            try {
                PlayerCharacterData characterData = (PlayerCharacterData)serverPlayer.getData(PlayerCharacterCapability.CHARACTER_DATA);
                if (characterData == null) {
                    LOGGER.error("[InventoryHandler] PlayerCharacterData is null for player {}. Cannot check character for inventory transfer.", (Object)playerId);
                    return;
                }
                CharacterProfile characterToDelete = characterData.getCharacter(characterId);
                if (characterToDelete == null) {
                    LOGGER.warn("[InventoryHandler] Character {} not found for player {}. Cannot check for inventory transfer.", (Object)characterId, (Object)playerId);
                    return;
                }
                CompoundTag inventoryTag = characterToDelete.getModData(INVENTORY_KEY);
                if (inventoryTag == null || inventoryTag.isEmpty() || !inventoryTag.contains("Items")) {
                    LOGGER.debug("[InventoryHandler] Character {} has no inventory to transfer.", (Object)characterId);
                    return;
                }
                ListTag itemsList = inventoryTag.getList("Items", 10);
                if (itemsList.isEmpty()) {
                    LOGGER.debug("[InventoryHandler] Character {} has empty inventory, no transfer needed.", (Object)characterId);
                    return;
                }
                if (!InventoryHandler.isInventoryEmpty(serverPlayer)) {
                    event.setCanceled(true);
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"gui.persona.error.inventory_not_empty_for_transfer", (Object[])new Object[]{characterToDelete.getDisplayName()}));
                    LOGGER.debug("[InventoryHandler] Cancelled deletion of character {} - player {} inventory is not empty.", (Object)characterId, (Object)serverPlayer.getName().getString());
                    return;
                }
                InventoryHandler.loadInventory(serverPlayer, inventoryTag);
                LOGGER.debug("[InventoryHandler] Transferred {} items from character {} to player {}", new Object[]{itemsList.size(), characterToDelete.getDisplayName(), serverPlayer.getName().getString()});
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"gui.persona.success.inventory_transferred", (Object[])new Object[]{itemsList.size(), characterToDelete.getDisplayName()}));
            }
            finally {
                playerLock.unlock();
            }
        }
        catch (Exception e) {
            LOGGER.error("[InventoryHandler] Error in Delete event handler for inventory transfer", (Throwable)e);
        }
    }

    private static boolean isInventoryEmpty(ServerPlayer player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (player.getInventory().getItem(i).isEmpty()) continue;
            return false;
        }
        return !CuriosIntegration.isLoaded() || CuriosIntegration.isCuriosInventoryEmpty(player);
    }

    public static CompoundTag saveInventory(ServerPlayer player) {
        CompoundTag curiosTag;
        CompoundTag inventoryTag = new CompoundTag();
        ListTag itemsList = new ListTag();
        int itemCount = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            itemTag.put("Item", stack.save((HolderLookup.Provider)player.registryAccess(), (Tag)new CompoundTag()));
            itemsList.add((Object)itemTag);
        }
        inventoryTag.put("Items", (Tag)itemsList);
        if (CuriosIntegration.isLoaded() && !(curiosTag = CuriosIntegration.saveCuriosInventory(player)).isEmpty()) {
            inventoryTag.put("Curios", (Tag)curiosTag);
            LOGGER.debug("[InventoryHandler] Saved Curios inventory for player {}", (Object)player.getName().getString());
        }
        LOGGER.debug("[InventoryHandler] Saved {} inventory items for player {}", (Object)itemCount, (Object)player.getName().getString());
        return inventoryTag;
    }

    private static void clearInventorySafely(ServerPlayer player) {
        try {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            if (CuriosIntegration.isLoaded()) {
                CuriosIntegration.clearCuriosInventory(player);
            }
            player.inventoryMenu.broadcastChanges();
            LOGGER.debug("[InventoryHandler] Safely cleared inventory for player {}", (Object)player.getName().getString());
        }
        catch (Exception e) {
            LOGGER.error("[InventoryHandler] Error clearing inventory for player {}", (Object)player.getName().getString(), (Object)e);
            player.getInventory().clearContent();
            player.inventoryMenu.broadcastChanges();
        }
    }

    private static void loadInventory(ServerPlayer player, CompoundTag inventoryTag) {
        InventoryHandler.loadInventoryInternal(player, inventoryTag, false);
    }

    private static void loadInventoryInternal(ServerPlayer player, CompoundTag inventoryTag, boolean isRollback) {
        CompoundTag backupInventory = null;
        if (!isRollback) {
            backupInventory = InventoryHandler.saveInventory(player);
        }
        try {
            InventoryHandler.clearInventorySafely(player);
            ListTag itemsList = inventoryTag.getList("Items", 10);
            int loadedCount = 0;
            int failedCount = 0;
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.getCompound(i);
                int slot = itemTag.getInt("Slot");
                try {
                    ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)player.registryAccess(), (CompoundTag)itemTag.getCompound("Item"));
                    if (!stack.isEmpty() && slot >= 0 && slot < player.getInventory().getContainerSize()) {
                        if (player.getInventory().getItem(slot).isEmpty()) {
                            player.getInventory().setItem(slot, stack);
                            ++loadedCount;
                            continue;
                        }
                        LOGGER.warn("[InventoryHandler] Slot {} was not empty when loading item {} for player {}. Attempting to find empty slot.", new Object[]{slot, stack.getDescriptionId(), player.getName().getString()});
                        boolean placed = false;
                        for (int j = 0; j < player.getInventory().getContainerSize(); ++j) {
                            if (!player.getInventory().getItem(j).isEmpty()) continue;
                            player.getInventory().setItem(j, stack);
                            ++loadedCount;
                            placed = true;
                            LOGGER.debug("[InventoryHandler] Placed item {} in alternative slot {} for player {}", new Object[]{stack.getDescriptionId(), j, player.getName().getString()});
                            break;
                        }
                        if (placed) continue;
                        ++failedCount;
                        LOGGER.error("[InventoryHandler] Failed to place item {} - no empty slots available for player {}", (Object)stack.getDescriptionId(), (Object)player.getName().getString());
                        continue;
                    }
                    if (stack.isEmpty()) continue;
                    LOGGER.warn("[InventoryHandler] Invalid slot {} for item {} for player {}. Item not loaded.", new Object[]{slot, stack.getDescriptionId(), player.getName().getString()});
                    ++failedCount;
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("[InventoryHandler] Error parsing item at slot {} for player {}", new Object[]{slot, player.getName().getString(), e});
                    ++failedCount;
                }
            }
            if (CuriosIntegration.isLoaded() && inventoryTag.contains("Curios")) {
                CuriosIntegration.loadCuriosInventory(player, inventoryTag.getCompound("Curios"));
            }
            player.inventoryMenu.broadcastChanges();
            if (failedCount > 0) {
                LOGGER.warn("[InventoryHandler] Loaded {} inventory items with {} failures for player {}", new Object[]{loadedCount, failedCount, player.getName().getString()});
                player.sendSystemMessage((Component)Component.translatable((String)"gui.persona.warning.inventory_load_partial", (Object[])new Object[]{loadedCount, failedCount}));
            } else {
                LOGGER.debug("[InventoryHandler] Successfully loaded {} inventory items for player {}", (Object)loadedCount, (Object)player.getName().getString());
            }
        }
        catch (Exception e) {
            LOGGER.error("[InventoryHandler] Critical error loading inventory for player {}. {}", new Object[]{player.getName().getString(), isRollback ? "Rollback failed!" : "Attempting rollback.", e});
            if (!isRollback && backupInventory != null) {
                try {
                    InventoryHandler.clearInventorySafely(player);
                    InventoryHandler.loadInventoryInternal(player, backupInventory, true);
                }
                catch (Exception rollbackError) {
                    LOGGER.error("[InventoryHandler] Failed to rollback inventory for player {}", (Object)player.getName().getString(), (Object)rollbackError);
                    player.sendSystemMessage((Component)Component.translatable((String)"gui.persona.error.inventory_load_critical"));
                }
            }
            throw new RuntimeException("Failed to load inventory", e);
        }
    }

    static {
        LOGGER.debug("InventoryHandler loaded for Persona.");
    }
}

