/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import world.landfall.persona.features.landfalladdon.decay.DecayStages;
import world.landfall.persona.features.landfalladdon.shells.Shell;

public class ActionBarManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DECAY_LABEL = "Decay: ";
    private static final String SHELL_LABEL = "Shell: ";
    private static final String SEPARATOR = " | ";
    private static final String FALLBACK_DECAY_TEXT = "Unknown";
    private static final String FALLBACK_SHELL_TEXT = "unknown";
    private static final int MAX_DECAY_NAME_LENGTH = 50;
    private static final int MAX_SHELL_NAME_LENGTH = 50;

    public static void updatePlayerStatus(ServerPlayer player, DecayStages decayStage, Shell shell) {
        Objects.requireNonNull(player, "ServerPlayer cannot be null");
        Objects.requireNonNull(decayStage, "DecayStages cannot be null");
        Objects.requireNonNull(shell, "Shell cannot be null");
        try {
            if (!ActionBarManager.isPlayerValid(player)) {
                LOGGER.debug("Player {} is not in a valid state for action bar update", (Object)ActionBarManager.getPlayerName(player));
                return;
            }
            Component message = ActionBarManager.buildActionBarMessage(decayStage, shell);
            if (message == null) {
                LOGGER.warn("Failed to build action bar message for player {}", (Object)ActionBarManager.getPlayerName(player));
                return;
            }
            ActionBarManager.sendActionBarMessage(player, message);
            LOGGER.debug("Updated action bar for player {} with decay: {} and shell: {}", new Object[]{ActionBarManager.getPlayerName(player), decayStage, shell});
        }
        catch (Exception e) {
            LOGGER.error("Error updating action bar for player {} (decay: {}, shell: {})", new Object[]{ActionBarManager.getPlayerName(player), decayStage, shell, e});
        }
    }

    private static Component buildActionBarMessage(DecayStages decayStage, Shell shell) {
        try {
            String decayDisplayName = ActionBarManager.getValidatedDecayDisplayName(decayStage);
            ChatFormatting decayColor = ActionBarManager.getDecayColor(decayStage);
            String shellDisplayName = ActionBarManager.getValidatedShellDisplayName(shell);
            return Component.literal((String)DECAY_LABEL).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)decayDisplayName).withStyle(decayColor)).append((Component)Component.literal((String)SEPARATOR).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD})).append((Component)Component.literal((String)SHELL_LABEL).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)shellDisplayName).withStyle(ChatFormatting.GOLD));
        }
        catch (Exception e) {
            LOGGER.error("Error building action bar message for decay: {} and shell: {}", new Object[]{decayStage, shell, e});
            return null;
        }
    }

    private static ChatFormatting getDecayColor(DecayStages stage) {
        if (stage == null) {
            LOGGER.warn("Null decay stage provided to getDecayColor, using default");
            return ChatFormatting.GRAY;
        }
        try {
            return switch (stage) {
                default -> throw new MatchException(null, null);
                case DecayStages.STABLE -> ChatFormatting.GREEN;
                case DecayStages.MILD -> ChatFormatting.YELLOW;
                case DecayStages.MODERATE -> ChatFormatting.GOLD;
                case DecayStages.HIGH -> ChatFormatting.RED;
                case DecayStages.SEVERE -> ChatFormatting.DARK_RED;
            };
        }
        catch (Exception e) {
            LOGGER.error("Error getting decay color for stage {}, using default", (Object)stage, (Object)e);
            return ChatFormatting.GRAY;
        }
    }

    private static String getValidatedDecayDisplayName(DecayStages decayStage) {
        try {
            String displayName = decayStage.getDisplayName();
            if (displayName == null || displayName.isBlank()) {
                LOGGER.warn("Decay stage {} has null/blank display name, using fallback", (Object)decayStage);
                return FALLBACK_DECAY_TEXT;
            }
            if ((displayName = displayName.trim()).length() > 50) {
                LOGGER.warn("Decay display name too long ({}), truncating: {}", (Object)displayName.length(), (Object)displayName);
                displayName = displayName.substring(0, 50);
            }
            return displayName;
        }
        catch (Exception e) {
            LOGGER.error("Error getting display name for decay stage {}, using fallback", (Object)decayStage, (Object)e);
            return FALLBACK_DECAY_TEXT;
        }
    }

    private static String getValidatedShellDisplayName(Shell shell) {
        try {
            String shellName = shell.name();
            if (shellName == null || shellName.isBlank()) {
                LOGGER.warn("Shell {} has null/blank name, using fallback", (Object)shell);
                return FALLBACK_SHELL_TEXT;
            }
            String displayName = shellName.toLowerCase().replace('_', ' ');
            if (displayName.length() > 50) {
                LOGGER.warn("Shell display name too long ({}), truncating: {}", (Object)displayName.length(), (Object)displayName);
                displayName = displayName.substring(0, 50);
            }
            return displayName;
        }
        catch (Exception e) {
            LOGGER.error("Error getting display name for shell {}, using fallback", (Object)shell, (Object)e);
            return FALLBACK_SHELL_TEXT;
        }
    }

    private static void sendActionBarMessage(ServerPlayer player, Component message) {
        try {
            player.displayClientMessage(message, true);
        }
        catch (Exception e) {
            LOGGER.error("Error sending action bar message to player {}", (Object)ActionBarManager.getPlayerName(player), (Object)e);
        }
    }

    private static boolean isPlayerValid(ServerPlayer player) {
        try {
            return player.connection != null && !player.hasDisconnected() && player.isAlive();
        }
        catch (Exception e) {
            LOGGER.debug("Error validating player state for {}", (Object)ActionBarManager.getPlayerName(player), (Object)e);
            return false;
        }
    }

    private static String getPlayerName(ServerPlayer player) {
        try {
            if (player == null) {
                return "null";
            }
            Component name = player.getName();
            if (name == null) {
                return "unnamed";
            }
            String nameString = name.getString();
            return nameString != null ? nameString : "unnamed";
        }
        catch (Exception e) {
            return "error-getting-name";
        }
    }

    public static void clearActionBar(ServerPlayer player) {
        Objects.requireNonNull(player, "ServerPlayer cannot be null");
        try {
            if (!ActionBarManager.isPlayerValid(player)) {
                LOGGER.debug("Player {} is not in a valid state for action bar clear", (Object)ActionBarManager.getPlayerName(player));
                return;
            }
            ActionBarManager.sendActionBarMessage(player, (Component)Component.empty());
            LOGGER.debug("Cleared action bar for player {}", (Object)ActionBarManager.getPlayerName(player));
        }
        catch (Exception e) {
            LOGGER.error("Error clearing action bar for player {}", (Object)ActionBarManager.getPlayerName(player), (Object)e);
        }
    }

    public static void updateActionBarWithCustomMessage(ServerPlayer player, String message) {
        Objects.requireNonNull(player, "ServerPlayer cannot be null");
        Objects.requireNonNull(message, "Message cannot be null");
        try {
            if (!ActionBarManager.isPlayerValid(player)) {
                LOGGER.debug("Player {} is not in a valid state for custom action bar update", (Object)ActionBarManager.getPlayerName(player));
                return;
            }
            String sanitizedMessage = message.trim();
            if (sanitizedMessage.length() > 100) {
                LOGGER.warn("Custom action bar message too long ({}), truncating", (Object)sanitizedMessage.length());
                sanitizedMessage = sanitizedMessage.substring(0, 100);
            }
            MutableComponent messageComponent = Component.literal((String)sanitizedMessage);
            ActionBarManager.sendActionBarMessage(player, (Component)messageComponent);
            LOGGER.debug("Updated action bar for player {} with custom message", (Object)ActionBarManager.getPlayerName(player));
        }
        catch (Exception e) {
            LOGGER.error("Error updating action bar with custom message for player {}", (Object)ActionBarManager.getPlayerName(player), (Object)e);
        }
    }

    public static boolean validateConfiguration() {
        try {
            Class.forName("net.minecraft.network.chat.Component");
            Class.forName("net.minecraft.ChatFormatting");
            Class.forName("world.landfall.persona.features.landfalladdon.decay.DecayStages");
            Class.forName("world.landfall.persona.features.landfalladdon.shells.Shell");
            if (DECAY_LABEL == null || SHELL_LABEL == null || SEPARATOR == null) {
                LOGGER.error("ActionBarManager constants are null");
                return false;
            }
            LOGGER.debug("ActionBarManager configuration validation passed");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("ActionBarManager configuration validation failed - missing required class", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("ActionBarManager configuration validation failed", (Throwable)e);
            return false;
        }
    }
}

