/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon;

import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class PersonaLFEIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Class<?> regionManagerClass = null;
    private static Method isPlayerInTaggedRegionMethod = null;
    private static Method getPlayerRegionTagsMethod = null;
    private static boolean lfeAvailable = false;

    public static boolean isLFEAvailable() {
        return lfeAvailable;
    }

    public static boolean isPlayerInTaggedRegion(Player player, String tag) {
        if (!lfeAvailable || player == null || tag == null) {
            return false;
        }
        try {
            Object result = isPlayerInTaggedRegionMethod.invoke(null, player, tag);
            return (Boolean)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("[Persona] Error calling LFE isPlayerInTaggedRegion: " + e.getMessage());
            return false;
        }
    }

    public static Set<String> getPlayerRegionTags(Player player) {
        if (!lfeAvailable || player == null) {
            return new HashSet<String>();
        }
        try {
            Object result = getPlayerRegionTagsMethod.invoke(null, player);
            return (Set)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("[Persona] Error calling LFE getPlayerRegionTags: " + e.getMessage());
            return new HashSet<String>();
        }
    }

    public static boolean isPlayerInGodfallRegion(Player player) {
        return PersonaLFEIntegration.isPlayerInTaggedRegion(player, "godfall");
    }

    static {
        try {
            regionManagerClass = Class.forName("world.landfall.landfallessentials.regions.RegionManager");
            isPlayerInTaggedRegionMethod = regionManagerClass.getMethod("isPlayerInTaggedRegion", Player.class, String.class);
            getPlayerRegionTagsMethod = regionManagerClass.getMethod("getPlayerRegionTags", Player.class);
            lfeAvailable = true;
            LOGGER.info("[Persona] LFE integration enabled - RegionManager found");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            lfeAvailable = false;
            LOGGER.info("[Persona] LFE not found - region tag integration disabled");
        }
    }
}

