/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.features.landfalladdon.LandfallAddonData;
import world.landfall.persona.registry.PersonaEvents;

@EventBusSubscriber(modid="persona")
public class SpawnPointHandler {
    @SubscribeEvent
    public static void onSetSpawnPoint(PlayerSetSpawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        Long activeId = data.getActiveCharacterId();
        if (activeId == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(activeId);
        if (profile == null) {
            return;
        }
        BlockPos pos = event.getNewSpawn();
        if (pos == null) {
            profile.removeModData(LandfallAddonData.DATA_KEY);
            return;
        }
        LandfallAddonData.setSpawnPoint(profile, pos.getX(), pos.getY(), pos.getZ(), player2.level().dimension().location(), event.isForced());
    }

    @SubscribeEvent
    public static void onCharacterSwitch(PersonaEvents.CharacterSwitchEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        if (event.getToCharacterId() == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(event.getToCharacterId());
        if (profile == null) {
            return;
        }
        if (LandfallAddonData.hasSpawnPoint(profile)) {
            GlobalPos spawnPos = LandfallAddonData.getSpawnPoint(profile);
            boolean forced = LandfallAddonData.isSpawnForced(profile);
            if (spawnPos != null) {
                player2.setRespawnPosition(spawnPos.dimension(), spawnPos.pos(), 0.0f, forced, false);
            }
        } else {
            player2.setRespawnPosition(null, null, 0.0f, false, false);
        }
    }
}

