/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon.shells;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;

public enum Shell {
    SWIFT("Slightly faster movement", Map.of("DIVINET_TOUCHED", 5, "NULLBORN", 15, "MOONSPAWN", 10)),
    SLUGGISH("Slightly slower movement", Map.of("DIVINET_TOUCHED", 15, "NULLBORN", 5, "MOONSPAWN", 10)),
    ROBUST("Slightly increased resilience", Map.of("DIVINET_TOUCHED", 5, "NULLBORN", 15, "MOONSPAWN", 10)),
    FRAIL("Slightly decreased resilience", Map.of("DIVINET_TOUCHED", 15, "NULLBORN", 5, "MOONSPAWN", 10)),
    KEEN_EYES("Slightly improved perception", Map.of("DIVINET_TOUCHED", 5, "NULLBORN", 15, "MOONSPAWN", 10)),
    CLUMSY("Slightly more prone to mishaps", Map.of("DIVINET_TOUCHED", 15, "NULLBORN", 5, "MOONSPAWN", 10)),
    NEUTRAL("No particular trait", Collections.emptyMap());

    private static final Logger LOGGER;
    private final String description;
    private final Map<String, Integer> originWeights;
    public static final int DEFAULT_WEIGHT = 1;
    public static final int MAX_WEIGHT = 1000;
    public static final int MIN_WEIGHT = 0;

    private Shell(String description, Map<String, Integer> originWeights) {
        this.description = Objects.requireNonNull(description, "Shell description cannot be null");
        this.originWeights = Shell.validateAndCopyWeights(originWeights);
    }

    private static Map<String, Integer> validateAndCopyWeights(Map<String, Integer> weights) {
        if (weights == null) {
            LOGGER.warn("Null weights map provided, using empty map");
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> validatedWeights = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : weights.entrySet()) {
            String origin = entry.getKey();
            Integer weight = entry.getValue();
            if (origin == null || origin.isBlank()) {
                LOGGER.warn("Skipping null or blank origin in weights map");
                continue;
            }
            if (weight == null) {
                LOGGER.warn("Null weight for origin {}, using 0", (Object)origin);
                weight = 0;
            }
            if (weight < 0 || weight > 1000) {
                LOGGER.warn("Weight {} for origin {} is out of bounds [{}, {}], clamping", new Object[]{weight, origin, 0, 1000});
                weight = Math.max(0, Math.min(1000, weight));
            }
            validatedWeights.put(origin.trim().toUpperCase(), weight);
        }
        return Collections.unmodifiableMap(validatedWeights);
    }

    public String getDescription() {
        return this.description;
    }

    public int getWeight(String origin) {
        if (origin == null) {
            throw new IllegalArgumentException("Origin cannot be null");
        }
        String normalizedOrigin = origin.trim().toUpperCase();
        if (normalizedOrigin.isEmpty()) {
            LOGGER.warn("Empty origin provided, using default weight behavior");
            return this == NEUTRAL ? 0 : 1;
        }
        if (this == NEUTRAL) {
            return this.originWeights.getOrDefault(normalizedOrigin, 0);
        }
        return this.originWeights.getOrDefault(normalizedOrigin, 1);
    }

    public Set<String> getDefinedOrigins() {
        return this.originWeights.keySet();
    }

    public boolean hasExplicitWeight(String origin) {
        if (origin == null || origin.isBlank()) {
            return false;
        }
        return this.originWeights.containsKey(origin.trim().toUpperCase());
    }

    public Map<String, Integer> getAllWeights() {
        return new HashMap<String, Integer>(this.originWeights);
    }

    public boolean isValid() {
        try {
            if (this.description == null || this.description.isBlank()) {
                LOGGER.error("Shell {} has null or blank description", (Object)this.name());
                return false;
            }
            for (Map.Entry<String, Integer> entry : this.originWeights.entrySet()) {
                String origin = entry.getKey();
                Integer weight = entry.getValue();
                if (origin == null || origin.isBlank()) {
                    LOGGER.error("Shell {} has null or blank origin", (Object)this.name());
                    return false;
                }
                if (weight != null && weight >= 0 && weight <= 1000) continue;
                LOGGER.error("Shell {} has invalid weight {} for origin {}", new Object[]{this.name(), weight, origin});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error validating shell {}", (Object)this.name(), (Object)e);
            return false;
        }
    }

    public String toString() {
        return String.format("Shell{name=%s, description='%s', weights=%d}", this.name(), this.description, this.originWeights.size());
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

