/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.util;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import world.landfall.persona.util.CharacterUtils;

@EventBusSubscriber(modid="persona")
public final class CharacterSwitchCooldownManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final long COOLDOWN_DURATION_MS = 3000L;
    private static final ConcurrentHashMap<UUID, Long> lastSwitchTimes = new ConcurrentHashMap();

    private CharacterSwitchCooldownManager() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static boolean canSwitchCharacter(@Nullable ServerPlayer player) {
        if (player == null) {
            LOGGER.warn("[CharacterSwitchCooldown] Attempted to check cooldown for null player");
            return false;
        }
        try {
            boolean canSwitch;
            UUID playerId = player.getUUID();
            long currentTime = System.currentTimeMillis();
            Long lastSwitchTime = lastSwitchTimes.get(playerId);
            if (lastSwitchTime == null) {
                return true;
            }
            long timeSinceLastSwitch = currentTime - lastSwitchTime;
            boolean bl = canSwitch = timeSinceLastSwitch >= 3000L;
            if (!canSwitch && LOGGER.isDebugEnabled()) {
                LOGGER.debug("[CharacterSwitchCooldown] Player {} is on cooldown. Time remaining: {}ms", (Object)player.getName().getString(), (Object)(3000L - timeSinceLastSwitch));
            }
            return canSwitch;
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error checking cooldown for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
            return true;
        }
    }

    public static long getRemainingCooldown(@Nullable ServerPlayer player) {
        if (player == null) {
            LOGGER.warn("[CharacterSwitchCooldown] Attempted to get remaining cooldown for null player");
            return 0L;
        }
        try {
            UUID playerId = player.getUUID();
            long currentTime = System.currentTimeMillis();
            Long lastSwitchTime = lastSwitchTimes.get(playerId);
            if (lastSwitchTime == null) {
                return 0L;
            }
            long timeSinceLastSwitch = currentTime - lastSwitchTime;
            long remainingCooldown = 3000L - timeSinceLastSwitch;
            return Math.max(0L, remainingCooldown);
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error getting remaining cooldown for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
            return 0L;
        }
    }

    public static int getRemainingCooldownSeconds(@Nullable ServerPlayer player) {
        long remainingMs = CharacterSwitchCooldownManager.getRemainingCooldown(player);
        return (int)Math.ceil((double)remainingMs / 1000.0);
    }

    public static void recordCharacterSwitch(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            UUID playerId = player.getUUID();
            long currentTime = System.currentTimeMillis();
            lastSwitchTimes.put(playerId, currentTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[CharacterSwitchCooldown] Recorded character switch for player {}. Cooldown active for {}ms", (Object)player.getName().getString(), (Object)3000L);
            }
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error recording character switch for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    public static void clearCooldown(@Nonnull ServerPlayer player) {
        Objects.requireNonNull(player, "Player cannot be null");
        try {
            UUID playerId = player.getUUID();
            Long previousTime = lastSwitchTimes.remove(playerId);
            if (LOGGER.isDebugEnabled()) {
                if (previousTime != null) {
                    LOGGER.debug("[CharacterSwitchCooldown] Cleared cooldown for player {}", (Object)player.getName().getString());
                } else {
                    LOGGER.debug("[CharacterSwitchCooldown] No cooldown to clear for player {}", (Object)player.getName().getString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error clearing cooldown for player {}: {}", new Object[]{player.getName().getString(), e.getMessage(), e});
        }
    }

    public static void cleanupPlayerData(@Nonnull UUID playerId) {
        Objects.requireNonNull(playerId, "Player ID cannot be null");
        try {
            Long previousTime = lastSwitchTimes.remove(playerId);
            if (LOGGER.isDebugEnabled()) {
                if (previousTime != null) {
                    LOGGER.debug("[CharacterSwitchCooldown] Cleaned up cooldown data for player {}", (Object)playerId);
                } else {
                    LOGGER.debug("[CharacterSwitchCooldown] No cooldown data to clean up for player {}", (Object)playerId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error cleaning up cooldown data for player {}: {}", new Object[]{playerId, e.getMessage(), e});
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(@Nonnull PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                UUID playerId = serverPlayer.getUUID();
                CharacterSwitchCooldownManager.cleanupPlayerData(playerId);
                CharacterUtils.clearPendingAutoSwitch(playerId);
            }
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error handling player logout event: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static long getCooldownDurationMs() {
        return 3000L;
    }

    public static int getCooldownDurationSeconds() {
        return 3;
    }

    public static int getActiveCooldownCount() {
        try {
            long currentTime = System.currentTimeMillis();
            return (int)lastSwitchTimes.values().stream().filter(Objects::nonNull).mapToLong(Long::longValue).filter(lastSwitchTime -> currentTime - lastSwitchTime < 3000L).count();
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error counting active cooldowns: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public static void clearAllCooldowns() {
        try {
            int clearedCount = lastSwitchTimes.size();
            lastSwitchTimes.clear();
            LOGGER.info("[CharacterSwitchCooldown] Cleared all cooldown data ({} entries)", (Object)clearedCount);
        }
        catch (Exception e) {
            LOGGER.error("[CharacterSwitchCooldown] Error clearing all cooldowns: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

