/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.util;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class NameListManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BLACKLIST_FILE = "blacklist.txt";
    private static final String OVERRIDE_FILE = "blacklist-override.txt";
    private static final Path CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("persona");
    private static volatile List<String> blacklist = Collections.emptyList();
    private static volatile List<String> overrides = Collections.emptyList();

    public static void init() {
        CONFIG_DIR.toFile().mkdirs();
        NameListManager.createDefaultListIfNotExists(BLACKLIST_FILE, NameListManager.getDefaultBlacklist());
        NameListManager.createDefaultListIfNotExists(OVERRIDE_FILE, NameListManager.getDefaultOverrides());
        NameListManager.reloadLists();
    }

    private static List<String> getDefaultBlacklist() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("admin");
        defaults.add("moderator");
        defaults.add("owner");
        defaults.add("staff");
        defaults.add("ass");
        return defaults;
    }

    private static List<String> getDefaultOverrides() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("# Format: blacklisted_word:allowed_word");
        defaults.add("# Example: ass:cassie");
        defaults.add("ass:cassie");
        defaults.add("ass:bass");
        return defaults;
    }

    private static void createDefaultListIfNotExists(String filename, List<String> defaults) {
        try {
            Path filePath = CONFIG_DIR.resolve(filename).normalize();
            if (!filePath.startsWith(CONFIG_DIR)) {
                throw new SecurityException("Path traversal attempt detected: " + filename);
            }
            File file = filePath.toFile();
            if (!file.exists()) {
                String content = String.join((CharSequence)"\n", defaults);
                FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default list file: {}", (Object)filename, (Object)e);
        }
        catch (SecurityException e) {
            LOGGER.error("Security exception creating file: {}", (Object)filename, (Object)e);
        }
    }

    public static void reloadLists() {
        try {
            List<String> newBlacklist = NameListManager.loadList(BLACKLIST_FILE);
            List<String> newOverrides = NameListManager.loadOverrides(OVERRIDE_FILE);
            blacklist = Collections.unmodifiableList(newBlacklist);
            overrides = Collections.unmodifiableList(newOverrides);
        }
        catch (IOException e) {
            LOGGER.error("Failed to reload name lists", (Throwable)e);
        }
    }

    private static List<String> loadList(String filename) throws IOException {
        Path path = CONFIG_DIR.resolve(filename);
        return Files.readAllLines(path).stream().map(String::trim).filter(s -> !s.isEmpty() && !s.startsWith("#")).collect(Collectors.toList());
    }

    private static List<String> loadOverrides(String filename) throws IOException {
        Path path = CONFIG_DIR.resolve(filename);
        return Files.readAllLines(path).stream().map(String::trim).filter(s -> !s.isEmpty() && !s.startsWith("#")).filter(s -> s.contains(":")).collect(Collectors.toList());
    }

    public static boolean isNameAllowed(String name) {
        if (name == null) {
            return false;
        }
        String lowerName = name.toLowerCase();
        Optional<String> blacklistedWord = blacklist.stream().map(String::toLowerCase).filter(lowerName::contains).findFirst();
        if (blacklistedWord.isEmpty()) {
            return true;
        }
        String foundBlacklisted = blacklistedWord.get();
        return overrides.stream().map(override -> override.split(":", 2)).filter(parts -> ((String[])parts).length == 2).filter(parts -> parts[0].toLowerCase().equals(foundBlacklisted)).anyMatch(parts -> lowerName.contains(parts[1].toLowerCase()));
    }
}

