/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import world.landfall.persona.client.event.CollectCharacterInfoEvent;
import world.landfall.persona.client.gui.CharacterCreationScreen;
import world.landfall.persona.client.gui.UIErrorHandler;
import world.landfall.persona.client.network.CharacterSyncManager;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.PersonaNetworking;

public class CharacterManagementScreen
extends Screen {
    private final Player player;
    private int guiLeft;
    private int guiTop;
    private List<CharacterEntry> characterList = new ArrayList<CharacterEntry>();
    private int scrollOffset = 0;
    private CharacterSyncManager syncManager;
    private final List<Button> switchButtons = new ArrayList<Button>();
    private final List<Button> deleteButtons = new ArrayList<Button>();
    private final List<Button> collectButtons = new ArrayList<Button>();
    private boolean hasCheckedForCharacters = false;

    public CharacterManagementScreen(Player player) {
        super((Component)Component.translatable((String)"screen.persona.character_management"));
        this.player = Objects.requireNonNull(player, "Player cannot be null");
        this.syncManager = new CharacterSyncManager(this::handleSyncComplete);
    }

    protected void init() {
        super.init();
        this.switchButtons.clear();
        this.deleteButtons.clear();
        this.collectButtons.clear();
        this.guiLeft = (this.width - 300) / 2;
        this.guiTop = (this.height - 150) / 2;
        this.syncManager.startSync();
        Button createButton = Button.builder((Component)Component.literal((String)"+"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CharacterCreationScreen(this));
            }
        }).bounds(this.guiLeft + 300 - 20, this.guiTop + 150 - 20, 20, 20).build();
        createButton.setFGColor(65280);
        this.addRenderableWidget((GuiEventListener)createButton);
        for (int i = 0; i < 5; ++i) {
            Button switchButton = this.createSwitchButton(0, 0, "");
            switchButton.setFGColor(0x66CCFF);
            switchButton.visible = false;
            this.switchButtons.add(switchButton);
            this.addRenderableWidget((GuiEventListener)switchButton);
            Button deleteButton = this.createDeleteButton(0, 0, "");
            deleteButton.setFGColor(0xFF0000);
            deleteButton.visible = false;
            this.deleteButtons.add(deleteButton);
            this.addRenderableWidget((GuiEventListener)deleteButton);
            Button collectButton = this.createCollectButton(0, 0, "");
            collectButton.setFGColor(65280);
            collectButton.visible = false;
            this.collectButtons.add(collectButton);
            this.addRenderableWidget((GuiEventListener)collectButton);
        }
    }

    private void updateCharacterList() {
        PlayerCharacterData data = (PlayerCharacterData)this.player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        ArrayList<CharacterEntry> newList = new ArrayList<CharacterEntry>();
        data.getCharacterIds().forEach((id, displayName) -> {
            CharacterProfile profile = data.getCharacter((Long)id);
            if (profile != null) {
                if (!profile.isDeceased()) {
                    newList.add(new CharacterEntry((Long)id, profile));
                } else if (profile.hasInventory()) {
                    newList.add(new CharacterEntry((Long)id, profile));
                }
            }
        });
        if (!newList.equals(this.characterList)) {
            this.characterList = newList;
            if (this.scrollOffset > Math.max(0, this.characterList.size() - 5)) {
                this.scrollOffset = Math.max(0, this.characterList.size() - 5);
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.fill(this.guiLeft - 5, this.guiTop - 5, this.guiLeft + 300 + 5, this.guiTop + 150 + 5, Integer.MIN_VALUE);
        PlayerCharacterData data = (PlayerCharacterData)this.player.getData(PlayerCharacterCapability.CHARACTER_DATA);
        String activeCharacterId = null;
        if (data != null && data.getActiveCharacterId() != null) {
            activeCharacterId = data.getActiveCharacterId().toString();
        }
        this.switchButtons.forEach(b -> {
            b.visible = false;
        });
        this.deleteButtons.forEach(b -> {
            b.visible = false;
        });
        this.collectButtons.forEach(b -> {
            b.visible = false;
        });
        int listX = this.guiLeft;
        int listY = this.guiTop;
        int visibleItems = Math.min(5, this.characterList.size() - this.scrollOffset);
        for (int i = 0; i < visibleItems; ++i) {
            CharacterEntry entry = this.characterList.get(i + this.scrollOffset);
            int y = listY + i * 25;
            boolean isActiveCharacter = activeCharacterId != null && activeCharacterId.equals(entry.id.toString());
            boolean isDeceased = entry.profile.isDeceased();
            if (isDeceased && entry.profile.hasInventory()) {
                Button collectButton = this.collectButtons.get(i);
                collectButton.setX(listX + 264);
                collectButton.setY(y + 2);
                collectButton.setMessage((Component)Component.literal((String)"\ud83d\udce6"));
                collectButton.visible = true;
                collectButton.active = true;
                continue;
            }
            Button switchButton = this.switchButtons.get(i);
            switchButton.setX((Boolean)Config.ENABLE_CHARACTER_DELETION.get() != false ? listX + 239 : listX + 264);
            switchButton.setY(y + 2);
            switchButton.setMessage((Component)Component.literal((String)"\ud83d\udd00"));
            switchButton.visible = !isActiveCharacter && !isDeceased;
            boolean bl = switchButton.active = !isActiveCharacter && !isDeceased;
            if (!((Boolean)Config.ENABLE_CHARACTER_DELETION.get()).booleanValue()) continue;
            Button deleteButton = this.deleteButtons.get(i);
            deleteButton.setX(listX + 264);
            deleteButton.setY(y + 2);
            deleteButton.setMessage((Component)Component.literal((String)"X"));
            deleteButton.visible = !isActiveCharacter && !isDeceased;
            deleteButton.active = !isActiveCharacter && !isDeceased;
        }
        super.render(graphics, mouseX, mouseY, partialTick);
        int scrollableAreaHeight = 125;
        if (this.characterList.size() > 5) {
            int scrollBarX = this.guiLeft + 300 - 8 - 3;
            graphics.fill(scrollBarX, this.guiTop, scrollBarX + 8, this.guiTop + scrollableAreaHeight, -2144128205);
            float thumbHeightRatio = 5.0f / (float)this.characterList.size();
            int scrollBarThumbHeight = (int)((float)scrollableAreaHeight * thumbHeightRatio);
            scrollBarThumbHeight = Math.max(15, scrollBarThumbHeight);
            int maxScroll = this.characterList.size() - 5;
            float scrollPercentage = maxScroll == 0 ? 0.0f : (float)this.scrollOffset / (float)maxScroll;
            int scrollBarThumbY = this.guiTop + (int)(scrollPercentage * (float)(scrollableAreaHeight - scrollBarThumbHeight));
            graphics.fill(scrollBarX + 1, scrollBarThumbY + 1, scrollBarX + 8 - 1, scrollBarThumbY + scrollBarThumbHeight - 1, -4473925);
        }
        graphics.drawCenteredString(this.font, this.title, this.width / 2, this.guiTop - 20, 0xFFFFFF);
        for (int i = 0; i < visibleItems; ++i) {
            MutableComponent characterDisplayName;
            int nameColor;
            CharacterEntry entry = this.characterList.get(i + this.scrollOffset);
            int y = listY + i * 25;
            int n = activeCharacterId != null && activeCharacterId.equals(entry.id.toString()) ? 65280 : (nameColor = entry.profile.isDeceased() ? 0x808080 : 0xFFFFFF);
            if (this.font == null) continue;
            if (entry.profile.isDeceased()) {
                MutableComponent skullIcon = Component.literal((String)"\u2620 ").withStyle(ChatFormatting.RED);
                characterDisplayName = skullIcon.append((Component)Component.literal((String)entry.profile.getDisplayName()));
                if (entry.profile.hasInventory()) {
                    characterDisplayName = characterDisplayName.append((Component)Component.literal((String)" \ud83d\udce6").withStyle(ChatFormatting.YELLOW));
                }
            } else {
                characterDisplayName = Component.literal((String)entry.profile.getDisplayName());
            }
            int currentX = listX;
            graphics.drawString(this.font, (Component)characterDisplayName, currentX, y + 6, nameColor);
            currentX += this.font.width((FormattedText)characterDisplayName) + 5;
            CollectCharacterInfoEvent event = new CollectCharacterInfoEvent(entry.profile);
            NeoForge.EVENT_BUS.post((Event)event);
            for (Component infoComponent : event.getInfoComponents()) {
                graphics.drawString(this.font, infoComponent, currentX, y + 6, nameColor);
                currentX += this.font.width((FormattedText)infoComponent) + 3;
            }
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    private Button createSwitchButton(int x, int y, String characterName) {
        return Button.builder((Component)Component.literal((String)"\ud83d\udd00"), button -> {
            int index = this.switchButtons.indexOf(button);
            if (index >= 0 && index + this.scrollOffset < this.characterList.size()) {
                CharacterEntry entry = this.characterList.get(index + this.scrollOffset);
                if (entry.profile.isDeceased()) {
                    return;
                }
                PersonaNetworking.sendActionToServer(PersonaNetworking.Action.SWITCH, entry.id.toString(), true);
            }
        }).bounds(x, y, 25, 20).build();
    }

    private Button createDeleteButton(int x, int y, String characterId) {
        return Button.builder((Component)Component.literal((String)"X"), button -> {
            int index;
            if (this.minecraft != null && (index = this.deleteButtons.indexOf(button)) >= 0 && index + this.scrollOffset < this.characterList.size()) {
                CharacterEntry entry = this.characterList.get(index + this.scrollOffset);
                this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                    if (confirmed) {
                        PersonaNetworking.sendActionToServer(PersonaNetworking.Action.DELETE, entry.id.toString(), true);
                    }
                    this.minecraft.setScreen((Screen)this);
                }, (Component)Component.translatable((String)"gui.persona.confirm_delete.title"), (Component)Component.translatable((String)"gui.persona.confirm_delete.message", (Object[])new Object[]{entry.profile.getDisplayName()})));
            }
        }).bounds(x, y, 25, 20).build();
    }

    private Button createCollectButton(int x, int y, String characterId) {
        return Button.builder((Component)Component.literal((String)"\ud83d\udce6"), button -> {
            int index = this.collectButtons.indexOf(button);
            if (index >= 0 && index + this.scrollOffset < this.characterList.size()) {
                CharacterEntry entry = this.characterList.get(index + this.scrollOffset);
                if (entry.profile.isDeceased() && entry.profile.hasInventory()) {
                    PersonaNetworking.sendActionToServer(PersonaNetworking.Action.COLLECT_ITEMS, entry.id.toString(), true);
                }
            }
        }).bounds(x, y, 25, 20).build();
    }

    private void requestSync() {
        this.syncManager.startSync();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            int maxScroll = Math.max(0, this.characterList.size() - 5);
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.scrollOffset - scrollY));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void tick() {
        super.tick();
        this.updateCharacterList();
        this.syncManager.tick();
    }

    private void handleSyncComplete(boolean success) {
        if (!success) {
            UIErrorHandler.showError("gui.persona.error.sync_failed");
        }
        this.updateCharacterList();
        if (!this.hasCheckedForCharacters) {
            this.hasCheckedForCharacters = true;
            PlayerCharacterData data = (PlayerCharacterData)this.player.getData(PlayerCharacterCapability.CHARACTER_DATA);
            if (data != null && data.getCharacterCount() == 0 && this.minecraft != null) {
                this.minecraft.setScreen((Screen)new CharacterCreationScreen(this));
                return;
            }
        }
    }

    private static final class Layout {
        static final int BUTTON_HEIGHT = 20;
        static final int LIST_ITEM_HEIGHT = 25;
        static final int MAX_VISIBLE_ITEMS = 5;
        static final int CREATE_BUTTON_SIZE = 20;
        static final int LIST_WIDTH = 300;
        static final int LIST_HEIGHT = 150;
        static final int BUTTON_Y_OFFSET = 2;
        static final int SWITCH_BUTTON_X_WITH_DELETE = 239;
        static final int SWITCH_BUTTON_X_WITHOUT_DELETE = 264;
        static final int DELETE_BUTTON_X = 264;
        static final int SCROLLBAR_WIDTH = 8;
        static final int SCROLLBAR_MARGIN = 3;
        static final int MIN_THUMB_HEIGHT = 15;
        static final int PANEL_PADDING = 5;
        static final int TITLE_Y_OFFSET = 20;
        static final int NAME_Y_OFFSET = 6;

        private Layout() {
        }
    }

    private static final class Colors {
        static final int PANEL_BACKGROUND = Integer.MIN_VALUE;
        static final int SCROLLBAR_TRACK = -2144128205;
        static final int SCROLLBAR_THUMB = -4473925;
        static final int TEXT_COLOR = 0xFFFFFF;
        static final int ACTIVE_CHARACTER = 65280;
        static final int DECEASED_CHARACTER = 0x808080;
        static final int SWITCH_BUTTON = 0x66CCFF;
        static final int DELETE_BUTTON = 0xFF0000;
        static final int CREATE_BUTTON = 65280;

        private Colors() {
        }
    }

    private record CharacterEntry(Long id, CharacterProfile profile) {
    }
}

