/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.client.gui;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class NotificationToast
implements Toast {
    private final Component title;
    private final Component message;
    private final String icon;
    private final Type type;
    private final long startTime;
    private final int displayTime;
    private int cachedWidth = -1;
    private static final int PADDING = 5;
    private static final int MAX_WIDTH = 240;
    private static final int MIN_WIDTH = 160;
    private static final int HEIGHT = 32;

    private NotificationToast(Component title, Component message, Type type, int displayTime) {
        this.title = title.copy().withStyle(type.titleStyle);
        this.message = message.copy().withStyle(type.messageStyle);
        this.icon = type.icon;
        this.type = type;
        this.startTime = System.currentTimeMillis();
        this.displayTime = displayTime;
    }

    public static NotificationToast error(Component message) {
        return new NotificationToast((Component)Component.translatable((String)"gui.persona.dialog.error"), message, Type.ERROR, 5000);
    }

    public static NotificationToast info(Component message) {
        return new NotificationToast((Component)Component.translatable((String)"gui.persona.dialog.info"), message, Type.INFO, 3000);
    }

    public static NotificationToast success(Component message) {
        return new NotificationToast((Component)Component.translatable((String)"gui.persona.dialog.success"), message, Type.SUCCESS, 3000);
    }

    public Toast.Visibility render(@Nonnull GuiGraphics graphics, @Nonnull ToastComponent toastComponent, long timestamp) {
        int toastWidth;
        if (graphics == null || toastComponent == null) {
            return Toast.Visibility.HIDE;
        }
        long elapsed = System.currentTimeMillis() - this.startTime;
        if (elapsed >= (long)this.displayTime) {
            return Toast.Visibility.HIDE;
        }
        Font font = toastComponent.getMinecraft().font;
        int titleWidth = font.width((FormattedText)Component.literal((String)(this.icon + " " + this.title.getString())).withStyle(this.type.titleStyle));
        int messageWidth = font.width((FormattedText)this.message);
        this.cachedWidth = toastWidth = Math.max(160, Math.min(240, Math.max(titleWidth, messageWidth) + 10));
        int messageLines = font.split((FormattedText)this.message, toastWidth - 10).size();
        Objects.requireNonNull(font);
        int toastHeight = 32 + (messageLines - 1) * 9;
        graphics.fill(0, 0, toastWidth, toastHeight, -536870912);
        graphics.fill(0, 0, 2, toastHeight, this.type.color);
        String titleText = this.icon + " " + this.title.getString();
        graphics.drawString(font, (Component)Component.literal((String)titleText).withStyle(this.type.titleStyle), 5, 5, 0xFFFFFF);
        graphics.drawWordWrap(font, (FormattedText)this.message, 5, 17, toastWidth - 10, 0xFFFFFF);
        return Toast.Visibility.SHOW;
    }

    public int width() {
        return this.cachedWidth > 0 ? this.cachedWidth : 160;
    }

    public static enum Type {
        ERROR("\u26a0", 0xFF5555, Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(0xFF5555), Style.EMPTY.withColor(0xFFFFFF)),
        INFO("\u2139", 0x55FFFF, Style.EMPTY.withColor(0x55FFFF), Style.EMPTY.withColor(0xFFFFFF)),
        SUCCESS("\u2713", 0x55FF55, Style.EMPTY.withColor(0x55FF55), Style.EMPTY.withColor(0xFFFFFF));

        public final String icon;
        public final int color;
        public final Style titleStyle;
        public final Style messageStyle;

        private Type(String icon, int color, Style titleStyle, Style messageStyle) {
            this.icon = icon;
            this.color = color;
            this.titleStyle = titleStyle;
            this.messageStyle = messageStyle;
        }
    }
}

