/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.client.network;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.registry.PersonaNetworking;

public class CharacterSyncManager {
    private static final int MAX_SYNC_ATTEMPTS = 20;
    private static final int SYNC_REQUEST_INTERVAL = 5;
    private int syncAttempts = 0;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final Consumer<Boolean> onSyncComplete;

    public CharacterSyncManager(Consumer<Boolean> onSyncComplete) {
        this.onSyncComplete = onSyncComplete;
    }

    public boolean startSync() {
        if (this.syncAttempts > 0) {
            return false;
        }
        this.syncAttempts = 1;
        PersonaNetworking.requestCharacterSync();
        return true;
    }

    public void tick() {
        PlayerCharacterData data;
        if (this.syncAttempts == 0) {
            return;
        }
        if (this.minecraft.player != null && (data = (PlayerCharacterData)this.minecraft.player.getData(PlayerCharacterCapability.CHARACTER_DATA)) != null) {
            this.syncAttempts = 0;
            this.onSyncComplete.accept(true);
            return;
        }
        if (this.syncAttempts >= 20) {
            this.syncAttempts = 0;
            this.onSyncComplete.accept(false);
            return;
        }
        ++this.syncAttempts;
        if (this.syncAttempts % 5 == 0) {
            PersonaNetworking.requestCharacterSync();
        }
    }

    public boolean isSyncing() {
        return this.syncAttempts > 0;
    }
}

