/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.client.network;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import world.landfall.persona.client.gui.CharacterCreationScreen;
import world.landfall.persona.client.gui.NotificationToast;
import world.landfall.persona.features.figura.event.ClientPersonaSwitchedEvent;
import world.landfall.persona.registry.PersonaNetworking;

@OnlyIn(value=Dist.CLIENT)
public final class ClientNetworkHandler {
    private ClientNetworkHandler() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void handleCharacterCreationResponse(boolean success, @Nonnull String messageKey, @Nonnull String[] messageArgs) {
        Objects.requireNonNull(messageKey, "Message key cannot be null");
        Objects.requireNonNull(messageArgs, "Message arguments cannot be null");
        try {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                return;
            }
            Screen currentScreen = minecraft.screen;
            if (currentScreen instanceof CharacterCreationScreen) {
                CharacterCreationScreen creationScreen = (CharacterCreationScreen)currentScreen;
                if (success) {
                    MutableComponent message = Component.translatable((String)messageKey, (Object[])messageArgs);
                    minecraft.getToasts().addToast((Toast)NotificationToast.success((Component)message));
                    PersonaNetworking.requestCharacterSync();
                    creationScreen.handleSuccessfulCreation();
                } else {
                    creationScreen.handleFailedCreation(messageKey, messageArgs);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[ClientNetworkHandler] Error handling character creation response: " + e.getMessage());
        }
    }

    public static void handleCharacterDeletionResponse(boolean success, @Nonnull String messageKey, @Nonnull String[] messageArgs) {
        Objects.requireNonNull(messageKey, "Message key cannot be null");
        Objects.requireNonNull(messageArgs, "Message arguments cannot be null");
        try {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                return;
            }
            if (success) {
                MutableComponent message = Component.translatable((String)messageKey, (Object[])messageArgs);
                minecraft.getToasts().addToast((Toast)NotificationToast.success((Component)message));
                PersonaNetworking.requestCharacterSync();
            } else {
                MutableComponent message = Component.translatable((String)messageKey, (Object[])messageArgs);
                minecraft.getToasts().addToast((Toast)NotificationToast.error((Component)message));
            }
        }
        catch (Exception e) {
            System.err.println("[ClientNetworkHandler] Error handling character deletion response: " + e.getMessage());
        }
    }

    public static void handleCharacterSwitchResponse(boolean success, @Nonnull String messageKey, @Nonnull String[] messageArgs) {
        Objects.requireNonNull(messageKey, "Message key cannot be null");
        Objects.requireNonNull(messageArgs, "Message arguments cannot be null");
        try {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                return;
            }
            if (success) {
                ClientNetworkHandler.handleSuccessfulSwitch(minecraft, messageKey, messageArgs);
            } else {
                ClientNetworkHandler.handleFailedSwitch(minecraft, messageKey, messageArgs);
            }
        }
        catch (Exception e) {
            System.err.println("[ClientNetworkHandler] Error handling character switch response: " + e.getMessage());
        }
    }

    private static void handleSuccessfulSwitch(@Nonnull Minecraft minecraft, @Nonnull String messageKey, @Nonnull String[] messageArgs) {
        try {
            if (messageArgs.length > 0) {
                String characterName = messageArgs[0];
                if (characterName != null && !characterName.trim().isEmpty()) {
                    MutableComponent message = Component.translatable((String)messageKey, (Object[])messageArgs);
                    minecraft.getToasts().addToast((Toast)NotificationToast.success((Component)message));
                    NeoForge.EVENT_BUS.post((Event)new ClientPersonaSwitchedEvent(characterName));
                } else {
                    MutableComponent message = Component.translatable((String)"command.persona.success.switch_generic");
                    minecraft.getToasts().addToast((Toast)NotificationToast.success((Component)message));
                }
            } else {
                MutableComponent message = Component.translatable((String)"command.persona.success.switch_generic");
                minecraft.getToasts().addToast((Toast)NotificationToast.success((Component)message));
            }
        }
        catch (Exception e) {
            System.err.println("[ClientNetworkHandler] Error handling successful switch: " + e.getMessage());
        }
    }

    private static void handleFailedSwitch(@Nonnull Minecraft minecraft, @Nonnull String messageKey, @Nonnull String[] messageArgs) {
        try {
            MutableComponent message = Component.translatable((String)messageKey, (Object[])messageArgs);
            minecraft.getToasts().addToast((Toast)NotificationToast.error((Component)message));
        }
        catch (Exception e) {
            System.err.println("[ClientNetworkHandler] Error handling failed switch: " + e.getMessage());
            try {
                MutableComponent fallbackMessage = Component.translatable((String)"gui.persona.error.generic_switch_fail");
                minecraft.getToasts().addToast((Toast)NotificationToast.error((Component)fallbackMessage));
            }
            catch (Exception fallbackException) {
                System.err.println("[ClientNetworkHandler] Fallback error handling also failed: " + fallbackException.getMessage());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleItemsCollectionResponse(boolean success, @Nonnull String messageKey, @Nonnull String[] messageArgs) {
        Objects.requireNonNull(messageKey, "Message key cannot be null");
        Objects.requireNonNull(messageArgs, "Message args cannot be null");
        try {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                System.err.println("[ClientNetworkHandler] Minecraft instance is null, cannot handle items collection response");
                return;
            }
            MutableComponent message = Component.translatable((String)messageKey, (Object[])messageArgs);
            if (success) {
                minecraft.getToasts().addToast((Toast)NotificationToast.success((Component)message));
                PersonaNetworking.requestCharacterSync();
            } else {
                minecraft.getToasts().addToast((Toast)NotificationToast.error((Component)message));
            }
        }
        catch (Exception e) {
            System.err.println("[ClientNetworkHandler] Error handling items collection response: " + e.getMessage());
        }
    }
}

