/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.data;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import world.landfall.persona.Persona;
import world.landfall.persona.config.Config;
import world.landfall.persona.features.landfalladdon.LandfallAddonData;
import world.landfall.persona.util.NameListManager;

public class CharacterProfile {
    private static Pattern NAME_PATTERN = null;
    private static final ResourceLocation IS_DECEASED_KEY = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"is_deceased");
    private final long id;
    private String displayName;
    private final Map<ResourceLocation, CompoundTag> modData;
    private long lastSyncedAt;

    public CharacterProfile(long id, String displayName) throws IllegalArgumentException {
        this.id = id;
        this.setDisplayName(displayName, true);
        this.modData = new HashMap<ResourceLocation, CompoundTag>();
        this.lastSyncedAt = 0L;
        LandfallAddonData.initializeData(this);
        CompoundTag deceasedTag = new CompoundTag();
        deceasedTag.putBoolean("value", false);
        this.modData.put(IS_DECEASED_KEY, deceasedTag);
    }

    public CharacterProfile(long id, String displayName, boolean skipValidation) {
        this.id = id;
        this.setDisplayName(displayName, skipValidation);
        this.modData = new HashMap<ResourceLocation, CompoundTag>();
        this.lastSyncedAt = 0L;
        LandfallAddonData.initializeData(this);
        CompoundTag deceasedTag = new CompoundTag();
        deceasedTag.putBoolean("value", false);
        this.modData.put(IS_DECEASED_KEY, deceasedTag);
    }

    public long getId() {
        return this.id;
    }

    public long getLastSyncedAt() {
        return this.lastSyncedAt;
    }

    public void setLastSyncedAt(long timestamp) {
        this.lastSyncedAt = timestamp;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) throws IllegalArgumentException {
        this.setDisplayName(displayName, true);
    }

    public void setDisplayNameWithoutValidation(String displayName) {
        this.setDisplayName(displayName, false);
    }

    private void setDisplayName(String displayName, boolean validate) throws IllegalArgumentException {
        if (validate && !CharacterProfile.isValidName(displayName)) {
            Persona.LOGGER.error("[CharacterProfile] Name '{}' failed validation against pattern: {}", (Object)displayName, Config.NAME_VALIDATION_REGEX.get());
            throw new IllegalArgumentException(String.format("Invalid character name '%s'. Must match pattern: %s", displayName, Config.NAME_VALIDATION_REGEX.get()));
        }
        this.displayName = displayName;
    }

    public static boolean isValidName(String name) {
        if (NAME_PATTERN == null) {
            CharacterProfile.updateNamePattern();
        }
        if (name == null || !NAME_PATTERN.matcher(name).matches()) {
            return false;
        }
        return NameListManager.isNameAllowed(name);
    }

    public static void updateNamePattern() {
        NAME_PATTERN = Pattern.compile((String)Config.NAME_VALIDATION_REGEX.get());
    }

    public Map<ResourceLocation, CompoundTag> getModData() {
        return this.modData;
    }

    public CompoundTag getModData(ResourceLocation modId) {
        return this.modData.getOrDefault(modId, new CompoundTag());
    }

    public void setModData(ResourceLocation modId, CompoundTag data) {
        this.modData.put(modId, data);
    }

    public void removeModData(ResourceLocation modId) {
        this.modData.remove(modId);
    }

    public boolean isDeceased() {
        CompoundTag deceasedTag = this.modData.get(IS_DECEASED_KEY);
        if (deceasedTag != null && deceasedTag.contains("value")) {
            return deceasedTag.getBoolean("value");
        }
        return false;
    }

    public void setDeceased(boolean deceased) {
        CompoundTag deceasedTag = new CompoundTag();
        deceasedTag.putBoolean("value", deceased);
        this.modData.put(IS_DECEASED_KEY, deceasedTag);
    }

    public boolean hasInventory() {
        ResourceLocation inventoryKey = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"inventory");
        CompoundTag inventoryTag = this.modData.get(inventoryKey);
        if (inventoryTag != null && inventoryTag.contains("Items")) {
            ListTag itemsList = inventoryTag.getList("Items", 10);
            return !itemsList.isEmpty();
        }
        return false;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putLong("id", this.id);
        tag.putString("name", this.displayName);
        tag.putLong("lastSyncedAt", this.lastSyncedAt);
        CompoundTag dataTag = new CompoundTag();
        this.modData.forEach((modId, modData) -> dataTag.put(modId.toString(), (Tag)modData));
        tag.put("characterData", (Tag)dataTag);
        return tag;
    }

    public static CharacterProfile deserialize(CompoundTag tag) {
        long id = tag.getLong("id");
        String name = tag.getString("name");
        CharacterProfile profile = new CharacterProfile(id, name, false);
        if (tag.contains("lastSyncedAt")) {
            profile.lastSyncedAt = tag.getLong("lastSyncedAt");
        }
        CompoundTag dataTag = tag.getCompound("characterData");
        for (String key : dataTag.getAllKeys()) {
            ResourceLocation rl = ResourceLocation.tryParse((String)key);
            if (rl == null) continue;
            profile.setModData(rl, dataTag.getCompound(key));
        }
        return profile;
    }

    static {
        CharacterProfile.updateNamePattern();
    }
}

