/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.fml.loading.FMLEnvironment;
import world.landfall.persona.Persona;
import world.landfall.persona.data.CharacterFileStorage;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.statecraft.StatecraftAPI;
import world.landfall.persona.statecraft.StatecraftCharacter;

public class PlayerCharacterData {
    private Long activeCharacterId;
    private final Map<Long, String> characterIds = new ConcurrentHashMap<Long, String>();
    private final Map<Long, CharacterProfile> clientCharacterCache = new ConcurrentHashMap<Long, CharacterProfile>();

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        if (this.activeCharacterId != null) {
            tag.putLong("activeCharacter", this.activeCharacterId.longValue());
        }
        ListTag charactersList = new ListTag();
        this.characterIds.forEach((id, displayName) -> {
            CompoundTag characterEntry = new CompoundTag();
            characterEntry.putLong("id", id.longValue());
            characterEntry.putString("displayName", displayName);
            charactersList.add((Object)characterEntry);
        });
        tag.put("characterIds", (Tag)charactersList);
        return tag;
    }

    public static PlayerCharacterData deserialize(CompoundTag tag) {
        PlayerCharacterData data = new PlayerCharacterData();
        if (tag.contains("activeCharacter", 4)) {
            data.activeCharacterId = tag.getLong("activeCharacter");
        }
        if (tag.contains("characterIds", 9)) {
            ListTag charactersList = tag.getList("characterIds", 10);
            for (Tag t : charactersList) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag entryTag = (CompoundTag)t;
                long id = entryTag.getLong("id");
                String displayName = entryTag.getString("displayName");
                data.characterIds.put(id, displayName);
            }
        }
        return data;
    }

    public Long getActiveCharacterId() {
        return this.activeCharacterId;
    }

    public void setActiveCharacterId(Long id) {
        this.activeCharacterId = id;
    }

    public Map<Long, String> getCharacterIds() {
        return new ConcurrentHashMap<Long, String>(this.characterIds);
    }

    public Map<Long, CharacterProfile> getCharacters() {
        HashMap<Long, CharacterProfile> characters = new HashMap<Long, CharacterProfile>();
        for (Long characterId : this.characterIds.keySet()) {
            CharacterProfile character = this.getCharacter(characterId);
            if (character == null) continue;
            characters.put(characterId, character);
        }
        return characters;
    }

    public CharacterProfile getCharacter(Long id) {
        StatecraftCharacter statecraftChar;
        if (!this.characterIds.containsKey(id)) {
            this.clientCharacterCache.remove(id);
            return null;
        }
        CharacterProfile cached = this.clientCharacterCache.get(id);
        if (cached != null) {
            return cached;
        }
        CharacterProfile character = CharacterFileStorage.loadCharacter(id);
        if (character != null) {
            StatecraftCharacter statecraftChar2;
            if (!FMLEnvironment.dist.isClient() && (statecraftChar2 = StatecraftAPI.getInstance().getCharacterById(id)) != null) {
                character.setDisplayNameWithoutValidation(statecraftChar2.getDisplayName());
                character.setDeceased(statecraftChar2.isDeceased());
            }
            this.clientCharacterCache.put(id, character);
            return character;
        }
        if (!FMLEnvironment.dist.isClient() && (statecraftChar = StatecraftAPI.getInstance().getCharacterById(id)) != null) {
            character = new CharacterProfile(id, statecraftChar.getDisplayName(), false);
            character.setDeceased(statecraftChar.isDeceased());
            this.clientCharacterCache.put(id, character);
            return character;
        }
        String displayName = this.characterIds.get(id);
        if (displayName != null) {
            character = new CharacterProfile(id, displayName, false);
            this.clientCharacterCache.put(id, character);
            return character;
        }
        return null;
    }

    public void addCharacter(Long id, String displayName) {
        this.characterIds.put(id, displayName);
        this.clientCharacterCache.remove(id);
    }

    public void removeCharacter(Long id) {
        this.characterIds.remove(id);
        this.clientCharacterCache.remove(id);
        if (this.activeCharacterId != null && this.activeCharacterId.equals(id)) {
            this.activeCharacterId = null;
        }
    }

    public void updateCharacterDisplayName(Long id, String newDisplayName) {
        if (this.characterIds.containsKey(id)) {
            this.characterIds.put(id, newDisplayName);
            CharacterProfile cached = this.clientCharacterCache.get(id);
            if (cached != null) {
                cached.setDisplayName(newDisplayName);
            }
        }
    }

    public boolean hasCharacter(Long id) {
        return this.characterIds.containsKey(id);
    }

    public synchronized int getCharacterCount() {
        return this.characterIds.size();
    }

    public synchronized int getNonDeceasedCharacterCount() {
        int count = 0;
        for (Long characterId : this.characterIds.keySet()) {
            CharacterProfile character = this.getCharacter(characterId);
            if (character == null || character.isDeceased()) continue;
            ++count;
        }
        return count;
    }

    public synchronized void copyFrom(PlayerCharacterData other) {
        this.characterIds.clear();
        this.clientCharacterCache.clear();
        this.characterIds.putAll(other.characterIds);
        this.activeCharacterId = other.activeCharacterId;
    }

    public void clearCache() {
        this.clientCharacterCache.clear();
    }

    public void cacheCharacter(CharacterProfile character) {
        if (character != null) {
            this.clientCharacterCache.put(character.getId(), character);
            this.characterIds.put(character.getId(), character.getDisplayName());
        }
    }

    public void clearClientCache() {
        this.clientCharacterCache.clear();
    }

    public void loadCharacterIdsFromStorage(UUID playerId) {
        this.characterIds.clear();
        this.clientCharacterCache.clear();
        if (FMLEnvironment.dist.isClient()) {
            Persona.LOGGER.warn("[PlayerCharacterData] loadCharacterIdsFromStorage called on client side for player {}. This should only be called on the server.", (Object)playerId);
            return;
        }
        List<StatecraftCharacter> statecraftCharacters = StatecraftAPI.getInstance().getCharactersByPlayerUuid(playerId);
        for (StatecraftCharacter sc : statecraftCharacters) {
            long characterId = sc.getCharacterId();
            this.characterIds.put(characterId, sc.getDisplayName());
            CharacterProfile profile = CharacterFileStorage.loadCharacter(characterId);
            if (profile == null) {
                profile = new CharacterProfile(characterId, sc.getDisplayName(), false);
            } else {
                profile.setDisplayNameWithoutValidation(sc.getDisplayName());
            }
            profile.setDeceased(sc.isDeceased());
            this.clientCharacterCache.put(characterId, profile);
        }
        if (!this.characterIds.isEmpty() && this.activeCharacterId == null) {
            this.activeCharacterId = this.characterIds.keySet().iterator().next();
        }
        Persona.LOGGER.info("[PlayerCharacterData] Loaded {} characters from Statecraft for player {}", (Object)this.characterIds.size(), (Object)playerId);
    }

    public synchronized int reconcileCharacterCount(UUID playerId) {
        return 0;
    }
}

