/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.features.landfalladdon.shells.Shell;
import world.landfall.persona.features.landfalladdon.shells.ShellManager;

public class LandfallAddonData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation DATA_KEY = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"landfall_addon_data");
    private static final ResourceLocation ORIGIN_KEY = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"origin_input");
    public static final String SPAWN_X_KEY = "spawn_x";
    public static final String SPAWN_Y_KEY = "spawn_y";
    public static final String SPAWN_Z_KEY = "spawn_z";
    public static final String SPAWN_DIMENSION_KEY = "spawn_dimension";
    public static final String SPAWN_FORCED_KEY = "spawn_forced";
    private static final String CURRENT_SHELL_KEY = "currentShell";
    private static final String DEATH_COUNT_KEY = "deathCount";
    private static final String SELECTED_ORIGIN_KEY = "selectedOrigin";
    private static final String UNKNOWN_ORIGIN = "UNKNOWN_ORIGIN";
    private static final int MAX_DEATH_COUNT = 10000;
    private static final double MAX_COORDINATE = 3.0E7;
    private static final double MIN_COORDINATE = -3.0E7;
    private static final ReadWriteLock DATA_LOCK = new ReentrantReadWriteLock();

    public static void initializeData(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.writeLock().lock();
        try {
            CompoundTag existingData = profile.getModData(DATA_KEY);
            if (existingData != null && !existingData.isEmpty()) {
                LOGGER.debug("LandfallAddon data already exists for character {}, skipping initialization", (Object)profile.getId());
                return;
            }
            CompoundTag landfallData = new CompoundTag();
            landfallData.putString(CURRENT_SHELL_KEY, Shell.NEUTRAL.name());
            landfallData.putInt(DEATH_COUNT_KEY, 0);
            profile.setModData(DATA_KEY, landfallData);
            LOGGER.debug("Initialized LandfallAddon data for character {}", (Object)profile.getId());
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize LandfallAddon data for character {}", (Object)profile.getId(), (Object)e);
            throw new IllegalStateException("Failed to initialize LandfallAddon data", e);
        }
        finally {
            DATA_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Shell getCurrentShell(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.readLock().lock();
        try {
            CompoundTag landfallData = LandfallAddonData.getOrCreateData(profile);
            if (!landfallData.contains(CURRENT_SHELL_KEY, 8)) {
                LOGGER.debug("No shell data found for character {}, defaulting to NEUTRAL", (Object)profile.getId());
                Shell shell = Shell.NEUTRAL;
                return shell;
            }
            String shellName = landfallData.getString(CURRENT_SHELL_KEY);
            if (shellName == null || shellName.isBlank()) {
                LOGGER.warn("Empty shell name for character {}, defaulting to NEUTRAL", (Object)profile.getId());
                Shell shell = Shell.NEUTRAL;
                return shell;
            }
            Shell shell = Shell.valueOf(shellName.trim().toUpperCase());
            if (!ShellManager.isValidShell(shell)) {
                LOGGER.warn("Invalid shell {} for character {}, defaulting to NEUTRAL", (Object)shellName, (Object)profile.getId());
                Shell shell2 = Shell.NEUTRAL;
                return shell2;
            }
            Shell shell3 = shell;
            return shell3;
        }
        catch (Exception e) {
            LOGGER.error("Error getting current shell for character {}, defaulting to NEUTRAL", (Object)profile.getId(), (Object)e);
            Shell shell = Shell.NEUTRAL;
            return shell;
        }
        finally {
            DATA_LOCK.readLock().unlock();
        }
    }

    public static void setCurrentShell(CharacterProfile profile, Shell shell) {
        LandfallAddonData.validateProfile(profile);
        Objects.requireNonNull(shell, "Shell cannot be null");
        if (!ShellManager.isValidShell(shell)) {
            throw new IllegalArgumentException("Invalid shell: " + String.valueOf((Object)shell));
        }
        DATA_LOCK.writeLock().lock();
        try {
            CompoundTag landfallData = LandfallAddonData.getOrCreateData(profile);
            String previousShell = landfallData.getString(CURRENT_SHELL_KEY);
            landfallData.putString(CURRENT_SHELL_KEY, shell.name());
            profile.setModData(DATA_KEY, landfallData);
            LOGGER.debug("Updated shell for character {} from {} to {}", new Object[]{profile.getId(), previousShell, shell.name()});
        }
        catch (Exception e) {
            LOGGER.error("Failed to set shell {} for character {}", new Object[]{shell, profile.getId(), e});
            throw new IllegalStateException("Failed to set shell", e);
        }
        finally {
            DATA_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeathCount(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.readLock().lock();
        try {
            CompoundTag landfallData = LandfallAddonData.getOrCreateData(profile);
            if (!landfallData.contains(DEATH_COUNT_KEY, 3)) {
                int n = 0;
                return n;
            }
            int deathCount = landfallData.getInt(DEATH_COUNT_KEY);
            if (deathCount < 0) {
                LOGGER.warn("Negative death count {} for character {}, returning 0", (Object)deathCount, (Object)profile.getId());
                int n = 0;
                return n;
            }
            if (deathCount > 10000) {
                LOGGER.warn("Death count {} exceeds maximum {} for character {}, clamping", new Object[]{deathCount, 10000, profile.getId()});
                int n = 10000;
                return n;
            }
            int n = deathCount;
            return n;
        }
        catch (Exception e) {
            LOGGER.error("Error getting death count for character {}, returning 0", (Object)profile.getId(), (Object)e);
            int n = 0;
            return n;
        }
        finally {
            DATA_LOCK.readLock().unlock();
        }
    }

    public static void incrementDeathCount(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.writeLock().lock();
        try {
            int currentCount = LandfallAddonData.getDeathCount(profile);
            if (currentCount >= 10000) {
                LOGGER.warn("Death count for character {} is already at maximum {}, not incrementing", (Object)profile.getId(), (Object)10000);
                return;
            }
            int newCount = currentCount + 1;
            CompoundTag landfallData = LandfallAddonData.getOrCreateData(profile);
            landfallData.putInt(DEATH_COUNT_KEY, newCount);
            profile.setModData(DATA_KEY, landfallData);
            LOGGER.debug("Incremented death count for character {} from {} to {}", new Object[]{profile.getId(), currentCount, newCount});
        }
        catch (Exception e) {
            LOGGER.error("Failed to increment death count for character {}", (Object)profile.getId(), (Object)e);
            throw new IllegalStateException("Failed to increment death count", e);
        }
        finally {
            DATA_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOrigin(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.readLock().lock();
        try {
            CompoundTag originData = profile.getModData(ORIGIN_KEY);
            if (originData == null || !originData.contains(SELECTED_ORIGIN_KEY, 8)) {
                String string = UNKNOWN_ORIGIN;
                return string;
            }
            String origin = originData.getString(SELECTED_ORIGIN_KEY);
            if (origin == null || origin.isBlank()) {
                String string = UNKNOWN_ORIGIN;
                return string;
            }
            String string = origin.trim().toUpperCase();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error getting origin for character {}, returning UNKNOWN_ORIGIN", (Object)profile.getId(), (Object)e);
            String string = UNKNOWN_ORIGIN;
            return string;
        }
        finally {
            DATA_LOCK.readLock().unlock();
        }
    }

    public static void setSpawnPoint(CharacterProfile profile, double x, double y, double z, ResourceLocation dimension, boolean forced) {
        LandfallAddonData.validateProfile(profile);
        Objects.requireNonNull(dimension, "Dimension cannot be null");
        LandfallAddonData.validateCoordinate(x, "X");
        LandfallAddonData.validateCoordinate(y, "Y");
        LandfallAddonData.validateCoordinate(z, "Z");
        DATA_LOCK.writeLock().lock();
        try {
            CompoundTag data = LandfallAddonData.getOrCreateData(profile);
            data.putDouble(SPAWN_X_KEY, x);
            data.putDouble(SPAWN_Y_KEY, y);
            data.putDouble(SPAWN_Z_KEY, z);
            data.putString(SPAWN_DIMENSION_KEY, dimension.toString());
            data.putBoolean(SPAWN_FORCED_KEY, forced);
            profile.setModData(DATA_KEY, data);
            LOGGER.debug("Set spawn point for character {} to ({}, {}, {}) in {} (forced: {})", new Object[]{profile.getId(), x, y, z, dimension, forced});
        }
        catch (Exception e) {
            LOGGER.error("Failed to set spawn point for character {}", (Object)profile.getId(), (Object)e);
            throw new IllegalStateException("Failed to set spawn point", e);
        }
        finally {
            DATA_LOCK.writeLock().unlock();
        }
    }

    public static boolean hasSpawnPoint(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.readLock().lock();
        try {
            CompoundTag data = LandfallAddonData.getOrCreateData(profile);
            boolean bl = data.contains(SPAWN_X_KEY, 6) && data.contains(SPAWN_Y_KEY, 6) && data.contains(SPAWN_Z_KEY, 6) && data.contains(SPAWN_DIMENSION_KEY, 8) && !data.getString(SPAWN_DIMENSION_KEY).isBlank();
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Error checking spawn point for character {}", (Object)profile.getId(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DATA_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalPos getSpawnPoint(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.readLock().lock();
        try {
            if (!LandfallAddonData.hasSpawnPoint(profile)) {
                GlobalPos globalPos = null;
                return globalPos;
            }
            CompoundTag data = LandfallAddonData.getOrCreateData(profile);
            double x = data.getDouble(SPAWN_X_KEY);
            double y = data.getDouble(SPAWN_Y_KEY);
            double z = data.getDouble(SPAWN_Z_KEY);
            String dimensionStr = data.getString(SPAWN_DIMENSION_KEY);
            if (!(LandfallAddonData.isValidCoordinate(x) && LandfallAddonData.isValidCoordinate(y) && LandfallAddonData.isValidCoordinate(z))) {
                LOGGER.warn("Invalid spawn coordinates for character {}: ({}, {}, {})", new Object[]{profile.getId(), x, y, z});
                GlobalPos globalPos = null;
                return globalPos;
            }
            ResourceLocation dimRL = ResourceLocation.tryParse((String)dimensionStr);
            if (dimRL == null) {
                LOGGER.warn("Invalid dimension '{}' for character {}", (Object)dimensionStr, (Object)profile.getId());
                GlobalPos globalPos = null;
                return globalPos;
            }
            ResourceKey dim = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dimension")), (ResourceLocation)dimRL);
            BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)dim, (BlockPos)pos);
            return globalPos;
        }
        catch (Exception e) {
            LOGGER.error("Error getting spawn point for character {}", (Object)profile.getId(), (Object)e);
            GlobalPos globalPos = null;
            return globalPos;
        }
        finally {
            DATA_LOCK.readLock().unlock();
        }
    }

    public static boolean isSpawnForced(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.readLock().lock();
        try {
            CompoundTag data = LandfallAddonData.getOrCreateData(profile);
            boolean bl = data.getBoolean(SPAWN_FORCED_KEY);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Error checking forced spawn for character {}", (Object)profile.getId(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            DATA_LOCK.readLock().unlock();
        }
    }

    public static void clearData(CharacterProfile profile) {
        LandfallAddonData.validateProfile(profile);
        DATA_LOCK.writeLock().lock();
        try {
            profile.setModData(DATA_KEY, new CompoundTag());
            LOGGER.debug("Cleared LandfallAddon data for character {}", (Object)profile.getId());
        }
        catch (Exception e) {
            LOGGER.error("Failed to clear data for character {}", (Object)profile.getId(), (Object)e);
            throw new IllegalStateException("Failed to clear data", e);
        }
        finally {
            DATA_LOCK.writeLock().unlock();
        }
    }

    private static CompoundTag getOrCreateData(CharacterProfile profile) {
        CompoundTag data = profile.getModData(DATA_KEY);
        if (data == null) {
            data = new CompoundTag();
            profile.setModData(DATA_KEY, data);
        }
        return data;
    }

    private static void validateProfile(CharacterProfile profile) {
        Objects.requireNonNull(profile, "CharacterProfile cannot be null");
    }

    private static void validateCoordinate(double coordinate, String name) {
        if (!LandfallAddonData.isValidCoordinate(coordinate)) {
            throw new IllegalArgumentException(String.format("%s coordinate %f is out of bounds [%f, %f]", name, coordinate, -3.0E7, 3.0E7));
        }
    }

    private static boolean isValidCoordinate(double coordinate) {
        return !Double.isNaN(coordinate) && !Double.isInfinite(coordinate) && coordinate >= -3.0E7 && coordinate <= 3.0E7;
    }
}

