/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.features.landfalladdon.LandfallAddonData;

public class OriginHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ORIGIN_KEY = "landfall_origin";
    private static final int MAX_ORIGIN_LENGTH = 100;
    private static final String DEFAULT_ORIGIN = "unknown";
    private static final ReadWriteLock dataLock = new ReentrantReadWriteLock();

    public static void setOrigin(CharacterProfile profile, String origin) {
        Objects.requireNonNull(profile, "CharacterProfile cannot be null");
        Objects.requireNonNull(origin, "Origin cannot be null");
        if (origin.isBlank()) {
            throw new IllegalArgumentException("Origin cannot be blank");
        }
        dataLock.writeLock().lock();
        try {
            if (!OriginHandler.isProfileValid(profile)) {
                LOGGER.warn("Attempted to set origin for invalid profile: {}", (Object)OriginHandler.getProfileName(profile));
                return;
            }
            String sanitizedOrigin = OriginHandler.sanitizeOrigin(origin);
            if (sanitizedOrigin == null) {
                LOGGER.error("Failed to sanitize origin '{}' for profile {}", (Object)origin, (Object)OriginHandler.getProfileName(profile));
                return;
            }
            CompoundTag modData = OriginHandler.getOrCreateModData(profile);
            if (modData == null) {
                LOGGER.error("Failed to get/create mod data for profile {}", (Object)OriginHandler.getProfileName(profile));
                return;
            }
            modData.putString(ORIGIN_KEY, sanitizedOrigin);
            LOGGER.debug("Set origin '{}' for profile {}", (Object)sanitizedOrigin, (Object)OriginHandler.getProfileName(profile));
        }
        catch (Exception e) {
            LOGGER.error("Error setting origin '{}' for profile {}", new Object[]{origin, OriginHandler.getProfileName(profile), e});
            throw new RuntimeException("Failed to set origin", e);
        }
        finally {
            dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOrigin(CharacterProfile profile) {
        Objects.requireNonNull(profile, "CharacterProfile cannot be null");
        dataLock.readLock().lock();
        try {
            if (!OriginHandler.isProfileValid(profile)) {
                LOGGER.debug("Profile invalid, returning default origin for: {}", (Object)OriginHandler.getProfileName(profile));
                String string = DEFAULT_ORIGIN;
                return string;
            }
            CompoundTag modData = OriginHandler.getModData(profile);
            if (modData == null) {
                LOGGER.debug("No mod data found, returning default origin for profile: {}", (Object)OriginHandler.getProfileName(profile));
                String string = DEFAULT_ORIGIN;
                return string;
            }
            if (!modData.contains(ORIGIN_KEY)) {
                LOGGER.debug("No origin key found, returning default origin for profile: {}", (Object)OriginHandler.getProfileName(profile));
                String string = DEFAULT_ORIGIN;
                return string;
            }
            String origin = modData.getString(ORIGIN_KEY);
            if (origin == null || origin.isBlank()) {
                LOGGER.debug("Origin is null/blank, returning default origin for profile: {}", (Object)OriginHandler.getProfileName(profile));
                String string = DEFAULT_ORIGIN;
                return string;
            }
            String validatedOrigin = OriginHandler.validateRetrievedOrigin(origin);
            LOGGER.debug("Retrieved origin '{}' for profile {}", (Object)validatedOrigin, (Object)OriginHandler.getProfileName(profile));
            String string = validatedOrigin;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error getting origin for profile {}, returning default", (Object)OriginHandler.getProfileName(profile), (Object)e);
            String string = DEFAULT_ORIGIN;
            return string;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOrigin(CharacterProfile profile) {
        Objects.requireNonNull(profile, "CharacterProfile cannot be null");
        dataLock.readLock().lock();
        try {
            if (!OriginHandler.isProfileValid(profile)) {
                boolean bl = false;
                return bl;
            }
            CompoundTag modData = OriginHandler.getModData(profile);
            if (modData == null) {
                boolean bl = false;
                return bl;
            }
            if (!modData.contains(ORIGIN_KEY)) {
                boolean bl = false;
                return bl;
            }
            String origin = modData.getString(ORIGIN_KEY);
            boolean bl = origin != null && !origin.isBlank() && !DEFAULT_ORIGIN.equals(origin);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Error checking if profile {} has origin", (Object)OriginHandler.getProfileName(profile), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    public static void clearOrigin(CharacterProfile profile) {
        Objects.requireNonNull(profile, "CharacterProfile cannot be null");
        dataLock.writeLock().lock();
        try {
            if (!OriginHandler.isProfileValid(profile)) {
                LOGGER.warn("Attempted to clear origin for invalid profile: {}", (Object)OriginHandler.getProfileName(profile));
                return;
            }
            CompoundTag modData = OriginHandler.getModData(profile);
            if (modData == null) {
                LOGGER.debug("No mod data found, nothing to clear for profile: {}", (Object)OriginHandler.getProfileName(profile));
                return;
            }
            if (modData.contains(ORIGIN_KEY)) {
                modData.remove(ORIGIN_KEY);
                LOGGER.debug("Cleared origin for profile {}", (Object)OriginHandler.getProfileName(profile));
            } else {
                LOGGER.debug("No origin to clear for profile {}", (Object)OriginHandler.getProfileName(profile));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error clearing origin for profile {}", (Object)OriginHandler.getProfileName(profile), (Object)e);
        }
        finally {
            dataLock.writeLock().unlock();
        }
    }

    public static String getPlayerOrigin(ServerPlayer player) {
        Objects.requireNonNull(player, "ServerPlayer cannot be null");
        try {
            Optional<CharacterProfile> profileOpt = OriginHandler.getPlayerCharacterProfile(player);
            if (profileOpt.isEmpty()) {
                LOGGER.debug("No character profile found for player {}, returning default origin", (Object)OriginHandler.getPlayerName(player));
                return DEFAULT_ORIGIN;
            }
            return OriginHandler.getOrigin(profileOpt.get());
        }
        catch (Exception e) {
            LOGGER.error("Error getting origin for player {}, returning default", (Object)OriginHandler.getPlayerName(player), (Object)e);
            return DEFAULT_ORIGIN;
        }
    }

    public static void setPlayerOrigin(ServerPlayer player, String origin) {
        Objects.requireNonNull(player, "ServerPlayer cannot be null");
        Objects.requireNonNull(origin, "Origin cannot be null");
        if (origin.isBlank()) {
            throw new IllegalArgumentException("Origin cannot be blank");
        }
        try {
            Optional<CharacterProfile> profileOpt = OriginHandler.getPlayerCharacterProfile(player);
            if (profileOpt.isEmpty()) {
                LOGGER.warn("No character profile found for player {}, cannot set origin", (Object)OriginHandler.getPlayerName(player));
                return;
            }
            OriginHandler.setOrigin(profileOpt.get(), origin);
            LOGGER.debug("Set origin '{}' for player {}", (Object)origin, (Object)OriginHandler.getPlayerName(player));
        }
        catch (Exception e) {
            LOGGER.error("Error setting origin '{}' for player {}", new Object[]{origin, OriginHandler.getPlayerName(player), e});
            throw new RuntimeException("Failed to set player origin", e);
        }
    }

    private static Optional<CharacterProfile> getPlayerCharacterProfile(ServerPlayer player) {
        try {
            if (!OriginHandler.isPlayerValid(player)) {
                return Optional.empty();
            }
            PlayerCharacterData characterData = (PlayerCharacterData)player.getData(PlayerCharacterCapability.CHARACTER_DATA);
            if (characterData == null) {
                LOGGER.debug("No character data found for player {}", (Object)OriginHandler.getPlayerName(player));
                return Optional.empty();
            }
            Long activeCharacterId = characterData.getActiveCharacterId();
            if (activeCharacterId == null) {
                LOGGER.debug("No active character ID for player {}", (Object)OriginHandler.getPlayerName(player));
                return Optional.empty();
            }
            CharacterProfile profile = characterData.getCharacter(activeCharacterId);
            return Optional.ofNullable(profile);
        }
        catch (Exception e) {
            LOGGER.error("Error getting character profile for player {}", (Object)OriginHandler.getPlayerName(player), (Object)e);
            return Optional.empty();
        }
    }

    private static CompoundTag getModData(CharacterProfile profile) {
        try {
            return profile.getModData(LandfallAddonData.DATA_KEY);
        }
        catch (Exception e) {
            LOGGER.error("Error getting mod data for profile {}", (Object)OriginHandler.getProfileName(profile), (Object)e);
            return null;
        }
    }

    private static CompoundTag getOrCreateModData(CharacterProfile profile) {
        try {
            CompoundTag modData = profile.getModData(LandfallAddonData.DATA_KEY);
            if (modData == null) {
                modData = new CompoundTag();
            }
            return modData;
        }
        catch (Exception e) {
            LOGGER.error("Error getting/creating mod data for profile {}", (Object)OriginHandler.getProfileName(profile), (Object)e);
            return null;
        }
    }

    private static String sanitizeOrigin(String origin) {
        try {
            if (origin == null) {
                return null;
            }
            String sanitized = origin.trim();
            if (sanitized.length() > 100) {
                LOGGER.warn("Origin too long ({}), truncating: {}", (Object)sanitized.length(), (Object)sanitized);
                sanitized = sanitized.substring(0, 100);
            }
            if (sanitized.chars().anyMatch(Character::isISOControl)) {
                LOGGER.warn("Origin contains control characters, rejecting: {}", (Object)sanitized);
                return null;
            }
            return sanitized;
        }
        catch (Exception e) {
            LOGGER.error("Error sanitizing origin: {}", (Object)origin, (Object)e);
            return null;
        }
    }

    private static String validateRetrievedOrigin(String origin) {
        if (origin == null || origin.isBlank()) {
            return DEFAULT_ORIGIN;
        }
        if (origin.length() > 100) {
            LOGGER.warn("Retrieved origin too long, truncating: {}", (Object)origin);
            return origin.substring(0, 100);
        }
        return origin;
    }

    private static boolean isProfileValid(CharacterProfile profile) {
        try {
            return profile != null && profile.getDisplayName() != null;
        }
        catch (Exception e) {
            LOGGER.debug("Error validating profile", (Throwable)e);
            return false;
        }
    }

    private static boolean isPlayerValid(ServerPlayer player) {
        try {
            return player != null && player.connection != null && !player.hasDisconnected();
        }
        catch (Exception e) {
            LOGGER.debug("Error validating player", (Throwable)e);
            return false;
        }
    }

    private static String getProfileName(CharacterProfile profile) {
        try {
            if (profile == null) {
                return "null";
            }
            String displayName = profile.getDisplayName();
            return displayName != null ? displayName : "unnamed";
        }
        catch (Exception e) {
            return "error-getting-name";
        }
    }

    private static String getPlayerName(ServerPlayer player) {
        try {
            if (player == null) {
                return "null";
            }
            Component name = player.getName();
            if (name == null) {
                return "unnamed";
            }
            String nameString = name.getString();
            return nameString != null ? nameString : "unnamed";
        }
        catch (Exception e) {
            return "error-getting-name";
        }
    }

    public static boolean validateConfiguration() {
        try {
            Class.forName("net.minecraft.nbt.CompoundTag");
            Class.forName("world.landfall.persona.data.CharacterProfile");
            Class.forName("world.landfall.persona.data.PlayerCharacterCapability");
            Class.forName("world.landfall.persona.data.PlayerCharacterData");
            if (ORIGIN_KEY == null || ORIGIN_KEY.isBlank()) {
                LOGGER.error("OriginHandler ORIGIN_KEY is null or blank");
                return false;
            }
            dataLock.readLock().lock();
            dataLock.readLock().unlock();
            dataLock.writeLock().lock();
            dataLock.writeLock().unlock();
            LOGGER.debug("OriginHandler configuration validation passed");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("OriginHandler configuration validation failed - missing required class", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("OriginHandler configuration validation failed", (Throwable)e);
            return false;
        }
    }
}

