/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon.origins;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.slf4j.Logger;
import world.landfall.persona.config.Config;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.features.landfalladdon.origins.Origin;
import world.landfall.persona.registry.PersonaEvents;

@EventBusSubscriber(modid="persona")
public class OriginHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation ORIGIN_KEY = ResourceLocation.fromNamespaceAndPath((String)"persona", (String)"origin_input");
    private static final String NO_ORIGIN_SELECTED = "UNSET";

    @SubscribeEvent
    public static void onCharacterCreated(PersonaEvents.CharacterCreateEvent event) {
        if (!((Boolean)Config.ENABLE_LANDFALL_ADDONS.get()).booleanValue()) {
            return;
        }
        CharacterProfile profile = event.getProfile();
        if (profile != null) {
            CompoundTag modData = profile.getModData(ORIGIN_KEY);
            if (modData == null || modData.isEmpty() || !modData.contains("selectedOrigin")) {
                CompoundTag originData = new CompoundTag();
                originData.putString("selectedOrigin", NO_ORIGIN_SELECTED);
                profile.setModData(ORIGIN_KEY, originData);
                LOGGER.debug("[OriginHandler] Initialized origin as UNSET for new character {}", (Object)profile.getId());
            }
        } else {
            LOGGER.warn("[OriginHandler] CharacterProfile was null in CharacterCreateEvent for character ID: {}. Cannot set initial origin.", (Object)event.getCharacterId());
        }
    }

    public static void setOrigin(CharacterProfile profile, Origin origin) {
        if (!((Boolean)Config.ENABLE_LANDFALL_ADDONS.get()).booleanValue()) {
            LOGGER.warn("[OriginHandler] Attempted to set origin while Landfall Addons are disabled.");
            return;
        }
        if (profile == null) {
            LOGGER.warn("[OriginHandler] Attempted to set origin on a null profile.");
            return;
        }
        CompoundTag originData = profile.getModData(ORIGIN_KEY);
        if (originData == null) {
            originData = new CompoundTag();
        }
        originData.putString("selectedOrigin", origin.name());
        profile.setModData(ORIGIN_KEY, originData);
        LOGGER.debug("[OriginHandler] Set origin to {} for character {}", (Object)origin.name(), (Object)profile.getId());
    }

    public static Optional<Origin> getOrigin(CharacterProfile profile) {
        if (!((Boolean)Config.ENABLE_LANDFALL_ADDONS.get()).booleanValue()) {
            return Optional.empty();
        }
        if (profile == null) {
            LOGGER.warn("[OriginHandler] Attempted to get origin from a null profile.");
            return Optional.empty();
        }
        CompoundTag originData = profile.getModData(ORIGIN_KEY);
        if (originData != null && originData.contains("selectedOrigin")) {
            String originName = originData.getString("selectedOrigin");
            if (NO_ORIGIN_SELECTED.equals(originName)) {
                return Optional.empty();
            }
            return Origin.fromString(originName);
        }
        return Optional.empty();
    }

    public static boolean hasSelectedOrigin(CharacterProfile profile) {
        if (!((Boolean)Config.ENABLE_LANDFALL_ADDONS.get()).booleanValue()) {
            return false;
        }
        if (profile == null) {
            return false;
        }
        return OriginHandler.getOrigin(profile).isPresent();
    }

    static {
        LOGGER.debug("OriginHandler loaded for Persona Landfall Addon features.");
    }
}

