/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon.origins;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import world.landfall.persona.Persona;
import world.landfall.persona.client.gui.input.CharacterCreationInputProvider;
import world.landfall.persona.features.landfalladdon.origins.Origin;

public class OriginInputProvider
implements CharacterCreationInputProvider {
    private static final ResourceLocation ID = ResourceLocation.parse((String)"persona:origin_input");
    private static final Component DISPLAY_NAME = Component.translatable((String)"screen.persona.origin");
    private static final Component PROMPT_TEXT = Component.translatable((String)"screen.persona.origin_prompt");
    private static final Component ERROR_NO_SELECTION = Component.translatable((String)"gui.persona.error.no_origin_selected");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Component getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public Component getPromptText() {
        return PROMPT_TEXT;
    }

    @Override
    public EditBox createEditBox(Font font, int x, int y, int width, int height) {
        OriginSelectionBox originBox = new OriginSelectionBox(font, x, y, width, height, this.getPromptText());
        originBox.setMaxLength(50);
        originBox.setEditable(false);
        return originBox;
    }

    @Override
    public boolean validateInput(String input) {
        return !input.isEmpty() && !input.equals("Click to select Origin");
    }

    @Override
    public Component getValidationErrorMessage(String input) {
        return ERROR_NO_SELECTION;
    }

    @Override
    public void processInput(String input, CompoundTag tag) {
        if (!input.isEmpty() && !input.equals("Click to select Origin")) {
            for (Origin origin : Origin.values()) {
                if (!input.startsWith(origin.getDisplayName())) continue;
                tag.putString("selectedOrigin", origin.name());
                Persona.LOGGER.debug("[Persona] Setting character origin to: {}", (Object)origin.getDisplayName());
                return;
            }
            Persona.LOGGER.warn("[Persona] Could not determine origin from input: {}", (Object)input);
        }
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public static class OriginSelectionBox
    extends EditBox {
        private Origin currentOrigin = null;

        public OriginSelectionBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
            this.setValue("Click to select Origin");
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height)) {
                this.cycleOrigin();
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        private void cycleOrigin() {
            Origin[] origins = Origin.values();
            if (this.currentOrigin == null) {
                this.currentOrigin = origins[0];
            } else {
                int currentIndex = this.currentOrigin.ordinal();
                this.currentOrigin = origins[(currentIndex + 1) % origins.length];
            }
            this.setValue(this.currentOrigin.getDisplayName() + " (Click to change)");
            this.setTooltip(Tooltip.create((Component)Component.literal((String)this.currentOrigin.getDescription())));
        }

        public Origin getCurrentOrigin() {
            return this.currentOrigin;
        }
    }
}

