/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.persona.features.landfalladdon.shells;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import world.landfall.persona.data.CharacterProfile;
import world.landfall.persona.data.PlayerCharacterCapability;
import world.landfall.persona.data.PlayerCharacterData;
import world.landfall.persona.features.landfalladdon.LandfallAddonData;
import world.landfall.persona.features.landfalladdon.shells.Shell;
import world.landfall.persona.registry.PersonaEvents;

@EventBusSubscriber(modid="persona")
public class ShellEffectManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Shell, List<EffectSpec>> EFFECTS;

    public static void applyShell(ServerPlayer player, Shell shell) {
        ShellEffectManager.removeAllShellModifiers(player);
        List specs = EFFECTS.getOrDefault((Object)shell, List.of());
        for (EffectSpec spec : specs) {
            AttributeInstance inst = player.getAttribute(spec.attribute);
            if (inst == null) continue;
            ResourceLocation rl = ShellEffectManager.getRL(shell, spec.attribute);
            inst.removeModifier(rl);
            AttributeModifier mod = new AttributeModifier(rl, spec.amount, spec.op);
            inst.addPermanentModifier(mod);
        }
        player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
    }

    private static void removeAllShellModifiers(ServerPlayer player) {
        for (Shell s : Shell.values()) {
            List specs = EFFECTS.getOrDefault((Object)s, List.of());
            for (EffectSpec spec : specs) {
                ResourceLocation rl;
                AttributeInstance inst = player.getAttribute(spec.attribute);
                if (inst == null || inst.getModifier(rl = ShellEffectManager.getRL(s, spec.attribute)) == null) continue;
                inst.removeModifier(rl);
            }
        }
    }

    private static ResourceLocation getRL(Shell shell, Holder<Attribute> attrHolder) {
        String attrPath = attrHolder.unwrapKey().map(k -> k.location().getPath()).orElse("unknown");
        String path = "shell_" + shell.name().toLowerCase() + "_" + attrPath;
        return ResourceLocation.fromNamespaceAndPath((String)"persona", (String)path);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        Long active = data.getActiveCharacterId();
        if (active == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(active);
        if (profile == null) {
            return;
        }
        Shell shell = LandfallAddonData.getCurrentShell(profile);
        ShellEffectManager.applyShell(player2, shell);
        LOGGER.debug("[ShellEffects] Applied shell {} for player {} on login.", (Object)shell, (Object)player2.getName().getString());
    }

    @SubscribeEvent
    public static void onCharacterSwitch(PersonaEvents.CharacterSwitchEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(event.getToCharacterId());
        if (profile == null) {
            return;
        }
        Shell shell = LandfallAddonData.getCurrentShell(profile);
        ShellEffectManager.applyShell(player2, shell);
        LOGGER.debug("[ShellEffects] Applied shell {} for player {} on character switch.", (Object)shell, (Object)player2.getName().getString());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerCharacterData data = (PlayerCharacterData)player2.getData(PlayerCharacterCapability.CHARACTER_DATA);
        if (data == null) {
            return;
        }
        Long active = data.getActiveCharacterId();
        if (active == null) {
            return;
        }
        CharacterProfile profile = data.getCharacter(active);
        if (profile == null) {
            return;
        }
        Shell shell = LandfallAddonData.getCurrentShell(profile);
        ShellEffectManager.applyShell(player2, shell);
        LOGGER.debug("[ShellEffects] Applied shell {} for player {} on respawn.", (Object)shell, (Object)player2.getName().getString());
    }

    static {
        EnumMap m = new EnumMap(Shell.class);
        m.put(Shell.SWIFT, List.of(new EffectSpec((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.02, AttributeModifier.Operation.ADD_VALUE)));
        m.put(Shell.SLUGGISH, List.of(new EffectSpec((Holder<Attribute>)Attributes.MOVEMENT_SPEED, -0.015, AttributeModifier.Operation.ADD_VALUE)));
        m.put(Shell.ROBUST, List.of(new EffectSpec((Holder<Attribute>)Attributes.MAX_HEALTH, 2.0, AttributeModifier.Operation.ADD_VALUE)));
        m.put(Shell.FRAIL, List.of(new EffectSpec((Holder<Attribute>)Attributes.MAX_HEALTH, -4.0, AttributeModifier.Operation.ADD_VALUE)));
        m.put(Shell.KEEN_EYES, List.of(new EffectSpec((Holder<Attribute>)Attributes.LUCK, 1.0, AttributeModifier.Operation.ADD_VALUE)));
        m.put(Shell.CLUMSY, List.of(new EffectSpec((Holder<Attribute>)Attributes.LUCK, -1.0, AttributeModifier.Operation.ADD_VALUE)));
        m.put(Shell.NEUTRAL, List.of());
        EFFECTS = Collections.unmodifiableMap(m);
    }

    private record EffectSpec(Holder<Attribute> attribute, double amount, AttributeModifier.Operation op) {
    }
}

