/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.example.common.registery;

import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.util.interfaces.IGunModifier;
import java.util.Set;
import net.minecraft.util.Mth;

public class GunModifiers {
    public static final IGunModifier SILENCED = new IGunModifier(){

        @Override
        public boolean silencedFire(boolean value, GunData data) {
            return true;
        }

        @Override
        public double modifyFireSoundRadius(double radius, GunData data) {
            return radius * 0.25;
        }

        @Override
        public int modifyFireRate(int rate, GunData data) {
            return 1;
        }
    };
    public static final IGunModifier REDUCED_DAMAGE = new IGunModifier(){

        @Override
        public float modifyDamage(float damage, GunData data) {
            return damage * 0.75f;
        }
    };
    public static final IGunModifier SLOW_ADS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.95f;
        }
    };
    public static final IGunModifier SLOWER_ADS = new IGunModifier(){

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.9f;
        }
    };
    public static final IGunModifier EXTENDED_MAG = new IGunModifier(){

        @Override
        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return (int)((double)maxAmmo * 1.5);
        }
    };
    public static final IGunModifier DRUM_MAG = new IGunModifier(){

        @Override
        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return maxAmmo * 4;
        }
    };
    public static final IGunModifier BETTER_CONTROL = new IGunModifier(){

        @Override
        public float recoilModifier(GunData data) {
            return 0.3f;
        }

        @Override
        public float kickModifier(GunData data) {
            return 0.8f;
        }

        @Override
        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.75f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.95f;
        }
    };
    public static final IGunModifier STABILISED = new IGunModifier(){

        @Override
        public float recoilModifier(GunData data) {
            return 0.4f;
        }

        @Override
        public float kickModifier(GunData data) {
            return 0.3f;
        }

        @Override
        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.5f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.9f;
        }

        @Override
        public int modifyFireRate(int rate, GunData data) {
            return rate + 20;
        }
    };
    public static final IGunModifier SUPER_STABILISED = new IGunModifier(){

        @Override
        public float recoilModifier(GunData data) {
            return 0.1f;
        }

        @Override
        public float kickModifier(GunData data) {
            return 0.1f;
        }

        @Override
        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.25f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * 0.5;
        }

        @Override
        public int modifyFireRate(int rate, GunData data) {
            return Mth.m_14045_((int)((int)((double)rate * 1.25)), (int)(rate + 1), (int)Integer.MAX_VALUE);
        }
    };
    public static final IGunModifier LIGHT_RECOIL = new IGunModifier(){

        @Override
        public int modifyMaxAmmo(int maxAmmo, GunData data) {
            return (int)((double)maxAmmo * 2.5);
        }

        @Override
        public int modifyProjectileAmount(int amount, GunData data) {
            return IGunModifier.super.modifyProjectileAmount(amount, data);
        }

        @Override
        public Set<AmmoHolder> modifyAmmoItems(Set<AmmoHolder> item, GunData data) {
            return IGunModifier.super.modifyAmmoItems(item, data);
        }

        @Override
        public float recoilModifier(GunData data) {
            return 0.75f;
        }

        @Override
        public float kickModifier(GunData data) {
            return 0.75f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)1.2f;
        }

        @Override
        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.8f;
        }

        @Override
        public int modifyFireRate(int rate, GunData data) {
            return rate * 2;
        }

        @Override
        public float modifyDamage(float damage, GunData data) {
            return damage + 20.0f;
        }
    };
    public static final IGunModifier REDUCED_RECOIL = new IGunModifier(){

        @Override
        public Set<FireMode> modifyFireModes(Set<FireMode> fireMode, GunData data) {
            return Set.of(FireMode.AUTO, FireMode.MULTI);
        }

        @Override
        public int modifyFireRate(int rate, GunData data) {
            return 15;
        }

        @Override
        public float recoilModifier(GunData data) {
            return 1.53f;
        }

        @Override
        public float kickModifier(GunData data) {
            return 0.5f;
        }

        @Override
        public double modifyAimDownSightSpeed(double speed, GunData data) {
            return speed * (double)0.95f;
        }

        @Override
        public float modifyProjectileSpread(float spread, GunData data) {
            return spread * 0.5f;
        }
    };
}

