/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.animators;

import com.nukateam.geo.render.ItemAnimator;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.audio.GunShotSound;
import com.nukateam.ntgl.client.handlers.ClientHandler;
import com.nukateam.ntgl.client.handlers.ClientTickHandler;
import com.nukateam.ntgl.client.model.gun.GeoGunModel;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicGunRenderer;
import com.nukateam.ntgl.client.util.handler.ClientEquipHandler;
import com.nukateam.ntgl.client.util.handler.ClientMeleeHandler;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.ShootingData;
import com.nukateam.ntgl.client.util.handler.ShootingHandler;
import com.nukateam.ntgl.client.util.util.TransformUtils;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.util.helpers.PlayerHelper;
import com.nukateam.ntgl.common.util.interfaces.IConfigProvider;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.AnimationHelper;
import com.nukateam.ntgl.common.util.util.Cycler;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.HashMap;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.keyframe.event.SoundKeyframeEvent;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GunAnimator
extends ItemAnimator
implements IConfigProvider<Gun> {
    public static final String STATIC = "static";
    protected final DynamicGunRenderer<GunAnimator> renderer;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final ShootingHandler shootingHandler = ShootingHandler.get();
    protected final ClientReloadHandler reloadHandler = ClientReloadHandler.get();
    protected final AnimationHelper<GunAnimator> animationHelper;
    protected final AnimationController<GunAnimator> TRIGGER_CONTROLLER;
    protected final AnimationController<GunAnimator> MAIN_CONTROLLER;
    protected final AnimationController<GunAnimator> REVOLVER_CONTROLLER;
    protected final AnimationController<GunAnimator> BARREL_CONTROLLER;
    protected final InteractionHand arm;
    protected Cycler barrelCycler = new Cycler(1, this.getBarrelAmount());
    protected Cycler chamberCycler = null;
    protected WeaponItem currentGun = null;
    protected int rate;
    protected int equipTime;
    protected int meleeDelay;
    protected int meleeCooldown;
    protected int fireDelay;
    protected int reloadTime;
    protected int reloadStartTime;
    protected int reloadEndTime;
    protected boolean isEquiping;
    protected ItemStack itemCache = ItemStack.f_41583_;

    public GunAnimator(ItemDisplayContext transformType, DynamicGunRenderer<GunAnimator> renderer) {
        super(transformType);
        this.renderer = renderer;
        this.arm = this.getArm();
        ClientTickHandler.addTicker((Object)this, this::tick);
        this.TRIGGER_CONTROLLER = this.createController("triggerController", (AnimationController.AnimationStateHandler<GunAnimator>)((AnimationController.AnimationStateHandler)event -> PlayState.CONTINUE));
        this.MAIN_CONTROLLER = this.createController("mainController", this.animate()).setSoundKeyframeHandler(this::handleSoundEvent).triggerableAnim("equip", RawAnimation.begin().then("equip", Animation.LoopType.LOOP));
        this.REVOLVER_CONTROLLER = this.createController("revolverController", this.animateRevolver());
        this.BARREL_CONTROLLER = this.createController("barrelController", this.animateBarrels());
        this.animationHelper = new AnimationHelper<GunAnimator>(this, GeoGunModel.INSTANCE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.MAIN_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.TRIGGER_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.REVOLVER_CONTROLLER});
        controllerRegistrar.add(new AnimationController[]{this.BARREL_CONTROLLER});
    }

    @Override
    public Gun getConfig() {
        IConfigProvider config;
        Object t;
        Item item = this.getStack().m_41720_();
        if (item instanceof IConfigProvider && (t = (config = (IConfigProvider)item).getConfig()) instanceof Gun) {
            Gun gun = (Gun)t;
            return gun;
        }
        return new Gun();
    }

    public void tick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else {
            this.tickEnd();
        }
    }

    protected void tickStart() {
        if (!(this.getStack().m_41720_() instanceof WeaponItem)) {
            return;
        }
        GunData data = this.getGunData();
        this.rate = GunModifierHelper.getRate(data);
        this.equipTime = GunModifierHelper.getEquipTime(data);
        this.isEquiping = EquipTracker.isEquiping(this.getEntity(), this.getArm());
        this.meleeDelay = GunModifierHelper.getMeleeDelay(data);
        this.meleeCooldown = GunModifierHelper.getMeleeCooldown(data);
        this.fireDelay = GunModifierHelper.getFireDelay(data);
        this.reloadTime = GunModifierHelper.getReloadTime(data);
        this.reloadStartTime = GunModifierHelper.getReloadStart(data);
        this.reloadEndTime = GunModifierHelper.getReloadEnd(data);
        this.setupCycledAnimations();
    }

    protected void tickEnd() {
    }

    protected int getBarrelAmount() {
        return 1;
    }

    protected LivingEntity getEntity() {
        return this.renderer.getRenderEntity();
    }

    protected WeaponItem getGunItem() {
        return (WeaponItem)this.getStack().m_41720_();
    }

    @NotNull
    protected GunData getGunData() {
        return new GunData(this.getStack(), this.getEntity());
    }

    protected boolean isOneHanded(ItemStack stack) {
        return GunStateHelper.isOneHanded(new GunData(stack, this.getEntity()));
    }

    @NotNull
    protected AnimationController<GunAnimator> createController(String name, AnimationController.AnimationStateHandler<GunAnimator> animate) {
        return new AnimationController((GeoAnimatable)this, name, 0, animate);
    }

    protected InteractionHand getArm() {
        return TransformUtils.isRightHand(this.transformType) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    protected AnimationController.AnimationStateHandler<GunAnimator> animate() {
        return event -> {
            if (this.itemCache != this.getStack()) {
                this.itemCache = this.getStack();
                return event.setAndContinue(RawAnimation.begin().then("void", Animation.LoopType.PLAY_ONCE));
            }
            try {
                AnimationController controller = event.getController();
                controller.setAnimationSpeed(1.0);
                LivingEntity shooter = this.getEntity();
                if (!TransformUtils.isHandTransform(this.transformType)) {
                    return event.setAndContinue(this.getHoldAnimation((AnimationState<GunAnimator>)event));
                }
                boolean isShooting = this.shootingHandler.isShooting(shooter, this.arm);
                ShootingData data = this.shootingHandler.getShootingData(this.arm);
                RawAnimation animation = RawAnimation.begin();
                if (ClientEquipHandler.get().isEquiping(this.arm)) {
                    animation = this.getEquipAnimation((AnimationState<GunAnimator>)event);
                } else if (ClientMeleeHandler.isOnDelay(shooter, this.arm)) {
                    animation = this.getMeleeDelayAnimation((AnimationState<GunAnimator>)event);
                } else if (ClientMeleeHandler.isOnCooldown(shooter, this.arm)) {
                    animation = this.getMeleeCooldownAnimation((AnimationState<GunAnimator>)event);
                } else if (this.fireDelay > 0 && data.fireTimer > 0 && this.fireDelay != data.fireTimer) {
                    animation = this.getChargingAnimation((AnimationState<GunAnimator>)event, data);
                } else if (this.reloadHandler.isReloading(shooter, this.arm)) {
                    animation = this.getReloadingAnimation((AnimationState<GunAnimator>)event);
                } else if (isShooting) {
                    animation = this.getShootingAnimation((AnimationState<GunAnimator>)event);
                } else if (this.reloadHandler.isReloading(shooter, PlayerHelper.getOpposite(this.arm))) {
                    animation = this.getHideAnimation((AnimationState<GunAnimator>)event);
                } else if (ClientHandler.getInspectionTicks(this.getArm()) > 0) {
                    animation = this.getInspectionAnimation((AnimationState<GunAnimator>)event);
                } else if (this.currentGun == this.getGunItem()) {
                    animation = this.getHoldAnimation((AnimationState<GunAnimator>)event);
                } else {
                    this.currentGun = this.getGunItem();
                    animation = this.playGunAnim("shot", Animation.LoopType.LOOP);
                }
                return animation != null ? event.setAndContinue(animation) : PlayState.STOP;
            }
            catch (Exception e) {
                Ntgl.LOGGER.error(e.getMessage());
                return PlayState.STOP;
            }
        };
    }

    protected AnimationController.AnimationStateHandler<GunAnimator> animateRevolver() {
        return event -> this.getCycledAnimation((AnimationState<GunAnimator>)event, "chamber", this.chamberCycler);
    }

    protected AnimationController.AnimationStateHandler<GunAnimator> animateBarrels() {
        return event -> this.getCycledAnimation((AnimationState<GunAnimator>)event, "barrel", this.barrelCycler);
    }

    protected PlayState getCycledAnimation(AnimationState<GunAnimator> event, String animationName, Cycler cycler) {
        event.getController().setAnimationSpeed(1.0);
        if (TransformUtils.isHandTransform(this.transformType) && cycler != null) {
            LivingEntity entity = this.getEntity();
            boolean isShooting = this.shootingHandler.isShooting(entity, TransformUtils.getHand(this.transformType));
            String finalAnim = animationName + cycler.getCurrent();
            RawAnimation animation = null;
            if (isShooting && this.animationHelper.hasAnimation(finalAnim)) {
                animation = RawAnimation.begin().then(finalAnim, Animation.LoopType.HOLD_ON_LAST_FRAME);
                this.animationHelper.syncAnimation(event, finalAnim, this.rate);
            }
            return event.setAndContinue(animation);
        }
        return PlayState.STOP;
    }

    protected RawAnimation getHoldAnimation(AnimationState<GunAnimator> event) {
        return this.playGunAnim("hold", Animation.LoopType.LOOP);
    }

    protected RawAnimation getStaticAnimation(AnimationState<GunAnimator> event) {
        return this.playGunAnim(STATIC, Animation.LoopType.LOOP);
    }

    protected RawAnimation getHideAnimation(AnimationState<GunAnimator> event) {
        return RawAnimation.begin().then("hide", Animation.LoopType.HOLD_ON_LAST_FRAME);
    }

    protected RawAnimation getInspectionAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("inspect", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "inspect", ClientHandler.getMaxInspectionTicks());
        return animation;
    }

    protected RawAnimation getChargingAnimation(AnimationState<GunAnimator> event, ShootingData shootingData) {
        RawAnimation animation = RawAnimation.begin();
        if (this.animationHelper.hasAnimation("charge")) {
            this.BARREL_CONTROLLER.stop();
            this.BARREL_CONTROLLER.setAnimation(RawAnimation.begin().then("void", Animation.LoopType.PLAY_ONCE));
            animation = this.playGunAnim("charge", Animation.LoopType.LOOP);
            this.animationHelper.syncAnimation(event, "charge", this.fireDelay);
        }
        return animation;
    }

    protected RawAnimation getMeleeDelayAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("melee", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "melee", this.meleeDelay);
        return animation;
    }

    protected RawAnimation getMeleeCooldownAnimation(AnimationState<GunAnimator> event) {
        if (!this.animationHelper.hasAnimation("melee_end")) {
            return this.getHoldAnimation(event);
        }
        RawAnimation animation = this.playGunAnim("melee_end", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "melee_end", this.meleeCooldown);
        return animation;
    }

    protected RawAnimation getEquipAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("equip", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "equip", this.equipTime);
        return animation;
    }

    protected RawAnimation getShootingAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("shot", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "shot", this.rate);
        return animation;
    }

    protected RawAnimation getReloadingAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = RawAnimation.begin();
        animation = (Boolean)ModSyncedDataKeys.RELOAD_START.getValue((Entity)this.getEntity()) != false ? this.getStartReloadAnimation(event) : ((Boolean)ModSyncedDataKeys.RELOAD_END.getValue((Entity)this.getEntity()) != false ? this.getEndReloadAnimation(event) : this.getDefaultReloadAnimation(event));
        return animation;
    }

    protected RawAnimation getDefaultReloadAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("reload", Animation.LoopType.LOOP);
        this.animationHelper.syncAnimation(event, "reload", this.reloadTime);
        return animation;
    }

    protected RawAnimation getEndReloadAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("reload_end", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "reload_end", this.reloadEndTime);
        return animation;
    }

    protected RawAnimation getStartReloadAnimation(AnimationState<GunAnimator> event) {
        RawAnimation animation = this.playGunAnim("reload_start", Animation.LoopType.PLAY_ONCE);
        this.animationHelper.syncAnimation(event, "reload_start", this.reloadStartTime);
        return animation;
    }

    protected void handleSoundEvent(SoundKeyframeEvent<GunAnimator> event) {
        LocalPlayer player = this.minecraft.f_91074_;
        String name = event.getKeyframeData().getSound();
        HashMap<String, ResourceLocation> sounds = this.getGunItem().getGun().getSoundsMap();
        ResourceLocation sound = sounds.get(name);
        if (sound != null && player != null) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)new GunShotSound(sound, SoundSource.PLAYERS, player.m_20182_(), 1.0f, 1.0f, true));
        }
    }

    protected RawAnimation playGunAnim(String name, Animation.LoopType loopType) {
        if (TransformUtils.isFirstPerson(this.getTransformType())) {
            String gunAnim = this.getGunAnim(name);
            return RawAnimation.begin().then(gunAnim, loopType);
        }
        String tpvOneHand = name + "_one_hand_tpv";
        String tpv = name + "_tpv";
        if (this.isOneHanded() && this.animationHelper.hasAnimation(tpvOneHand)) {
            return RawAnimation.begin().then(tpvOneHand, loopType);
        }
        if (this.animationHelper.hasAnimation(tpv)) {
            return RawAnimation.begin().then(tpv, loopType);
        }
        return RawAnimation.begin();
    }

    protected String getGunAnim(String name) {
        boolean isOneHanded = this.isOneHanded();
        if (isOneHanded && this.animationHelper.hasAnimation((String)name + "_one_hand")) {
            name = (String)name + "_one_hand";
        }
        return name;
    }

    private boolean isOneHanded() {
        LivingEntity entity = this.getEntity();
        ItemStack currentItem = entity.m_21120_(this.arm);
        ItemStack oppositeItem = entity.m_21120_(PlayerHelper.getOpposite(this.arm));
        boolean isOneHanded = this.isOneHanded(currentItem) && this.isOneHanded(oppositeItem) && !oppositeItem.m_41619_() || this.arm == InteractionHand.OFF_HAND;
        boolean hasShield = this.isOneHanded(currentItem) && oppositeItem.m_41720_() instanceof ShieldItem;
        boolean isS = hasShield || isOneHanded;
        return isS;
    }

    private void setupCycledAnimations() {
        LivingEntity entity = this.getEntity();
        int cooldown = this.shootingHandler.getCooldown(entity, this.arm);
        GunData data = this.getGunData();
        int maxAmmo = GunModifierHelper.getMaxAmmo(data);
        if (this.chamberCycler == null || this.chamberCycler.getMax() != maxAmmo) {
            this.chamberCycler = new Cycler(1, maxAmmo);
        }
        if (cooldown == this.rate) {
            this.barrelCycler.cycle();
            this.chamberCycler.cycle();
        }
    }
}

