/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.handlers;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.audio.GunShotSound;
import com.nukateam.ntgl.client.render.renderers.misc.DeathFxRenderer;
import com.nukateam.ntgl.client.util.BulletTrail;
import com.nukateam.ntgl.client.util.handler.BulletTrailRenderingHandler;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.GunRenderingHandler;
import com.nukateam.ntgl.common.foundation.init.ModParticleTypes;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.particles.BulletHoleData;
import com.nukateam.ntgl.common.network.message.S2CMessageBlood;
import com.nukateam.ntgl.common.network.message.S2CMessageBulletTrail;
import com.nukateam.ntgl.common.network.message.S2CMessageEntityDeathFx;
import com.nukateam.ntgl.common.network.message.S2CMessageGunSound;
import com.nukateam.ntgl.common.network.message.S2CMessagePlayerAnimation;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileExplosion;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitBlock;
import com.nukateam.ntgl.common.network.message.S2CMessageProjectileHitEntity;
import com.nukateam.ntgl.common.network.message.S2CMessageReload;
import com.nukateam.ntgl.common.network.message.S2CMessageRemoveProjectile;
import com.nukateam.ntgl.common.network.message.S2CMessageStunGrenade;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAmmo;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateAttachments;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateGuns;
import com.nukateam.ntgl.common.network.message.S2CMessageUpdateThrowable;
import com.nukateam.ntgl.common.util.world.ProjectileExplosion;
import com.nukateam.ntgl.modules.datapack.managers.NetworkAmmoManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkAttachmentManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkGrenadeManager;
import com.nukateam.ntgl.modules.datapack.managers.NetworkGunManager;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientPlayHandler {
    public static void handleMessageGunSound(S2CMessageGunSound message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (message.showMuzzleFlash()) {
            GunRenderingHandler.get().showMuzzleFlashForPlayer(message.getShooterId());
        }
        if (message.getShooterId() == mc.f_91074_.m_19879_()) {
            mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(message.getId(), SoundSource.PLAYERS, GunShotSound.getVolume(message.getVolume()), message.getPitch(), mc.f_91073_.m_213780_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        } else {
            mc.m_91106_().m_120367_((SoundInstance)new GunShotSound(message.getId(), SoundSource.PLAYERS, message.getX(), message.getY(), message.getZ(), message.getVolume(), message.getPitch(), message.isReload()));
        }
    }

    public static void handleMessageBlood(S2CMessageBlood message) {
        if (!((Boolean)Config.CLIENT.particle.enableBlood.get()).booleanValue()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                world.m_6493_((ParticleOptions)ModParticleTypes.BLOOD.get(), true, message.getX(), message.getY(), message.getZ(), 0.5, 0.0, 0.5);
            }
        }
    }

    public static void handleMessageBulletTrail(S2CMessageBulletTrail message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            int[] entityIds = message.getEntityIds();
            Vec3[] positions = message.getPositions();
            Vec3[] motions = message.getMotions();
            ItemStack item = message.getItem();
            int trailColor = message.getTrailColor();
            double trailLengthMultiplier = message.getTrailLengthMultiplier();
            int life = message.getLife();
            double gravity = message.getGravity();
            int shooterId = message.getShooterId();
            boolean enchanted = message.isEnchanted();
            ParticleOptions data = message.getParticleData();
            for (int i = 0; i < message.getCount(); ++i) {
                BulletTrailRenderingHandler.get().add(new BulletTrail(entityIds[i], positions[i], motions[i], item, trailColor, trailLengthMultiplier, life, gravity, shooterId, enchanted, data));
            }
        }
    }

    public static void handleMessageExplosion(S2CMessageProjectileExplosion message) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Minecraft minecraft = Minecraft.m_91087_();
        if (level != null) {
            ProjectileExplosion explosion = new ProjectileExplosion((Level)level, null, message.getConfig(), message.getPosition(), Explosion.BlockInteraction.KEEP, message.getToBlow());
            explosion.m_46075_(true);
            minecraft.f_91074_.m_20256_(minecraft.f_91074_.m_20184_().m_82549_(message.getKnockback()));
        }
    }

    public static void handleMessageAnimation(S2CMessagePlayerAnimation message) {
        int id = message.getEntityId();
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(id);
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            message.getAnimation().playAnimation((Player)player, message.getHand());
        }
    }

    public static void handleExplosionStunGrenade(S2CMessageStunGrenade message) {
        int i;
        Minecraft mc = Minecraft.m_91087_();
        ParticleEngine particleManager = mc.f_91061_;
        ClientLevel world = mc.f_91073_;
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        for (i = 0; i < 30; ++i) {
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123796_, x, y, z, world.f_46441_, 0.2);
        }
        for (i = 0; i < 30; ++i) {
            Particle smoke = ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, world.f_46441_, 4.0);
            smoke.m_107257_((int)(8.0 / (Math.random() * 0.1 + 0.4) * 0.5));
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123797_, x, y, z, world.f_46441_, 4.0);
        }
    }

    private static Particle spawnParticle(ParticleEngine manager, ParticleOptions data, double x, double y, double z, RandomSource rand, double velocityMultiplier) {
        return manager.m_107370_(data, x, y, z, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier);
    }

    public static void handleProjectileHitBlock(S2CMessageProjectileHitBlock message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            BlockState state = world.m_8055_(message.getPos());
            double holeX = message.getX() + 0.005 * (double)message.getFace().m_122429_();
            double holeY = message.getY() + 0.005 * (double)message.getFace().m_122430_();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().m_122431_();
            double distance = Math.sqrt(mc.f_91074_.m_20275_(message.getX(), message.getY(), message.getZ()));
            world.m_6493_((ParticleOptions)new BulletHoleData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            if (distance < (Double)Config.CLIENT.particle.impactParticleDistance.get()) {
                for (int i = 0; i < 4; ++i) {
                    Vec3i normal = message.getFace().m_122436_();
                    Vec3 motion = new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_());
                    motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
                    world.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), false, message.getX(), message.getY(), message.getZ(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            if (distance <= (Double)Config.CLIENT.sounds.impactSoundDistance.get()) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 2.0f, false);
            }
        }
    }

    public static void handleEntityDeathFx(S2CMessageEntityDeathFx message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level != null) {
            LivingEntity entity = (LivingEntity)level.m_6815_(message.getEntityId());
            DeathFxRenderer.createDeathEffectClient(entity, message.getData());
        }
    }

    private static double getRandomDir(RandomSource random) {
        return -0.25 + random.m_188500_() * 0.5;
    }

    public static void handleProjectileHitEntity(S2CMessageProjectileHitEntity message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        SoundEvent event = ClientPlayHandler.getHitSound(message.isCritical(), message.isHeadshot(), message.isPlayer());
        if (event == null) {
            return;
        }
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)1.0f, (float)(0.8f + world.f_46441_.m_188501_() * 0.2f)));
    }

    @Nullable
    private static SoundEvent getHitSound(boolean critical, boolean headshot, boolean player) {
        if (critical) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenCritical.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.criticalSound.get()));
                return event != null ? event : SoundEvents.f_12313_;
            }
        } else if (headshot) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenHeadshot.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.headshotSound.get()));
                return event != null ? event : SoundEvents.f_12314_;
            }
        } else if (player) {
            return SoundEvents.f_12323_;
        }
        return null;
    }

    public static void handleRemoveProjectile(S2CMessageRemoveProjectile message) {
        BulletTrailRenderingHandler.get().remove(message.getEntityId());
    }

    public static void handleUpdateGuns(S2CMessageUpdateGuns message) {
        NetworkGunManager.updateRegisteredGuns(message);
    }

    public static void handleUpdateAmmo(S2CMessageUpdateAmmo message) {
        NetworkAmmoManager.updateRegisteredAmmo(message);
    }

    public static void handleUpdateAttachments(S2CMessageUpdateAttachments message) {
        NetworkAttachmentManager.updateRegisteredAttachments(message);
    }

    public static void handleUpdateThrowable(S2CMessageUpdateThrowable message) {
        NetworkGrenadeManager.updateRegisteredConfigs(message);
    }

    public static void handleReload(S2CMessageReload message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_5833_()) {
            InteractionHand arm = message.isRightHand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            SyncedDataKey<LivingEntity, Boolean> dataKey = message.isRightHand() ? ModSyncedDataKeys.RELOADING_RIGHT : ModSyncedDataKeys.RELOADING_LEFT;
            ClientReloadHandler.get().setReloading((Boolean)dataKey.getValue((Entity)player) == false, arm);
        }
    }
}

