/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.renderers.misc;

import com.nukateam.ntgl.ClientProxy;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.model.gibs.ModelGibsAgeable;
import com.nukateam.ntgl.client.model.gibs.ModelGibsGeneric;
import com.nukateam.ntgl.client.model.gibs.ModelGibsGeo;
import com.nukateam.ntgl.common.foundation.entity.FlyingGib;
import com.nukateam.ntgl.common.foundation.entity.projectile.GoreData;
import java.lang.reflect.Method;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeathFxRenderer {
    private static final ResourceLocation RES_BURN_EFFECT = ResourceLocation.m_214293_((String)"ntgl", (String)"textures/fx/death/burn.png");
    private static final ResourceLocation RES_LASER_EFFECT = ResourceLocation.m_214293_((String)"ntgl", (String)"textures/fx/death/laser.png");
    private static GoreData genericGore = new GoreData(null, 160, 21, 31).setTexture(ResourceLocation.m_214293_((String)"ntgl", (String)"textures/entity/gore.png"));

    /*
     * Enabled aggressive block sorting
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void setupGoreData(LivingEntity entity, GoreData data) {
        EntityRenderer render = ClientProxy.getEntityRenderer((Entity)entity);
        if (data.model != null) return;
        if (render instanceof GeoEntityRenderer) {
            GeoEntityRenderer geoRenderer = (GeoEntityRenderer)render;
            if (entity instanceof GeoAnimatable) {
                GeoAnimatable animatable = (GeoAnimatable)entity;
                GeoModel geoModel = geoRenderer.getGeoModel();
                BakedGeoModel model = geoModel.getBakedModel(geoModel.getModelResource(animatable));
                data.model = new ModelGibsGeo(model, geoRenderer);
                return;
            }
        }
        if (!(render instanceof LivingEntityRenderer)) return;
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)render;
        EntityModel mainModel = livingRenderer.m_7200_();
        if (mainModel instanceof HierarchicalModel) {
            HierarchicalModel model = (HierarchicalModel)mainModel;
            data.model = new ModelGibsGeneric(model);
            return;
        }
        if (mainModel instanceof AgeableListModel) {
            AgeableListModel model = (AgeableListModel)mainModel;
            data.model = new ModelGibsAgeable(model);
            return;
        }
        data.model = DeathFxRenderer.genericGore.model;
        data.texture = DeathFxRenderer.genericGore.texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addClientEntity(FlyingGib entity) {
        try {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Method mtd = level.getClass().getDeclaredMethod("addEntity", Integer.TYPE, Entity.class);
            mtd.setAccessible(true);
            mtd.invoke((Object)level, new Object[]{level.f_46441_.m_188503_(Integer.MAX_VALUE), entity});
        }
        catch (Exception e) {
            Ntgl.LOGGER.error("reflection fail", (Throwable)e);
        }
    }

    public static void createDeathEffectClient(LivingEntity entity, GoreData data) {
        double x = entity.m_20185_();
        double y = entity.m_20186_() + (double)(entity.m_6095_().m_20679_() / 2.0f);
        double z = entity.m_20189_();
        Vec3 vec = new Vec3(x, y, z);
        ClientProxy.setDamageType((Entity)entity, data.deathType);
        switch (data.deathType) {
            case GORE: {
                DeathFxRenderer.setupGoreData(entity, data);
                data.gravity = 0.2f;
                DeathFxRenderer.createGoreFx(entity, vec, data);
                break;
            }
            case LASER: {
                DeathFxRenderer.setupGoreData(entity, data);
                data.showBlood = false;
                data.gravity = 110.2f;
                DeathFxRenderer.createDisintegrationFx(entity, vec, data);
                break;
            }
            case FIRE: {
                DeathFxRenderer.setupGoreData(entity, data);
                data.showBlood = false;
                data.gravity = 110.2f;
                DeathFxRenderer.createBurnFx(entity, vec, data);
            }
        }
    }

    private static void createGoreFx(LivingEntity entity, Vec3 vec, GoreData data) {
        for (int i = 0; i < data.getNumGibs(); ++i) {
            RandomSource random = entity.m_217043_();
            Vec3 delta = entity.m_20184_();
            double vx = (0.5 - random.m_188500_()) * 0.35;
            double vz = (0.5 - random.m_188500_()) * 0.35;
            double vy = entity.m_20096_() ? random.m_188500_() * 0.35 : (0.5 - random.m_188500_()) * 0.35;
            FlyingGib flyingGibs = new FlyingGib(entity.m_9236_(), entity, data, vec, new Vec3(delta.f_82479_ * 0.35 + vx, delta.f_82480_ * 0.35 + vy, delta.f_82481_ * 0.35 + vz), (entity.m_6095_().m_20678_() + entity.m_6095_().m_20679_()) / 2.0f, i);
            DeathFxRenderer.addClientEntity(flyingGibs);
        }
    }

    private static void createDisintegrationFx(LivingEntity entity, Vec3 vec, GoreData data) {
        data.texture = RES_LASER_EFFECT;
        for (int i = 0; i < data.getNumGibs(); ++i) {
            FlyingGib flyingGibs = new FlyingGib(entity.m_9236_(), entity, data, vec, Vec3.f_82478_, (entity.m_6095_().m_20678_() + entity.m_6095_().m_20679_()) / 2.0f, i);
            DeathFxRenderer.addClientEntity(flyingGibs);
        }
    }

    private static void createBurnFx(LivingEntity entity, Vec3 vec, GoreData data) {
        data.texture = RES_BURN_EFFECT;
        for (int i = 0; i < data.getNumGibs(); ++i) {
            RandomSource random = entity.m_217043_();
            Vec3 delta = entity.m_20184_();
            double ax = 0.01;
            double vx = (0.5 - random.m_188500_()) * ax;
            double vz = (0.5 - random.m_188500_()) * ax;
            double vy = entity.m_20096_() ? random.m_188500_() * ax : (0.5 - random.m_188500_()) * ax;
            FlyingGib flyingGibs = new FlyingGib(entity.m_9236_(), entity, data, vec, new Vec3(delta.f_82479_ * ax + vx, delta.f_82480_ * ax + vy, delta.f_82481_ * ax + vz), (entity.m_6095_().m_20678_() + entity.m_6095_().m_20679_()) / 2.0f, i);
            DeathFxRenderer.addClientEntity(flyingGibs);
        }
    }

    static {
        genericGore.setRandomScale(0.5f, 0.8f);
    }
}

