/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.util.handler.ShootingHandler;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.MeleeMode;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageMeleeAttack;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", value={Dist.CLIENT})
public class ClientMeleeHandler {
    private static final Map<Pair<LivingEntity, InteractionHand>, ClientMeleeHandler> TRACKER_MAP = new HashMap<Pair<LivingEntity, InteractionHand>, ClientMeleeHandler>();
    private final InteractionHand arm;
    private int delayTick;
    private int cooldownTick;

    private ClientMeleeHandler(LivingEntity entity, InteractionHand arm) {
        this.arm = arm;
        ItemStack stack = entity.m_21120_(arm);
        GunData data = new GunData(stack, entity);
        this.cooldownTick = GunModifierHelper.getMeleeCooldown(data);
        this.delayTick = GunModifierHelper.getMeleeDelay(data);
    }

    public static boolean isOnDelay(LivingEntity shooter, InteractionHand hand) {
        Pair key = Pair.of((Object)shooter, (Object)hand);
        return TRACKER_MAP.containsKey(key) && ClientMeleeHandler.TRACKER_MAP.get((Object)key).delayTick > 0;
    }

    public static boolean isOnCooldown(LivingEntity shooter, InteractionHand hand) {
        Pair key = Pair.of((Object)shooter, (Object)hand);
        return TRACKER_MAP.containsKey(key) && ClientMeleeHandler.TRACKER_MAP.get((Object)key).cooldownTick > 0;
    }

    public static void addTracker(LivingEntity entity, InteractionHand arm) {
        SyncedDataKey<LivingEntity, Boolean> doMelee = ModSyncedDataKeys.getDoMelee(arm);
        ItemStack gun = entity.m_21120_(arm);
        GunData data = new GunData(gun, entity);
        if (gun.m_41720_() instanceof WeaponItem && GunModifierHelper.canMelee(data) && !TRACKER_MAP.containsKey(Pair.of((Object)entity, (Object)arm)) && !((Boolean)doMelee.getValue((Entity)entity)).booleanValue()) {
            TRACKER_MAP.put((Pair<LivingEntity, InteractionHand>)Pair.of((Object)entity, (Object)arm), new ClientMeleeHandler(entity, arm));
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageMeleeAttack());
        }
    }

    @SubscribeEvent
    public static void onPostClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ShootingHandler.isInGame()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            assert (player != null);
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offhandItem = player.m_21206_();
            if (mainHandItem.m_41720_() instanceof WeaponItem && ClientMeleeHandler.isKeyAttackDown()) {
                ClientMeleeHandler.handleAutoFire(player, mainHandItem, InteractionHand.MAIN_HAND);
            }
            if (offhandItem.m_41720_() instanceof WeaponItem && GunModifierHelper.canRenderInOffhand((LivingEntity)player) && ClientMeleeHandler.isUseKeyDown()) {
                ClientMeleeHandler.handleAutoFire(player, offhandItem, InteractionHand.OFF_HAND);
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        try {
            if (event.phase == TickEvent.Phase.START) {
                for (Pair<LivingEntity, InteractionHand> pair : TRACKER_MAP.keySet()) {
                    ClientMeleeHandler.onEntityTick((LivingEntity)pair.getFirst(), (InteractionHand)pair.getSecond());
                }
            }
        }
        catch (Exception e) {
            Ntgl.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void handleAutoFire(LocalPlayer player, ItemStack heldItem, InteractionHand hand) {
        Minecraft mc = Minecraft.m_91087_();
        KeyMapping key = hand == InteractionHand.MAIN_HAND ? mc.f_91066_.f_92096_ : mc.f_91066_.f_92095_;
        ClientMeleeHandler.attack((LivingEntity)player, heldItem, hand);
        Item item = heldItem.m_41720_();
        if (item instanceof WeaponItem) {
            MeleeMode mode;
            WeaponItem weaponItem = (WeaponItem)item;
            if (ClientMeleeHandler.isMelee(heldItem, (LivingEntity)player) && (mode = weaponItem.getGun().getMelee().getMode()) == MeleeMode.SINGLE) {
                key.m_7249_(false);
            }
        }
    }

    private static void attack(LivingEntity shooter, ItemStack heldItem, InteractionHand hand) {
        Pair key;
        if (heldItem.m_41720_() instanceof WeaponItem && ClientMeleeHandler.isMelee(heldItem, shooter) && !EquipTracker.isEquiping(shooter, hand) && !shooter.m_5833_() && !TRACKER_MAP.containsKey(key = new Pair((Object)shooter, (Object)hand))) {
            ClientMeleeHandler.addTracker(shooter, hand);
        }
    }

    private static boolean isKeyAttackDown() {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
    }

    private static boolean isUseKeyDown() {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    private static void onEntityTick(LivingEntity shooter, InteractionHand hand) {
        ClientMeleeHandler tracker = TRACKER_MAP.get(Pair.of((Object)shooter, (Object)hand));
        if (tracker.delayTick > 0) {
            --tracker.delayTick;
        } else if (tracker.cooldownTick > 0) {
            --tracker.cooldownTick;
        } else if (tracker.cooldownTick == 0) {
            ClientMeleeHandler.stopMelee(shooter, hand);
        }
    }

    private static void stopMelee(LivingEntity entity, InteractionHand arm) {
        TRACKER_MAP.remove(Pair.of((Object)entity, (Object)arm));
    }

    private static boolean isMelee(ItemStack heldItem, LivingEntity entity) {
        return GunModifierHelper.getWeaponMode(new GunData(heldItem, entity)) == WeaponMode.MELEE;
    }
}

