/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.handler;

import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.event.GunReloadEvent;
import com.nukateam.ntgl.common.foundation.init.ModSyncedDataKeys;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageReload;
import com.nukateam.ntgl.common.network.message.C2SMessageUnload;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import com.nukateam.ntgl.common.util.util.InventoryUtil;
import com.nukateam.ntgl.modules.enchantment.GunEnchantmentHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientReloadHandler {
    private static ClientReloadHandler instance;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;
    private int reloadTicks;

    private ClientReloadHandler() {
    }

    public static ClientReloadHandler get() {
        if (instance == null) {
            instance = new ClientReloadHandler();
        }
        return instance;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.reloadTicks > 0) {
            --this.reloadTicks;
        }
        this.prevReloadTimer = this.reloadTimer;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)player)).booleanValue() && this.reloadingSlot != player.m_150109_().f_35977_) {
                this.setReloading(false, InteractionHand.MAIN_HAND);
            }
            this.updateReloadTimer((Player)player);
        }
    }

    public void unloadAmmo(InteractionHand hand) {
        this.setReloading(false, hand);
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageUnload(hand));
    }

    public void startReloading() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        if (mainHandItem.m_41720_() instanceof WeaponItem && !GunModifierHelper.isWeaponFull(new GunData(mainHandItem, (LivingEntity)player)) && !this.isReloading((LivingEntity)player, InteractionHand.MAIN_HAND)) {
            this.setReloading((Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)player) == false, InteractionHand.MAIN_HAND);
        } else if (offhandItem.m_41720_() instanceof WeaponItem && GunModifierHelper.canRenderInOffhand((LivingEntity)player) && !GunModifierHelper.isWeaponFull(new GunData(offhandItem, (LivingEntity)player)) && !this.isReloading((LivingEntity)player, InteractionHand.OFF_HAND)) {
            this.setReloading((Boolean)ModSyncedDataKeys.RELOADING_LEFT.getValue((Entity)player) == false, InteractionHand.OFF_HAND);
        }
    }

    public void setReloading(boolean reloading, InteractionHand hand) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        SyncedDataKey<LivingEntity, Boolean> dataKey = ModSyncedDataKeys.getReloadKey(hand);
        ItemStack stack = player.m_21120_(hand);
        if (reloading) {
            if (stack.m_41720_() instanceof WeaponItem) {
                boolean isAmmoIgnored = GunStateHelper.isAmmoIgnored(stack);
                boolean hasAmmo = InventoryUtil.hasAmmo((LivingEntity)player, stack);
                GunData data = new GunData(stack, (LivingEntity)player);
                boolean isMaxAmmo = GunStateHelper.isMaxAmmo(data);
                if (!isAmmoIgnored && hasAmmo && !isMaxAmmo) {
                    Gun gun = ((WeaponItem)stack.m_41720_()).getModifiedGun(stack);
                    this.reloadTicks = GunModifierHelper.getReloadTime(data);
                    if (GunStateHelper.getAmmoCount(data) >= GunEnchantmentHelper.getAmmoCapacity(data)) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, stack, hand))) {
                        return;
                    }
                    dataKey.setValue((Entity)player, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(true, hand));
                    this.reloadingSlot = player.m_150109_().f_35977_;
                    this.reloadTimer = GunModifierHelper.getReloadTime(data);
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, stack, hand));
                }
            }
        } else {
            this.stopReloading(hand);
        }
    }

    private void stopReloading(InteractionHand arm) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SyncedDataKey<LivingEntity, Boolean> dataKey = arm == InteractionHand.MAIN_HAND ? ModSyncedDataKeys.RELOADING_RIGHT : ModSyncedDataKeys.RELOADING_LEFT;
        dataKey.setValue((Entity)player, (Object)false);
        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false, arm));
        this.reloadingSlot = -1;
        this.reloadTicks = -1;
    }

    private void updateReloadTimer(Player player) {
        if (this.reloadTimer > 0) {
            --this.reloadTimer;
        }
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public boolean isReloading(LivingEntity entity, InteractionHand arm) {
        return switch (arm) {
            default -> throw new IncompatibleClassChangeError();
            case InteractionHand.MAIN_HAND -> this.isReloadingRight(entity);
            case InteractionHand.OFF_HAND -> this.isReloadingLeft(entity);
        };
    }

    public boolean isReloadingRight(LivingEntity entity) {
        return (Boolean)ModSyncedDataKeys.RELOADING_RIGHT.getValue((Entity)entity);
    }

    public boolean isReloadingLeft(LivingEntity entity) {
        return (Boolean)ModSyncedDataKeys.RELOADING_LEFT.getValue((Entity)entity);
    }

    public int getReloadingTicks() {
        return this.reloadTicks;
    }

    public float getReloadProgress(float partialTicks) {
        return ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
    }
}

