/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.util;

import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import com.mrcrayfish.framework.api.serialize.DataArray;
import com.mrcrayfish.framework.api.serialize.DataEntry;
import com.mrcrayfish.framework.api.serialize.DataNumber;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.api.serialize.DataType;
import com.nukateam.ntgl.client.util.MetaLoader;
import com.nukateam.ntgl.client.util.util.Easings;
import com.nukateam.ntgl.common.data.attachment.IAttachment;
import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.data.config.gun.Modules;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.properties.SightAnimation;
import com.nukateam.ntgl.common.foundation.item.attachment.ScopeItem;
import com.nukateam.ntgl.common.foundation.item.interfaces.IMeta;
import com.nukateam.ntgl.common.util.data.ObjectCache;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class PropertyHelper {
    public static final String CACHE_KEY = "properties";
    public static final String MODEL_KEY = "ntgl:model";
    public static final String WEAPON_KEY = "ntgl:weapon";
    public static final String SCOPE_KEY = "ntgl:scope";
    public static final Vec3 GUN_DEFAULT_ORIGIN = new Vec3(8.0, 0.0, 8.0);
    public static final Vec3 ATTACHMENT_DEFAULT_ORIGIN = new Vec3(8.0, 8.0, 8.0);
    public static final Vec3 DEFAULT_SCALE = new Vec3(1.0, 1.0, 1.0);
    public static final Vec3 RED = new Vec3(255.0, 0.0, 0.0);

    public static void resetCache() {
        ObjectCache.getInstance(CACHE_KEY).reset();
    }

    private static DataObject getCustomData(ItemStack stack) {
        if (stack.m_41720_() instanceof IMeta) {
            return MetaLoader.getInstance().getData(stack.m_41720_());
        }
        return FrameworkClientAPI.getOpenModelData((ItemStack)stack, null, null, (int)0);
    }

    public static Vec3 getScopeCamera(ItemStack stack) {
        DataObject scopeObject;
        DataObject customObject = PropertyHelper.getCustomData(stack);
        if (customObject.has(SCOPE_KEY, DataType.OBJECT) && (scopeObject = customObject.getDataObject(SCOPE_KEY)).has("camera", DataType.ARRAY)) {
            DataArray cameraArray = scopeObject.getDataArray("camera");
            return PropertyHelper.arrayToVec3(cameraArray, Vec3.f_82478_);
        }
        return ATTACHMENT_DEFAULT_ORIGIN;
    }

    public static Vec3 getIronSightCamera(ItemStack stack, Gun modifiedGun) {
        DataObject ironSightObject = PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "ironSight");
        if (ironSightObject.has("camera", DataType.ARRAY)) {
            DataArray cameraArray = ironSightObject.getDataArray("camera");
            return PropertyHelper.arrayToVec3(cameraArray, Vec3.f_82478_);
        }
        Modules.Zoom zoom = modifiedGun.getModules().getZoom();
        if (zoom != null) {
            double cameraX = modifiedGun.getModules().getZoom().getXOffset();
            double cameraY = modifiedGun.getModules().getZoom().getYOffset();
            double cameraZ = modifiedGun.getModules().getZoom().getZOffset();
            ItemStack attachment = GunStateHelper.getAttachmentItem(AttachmentType.SCOPE, stack);
            if (!attachment.m_41619_()) {
                ScopeItem scope = (ScopeItem)attachment.m_41720_();
                Modules.Attachment attachmentConfig = modifiedGun.findAttachment(scope);
                cameraX += attachmentConfig.getXOffset();
                cameraY += attachmentConfig.getYOffset();
                cameraZ += attachmentConfig.getZOffset();
            }
            return new Vec3(cameraX, cameraY, cameraZ);
        }
        return Vec3.f_82478_;
    }

    public static boolean isLegacyIronSight(ItemStack stack) {
        DataObject ironSightObject = PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "ironSight");
        return !ironSightObject.has("camera", DataType.ARRAY);
    }

    public static Vec3 getModelOrigin(ItemStack stack, Vec3 defaultOrigin) {
        DataObject modelObject;
        DataObject customObject = PropertyHelper.getCustomData(stack);
        if (customObject.has(MODEL_KEY, DataType.OBJECT) && (modelObject = customObject.getDataObject(MODEL_KEY)).has("origin", DataType.ARRAY)) {
            DataArray originArray = modelObject.getDataArray("origin");
            return PropertyHelper.arrayToVec3(originArray, defaultOrigin);
        }
        return defaultOrigin;
    }

    public static int getReticleColor(ItemStack stack) {
        DataObject dataObject;
        IAttachment attachment;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("ReticleColor", 3)) {
            return tag.m_128451_("ReticleColor");
        }
        Item item = stack.m_41720_();
        boolean isScope = item instanceof IAttachment && (attachment = (IAttachment)item).getType() == AttachmentType.SCOPE;
        DataObject dataObject2 = dataObject = isScope ? PropertyHelper.getObjectByPath(stack, SCOPE_KEY) : PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "ironSight");
        if (dataObject.has("reticleColor", DataType.NUMBER)) {
            return dataObject.getDataNumber("reticleColor").asInt();
        }
        if (dataObject.has("reticleColor", DataType.ARRAY)) {
            DataArray array = dataObject.getDataArray("reticleColor");
            Vec3 color = PropertyHelper.arrayToVec3(array, RED);
            int a = 255;
            int r = Mth.m_14045_((int)((int)color.f_82479_), (int)0, (int)255);
            int g = Mth.m_14045_((int)((int)color.f_82480_), (int)0, (int)255);
            int b = Mth.m_14045_((int)((int)color.f_82481_), (int)0, (int)255);
            return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        return -65536;
    }

    public static SightAnimation getSightAnimations(ItemStack weapon) {
        DataObject scopeObject;
        DataEntry dataEntry;
        IAttachment attachment;
        ItemStack scopeStack;
        Item item;
        if (GunStateHelper.hasAttachmentEquipped(weapon, AttachmentType.SCOPE) && (item = (scopeStack = GunStateHelper.getScopeStack(weapon)).m_41720_()) instanceof IAttachment && (attachment = (IAttachment)item).getType() == AttachmentType.SCOPE && (dataEntry = (scopeObject = PropertyHelper.getObjectByPath(scopeStack, SCOPE_KEY)).get("sightAnimation")) instanceof DataObject) {
            DataObject sightObject = (DataObject)dataEntry;
            return PropertyHelper.objectToSightAnimation(sightObject);
        }
        DataObject customObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY, "ironSight");
        item = customObject.get("sightAnimation");
        if (item instanceof DataObject) {
            DataObject sightObject = (DataObject)item;
            return PropertyHelper.objectToSightAnimation(sightObject);
        }
        return SightAnimation.DEFAULT;
    }

    public static double getViewportFov(ItemStack weapon) {
        DataObject customObject;
        if (GunStateHelper.hasAttachmentEquipped(weapon, AttachmentType.SCOPE)) {
            ItemStack scopeStack = GunStateHelper.getScopeStack(weapon);
            DataObject customObject2 = PropertyHelper.getObjectByPath(scopeStack, SCOPE_KEY);
            if (customObject2.has("viewportFov", DataType.NUMBER)) {
                return Mth.m_14008_((double)customObject2.getDataNumber("viewportFov").asDouble(), (double)1.0, (double)100.0);
            }
        }
        if ((customObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY, "ironSight")).has("viewportFov", DataType.NUMBER)) {
            return Mth.m_14008_((double)customObject.getDataNumber("viewportFov").asDouble(), (double)1.0, (double)100.0);
        }
        return 0.0;
    }

    private static SightAnimation objectToSightAnimation(DataObject object) {
        ObjectCache cache = ObjectCache.getInstance(CACHE_KEY);
        Optional<SightAnimation> cachedValue = cache.get(object.getId());
        return cachedValue.orElseGet(() -> cache.store(object.getId(), () -> {
            SightAnimation.Builder builder = SightAnimation.builder();
            PropertyHelper.getOptionalString(object, "viewportCurve").ifPresent(s -> builder.setViewportCurve(Easings.byName(s)));
            PropertyHelper.getOptionalString(object, "sightCurve").ifPresent(s -> builder.setSightCurve(Easings.byName(s)));
            PropertyHelper.getOptionalString(object, "fovCurve").ifPresent(s -> builder.setFovCurve(Easings.byName(s)));
            PropertyHelper.getOptionalString(object, "aimTransformCurve").ifPresent(s -> builder.setAimTransformCurve(Easings.byName(s)));
            return builder.build();
        }));
    }

    private static Optional<String> getOptionalString(DataObject src, String key) {
        if (src.has(key, DataType.STRING)) {
            return Optional.ofNullable(src.getDataString(key).asString());
        }
        return Optional.empty();
    }

    private static DataObject getObjectByPath(ItemStack stack, String ... path) {
        DataObject result = PropertyHelper.getCustomData(stack);
        for (String key : path) {
            if (!result.has(key, DataType.OBJECT)) {
                return DataObject.EMPTY;
            }
            result = result.getDataObject(key);
        }
        return result;
    }

    private static Vec3 arrayToVec3(DataArray array, Vec3 defaultValue) {
        if (array.length() != 3) {
            return defaultValue;
        }
        ObjectCache cache = ObjectCache.getInstance(CACHE_KEY);
        Optional<Vec3> cachedValue = cache.get(array.getId());
        return cachedValue.orElseGet(() -> cache.store(array.getId(), () -> {
            if (array.values().stream().allMatch(entry -> entry.getType() == DataType.NUMBER)) {
                double x = ((DataNumber)array.get(0)).asDouble();
                double y = ((DataNumber)array.get(1)).asDouble();
                double z = ((DataNumber)array.get(2)).asDouble();
                return new Vec3(x, y, z);
            }
            return defaultValue;
        }));
    }
}

