/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.util.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.MatrixUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class ModelRenderUtil {
    private static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    private static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");

    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        int scale = (int)mc.m_91268_().m_85449_();
        GL11.glScissor((int)(x * scale), (int)(mc.m_91268_().m_85444_() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static BakedModel getModel(Item item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(new ItemStack((ItemLike)item));
    }

    public static BakedModel getModel(ItemStack item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(item);
    }

    public static void renderModel(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, @Nullable Level world, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, world, entity, 0);
        ModelRenderUtil.renderModel(model, transformType, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ModelRenderUtil.renderModel(model, ItemDisplayContext.NONE, stack, poseStack, buffer, light, overlay);
    }

    public static void renderModel(BakedModel model, ItemDisplayContext transformType, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (!stack.m_41619_()) {
            boolean flag;
            poseStack.m_85836_();
            boolean bl = flag = transformType == ItemDisplayContext.GUI || transformType == ItemDisplayContext.GROUND || transformType == ItemDisplayContext.FIXED;
            if (flag) {
                if (stack.m_150930_(Items.f_42713_)) {
                    model = Minecraft.m_91087_().m_91304_().m_119422_(TRIDENT_MODEL);
                } else if (stack.m_150930_(Items.f_151059_)) {
                    model = Minecraft.m_91087_().m_91304_().m_119422_(SPYGLASS_MODEL);
                }
            }
            model = model.applyTransform(transformType, poseStack, false);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            if (!model.m_7521_() && (stack.m_41720_() != Items.f_42713_ || flag)) {
                VertexConsumer builder;
                boolean entity = true;
                if (transformType != ItemDisplayContext.GUI && !transformType.m_269069_() && stack.m_41720_() instanceof BlockItem) {
                    Block block = ((BlockItem)stack.m_41720_()).m_40614_();
                    entity = !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock);
                }
                RenderType renderType = ModelRenderUtil.getRenderType(stack, entity);
                if (stack.m_41720_() == Items.f_42522_ && stack.m_41790_()) {
                    poseStack.m_85836_();
                    PoseStack.Pose entry = poseStack.m_85850_();
                    if (transformType == ItemDisplayContext.GUI) {
                        MatrixUtil.m_253023_((Matrix4f)entry.m_252922_(), (float)0.5f);
                    } else if (transformType.m_269069_()) {
                        MatrixUtil.m_253023_((Matrix4f)entry.m_252922_(), (float)0.75f);
                    }
                    builder = entity ? ItemRenderer.m_115207_((MultiBufferSource)buffer, (RenderType)renderType, (PoseStack.Pose)entry) : ItemRenderer.m_115180_((MultiBufferSource)buffer, (RenderType)renderType, (PoseStack.Pose)entry);
                    poseStack.m_85849_();
                } else {
                    builder = entity ? ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || ItemStack.f_41583_.m_41790_() ? 1 : 0) != 0) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (stack.m_41790_() || ItemStack.f_41583_.m_41790_() ? 1 : 0) != 0);
                }
                ModelRenderUtil.renderModel(model, stack, ItemStack.f_41583_, poseStack, builder, light, overlay);
            } else {
                IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, transformType, poseStack, buffer, light, overlay);
            }
            poseStack.m_85849_();
        }
    }

    public static void renderModel(BakedModel model, ItemStack stack, ItemStack parent, PoseStack poseStack, VertexConsumer buffer, int light, int overlay) {
        RandomSource random = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            ModelRenderUtil.renderQuads(poseStack, buffer, model.m_213637_(null, direction, random), stack, parent, light, overlay);
        }
        random.m_188584_(42L);
        ModelRenderUtil.renderQuads(poseStack, buffer, model.m_213637_(null, null, random), stack, parent, light, overlay);
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, ItemStack stack, ItemStack parent, int light, int overlay) {
        PoseStack.Pose entry = poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            int color = -1;
            if (quad.m_111304_()) {
                color = ModelRenderUtil.getItemStackColor(stack, parent, quad.m_111305_());
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            buffer.m_85987_(entry, quad, red, green, blue, light, overlay);
        }
    }

    public static int getItemStackColor(ItemStack stack, ItemStack parent, int tintIndex) {
        int color = Minecraft.m_91087_().getItemColors().m_92676_(stack, tintIndex);
        if (color == -1 && !parent.m_41619_()) {
            return ModelRenderUtil.getItemStackColor(parent, ItemStack.f_41583_, tintIndex);
        }
        return color;
    }

    public static void applyTransformType(ItemStack stack, PoseStack poseStack, ItemDisplayContext transformType, @Nullable LivingEntity entity) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, entity != null ? entity.m_9236_() : null, entity, 0);
        boolean leftHanded = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemDisplayContext)transformType, (boolean)leftHanded);
        if (leftHanded) {
            Matrix4f scale = new Matrix4f().scale(-1.0f, 1.0f, 1.0f);
            Matrix3f normal = new Matrix3f((Matrix4fc)scale);
            poseStack.m_85850_().m_252922_().mul((Matrix4fc)scale);
            poseStack.m_85850_().m_252943_().mul((Matrix3fc)normal);
        }
    }

    public static boolean isMouseWithin(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static void renderFirstPersonArm(LocalPlayer player, HumanoidArm hand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher renderManager = mc.m_91290_();
        PlayerRenderer renderer = (PlayerRenderer)renderManager.m_114382_((Entity)player);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)player.m_108560_());
        if (hand == HumanoidArm.RIGHT) {
            renderer.m_117770_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        } else {
            renderer.m_117813_(poseStack, buffer, combinedLight, (AbstractClientPlayer)player);
        }
    }

    public static RenderType getRenderType(ItemStack stack, boolean entity) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            return ItemBlockRenderTypes.m_109284_((BlockState)block.m_49966_(), (!entity ? 1 : 0) != 0);
        }
        return RenderType.m_110473_((ResourceLocation)InventoryMenu.f_39692_);
    }
}

