/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config;

import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.holders.AmmoType;
import com.nukateam.ntgl.common.data.holders.CounterType;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AmmoConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    @Optional
    private AmmoType type = AmmoType.STANDARD;
    @Optional
    private CounterType counter = CounterType.NUMBER;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.type.toString());
        tag.m_128359_("counter", this.counter.toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("type", 8)) {
            this.type = AmmoType.getType(tag.m_128461_("type"));
        }
        if (tag.m_128425_("counter", 8)) {
            this.counter = CounterType.getType(tag.m_128461_("counter"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type.toString());
        object.addProperty("counter", this.counter.toString());
        return object;
    }

    public AmmoConfig copy() {
        AmmoConfig config = new AmmoConfig();
        config.type = this.type;
        config.counter = this.counter;
        return config;
    }

    public AmmoType getAmmoType() {
        return this.type;
    }

    public CounterType getCounter() {
        return this.counter;
    }

    public static AmmoConfig create(CompoundTag tag) {
        AmmoConfig ammo = new AmmoConfig();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Ammo");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final AmmoConfig ammo;

        private Builder() {
            this.ammo = new AmmoConfig();
        }

        private Builder(AmmoConfig ammo) {
            this.ammo = ammo.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(AmmoConfig ammo) {
            return new Builder(ammo);
        }

        public AmmoConfig build() {
            return this.ammo.copy();
        }
    }
}

