/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.gun;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.GripType;
import com.nukateam.ntgl.common.data.holders.LoadingType;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.util.annotation.Ignored;
import com.nukateam.ntgl.common.util.annotation.Optional;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class General
implements INBTSerializable<CompoundTag> {
    public static final String LOADING_TYPE = "LoadingType";
    public static final String AUTO_RELOAD = "AutoReload";
    public static final String RATE = "Rate";
    public static final String GRIP_TYPE = "GripType";
    public static final String RELOAD_TYPE = "ReloadType";
    public static final String MAX_AMMO = "MaxAmmo";
    public static final String RELOAD_SPEED = "ReloadSpeed";
    public static final String RELOAD_START = "reloadStart";
    public static final String RELOAD_TIME = "ReloadTime";
    public static final String RELOAD_END = "ReloadEnd";
    public static final String RECOIL_ANGLE = "RecoilAngle";
    public static final String DAMAGE = "Damage";
    public static final String RECOIL_KICK = "RecoilKick";
    public static final String RECOIL_DURATION_OFFSET = "RecoilDurationOffset";
    public static final String RECOIL_ADS_REDUCTION = "RecoilAdsReduction";
    public static final String PROJECTILE_AMOUNT = "ProjectileAmount";
    public static final String MULTISHOT_AMOUNT = "multishotAmount";
    public static final String ALWAYS_SPREAD = "AlwaysSpread";
    public static final String SPREAD = "Spread";
    public static final String CATEGORY = "category";
    public static final String MOVEMENT_MODIFIER = "MovementModifier";
    public static final String AMMO = "Ammo";
    public static final String FUEL = "Fuel";
    public static final String FULL_CHARGE = "FullCharge";
    public static final String ENCHANTABLE = "Enchantable";
    public static final String SILENCED = "silenced";
    public static final String FIRE_TIMER = "FireTimer";
    public static final String FIRE_MODE = "FireMode";
    public static final String ONE_TIME_CHARGE = "OneTimeCharge";
    public static final String MELEE = "melee";
    public static final String EQUIP_TIME = "EquipTime";
    public static final String AMMO_PER_SHOT = "AmmoPerShot";
    public static final String RENDER_HUD = "RenderHud";
    public static final String WEAPON_MODE = "WeaponMode";
    int rate;
    int maxAmmo;
    @Optional
    LinkedHashSet<FireMode> fireMode = new LinkedHashSet<FireMode>(List.of(FireMode.SEMI_AUTO));
    @Optional
    WeaponMode weaponMode = WeaponMode.GUN;
    @Optional
    boolean fullCharge = false;
    @Optional
    boolean enchantable = true;
    @Optional
    boolean silenced = false;
    @Optional
    float damage;
    @Optional
    int reloadAmount = 1;
    @Optional
    int reloadStart = 0;
    @Optional
    int reloadTime = 1;
    @Optional
    int reloadEnd = 0;
    @Optional
    int equipTime = 1;
    @Optional
    int ammoPerShot = 1;
    @Ignored
    GripType gripType = GripType.ONE_HANDED;
    @Optional
    LoadingType loadingType = LoadingType.MAGAZINE;
    @Optional
    String category = "pistol";
    @Optional
    boolean autoReload = false;
    @Optional
    boolean renderHud = true;
    @Optional
    float recoilAngle;
    @Optional
    float recoilKick;
    @Optional
    float recoilDurationOffset;
    @Optional
    float recoilAdsReduction = 0.2f;
    @Optional
    int projectileAmount = 1;
    @Optional
    int multishotAmount = 2;
    @Optional
    boolean alwaysSpread;
    @Optional
    boolean oneTimeCharge = true;
    @Optional
    float spread;
    @Optional
    int fireTimer;
    @Optional
    float movementSpeed = 0.0f;
    @Optional
    boolean melee = false;
    @Optional
    protected LinkedHashSet<AmmoHolder> ammo = new LinkedHashSet<AmmoHolder>(List.of(AmmoHolder.getType("ntgl:round10mm")));
    @Optional
    protected LinkedHashSet<AmmoHolder> fuel = new LinkedHashSet();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(RATE, this.rate);
        tag.m_128379_(FULL_CHARGE, this.fullCharge);
        tag.m_128379_(ENCHANTABLE, this.enchantable);
        tag.m_128379_(SILENCED, this.silenced);
        tag.m_128405_(FIRE_TIMER, this.fireTimer);
        tag.m_128365_(FIRE_MODE, (Tag)NbtUtils.serializeSet(this.fireMode));
        tag.m_128359_(GRIP_TYPE, this.gripType.getId().toString());
        tag.m_128405_(MAX_AMMO, this.maxAmmo);
        tag.m_128405_(RELOAD_SPEED, this.reloadAmount);
        tag.m_128405_(RELOAD_START, this.reloadStart);
        tag.m_128405_(RELOAD_TIME, this.reloadTime);
        tag.m_128405_(RELOAD_END, this.reloadEnd);
        tag.m_128405_(EQUIP_TIME, this.equipTime);
        tag.m_128405_(AMMO_PER_SHOT, this.ammoPerShot);
        tag.m_128359_(LOADING_TYPE, this.loadingType.toString());
        tag.m_128359_(WEAPON_MODE, this.weaponMode.toString());
        tag.m_128379_(AUTO_RELOAD, this.autoReload);
        tag.m_128379_(RENDER_HUD, this.renderHud);
        tag.m_128359_(CATEGORY, this.category);
        tag.m_128350_(RECOIL_ANGLE, this.recoilAngle);
        tag.m_128350_(DAMAGE, this.damage);
        tag.m_128350_(RECOIL_KICK, this.recoilKick);
        tag.m_128350_(RECOIL_DURATION_OFFSET, this.recoilDurationOffset);
        tag.m_128350_(RECOIL_ADS_REDUCTION, this.recoilAdsReduction);
        tag.m_128405_(PROJECTILE_AMOUNT, this.projectileAmount);
        tag.m_128405_(MULTISHOT_AMOUNT, this.multishotAmount);
        tag.m_128350_(SPREAD, this.spread);
        tag.m_128350_(MOVEMENT_MODIFIER, this.movementSpeed);
        tag.m_128379_(ALWAYS_SPREAD, this.alwaysSpread);
        tag.m_128379_(ONE_TIME_CHARGE, this.oneTimeCharge);
        tag.m_128379_(MELEE, this.melee);
        tag.m_128365_(AMMO, (Tag)NbtUtils.serializeSet(this.ammo));
        tag.m_128365_(FUEL, (Tag)NbtUtils.serializeSet(this.fuel));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(FIRE_MODE, 10)) {
            this.fireMode = NbtUtils.deserializeFireMode(tag.m_128469_(FIRE_MODE));
        }
        if (tag.m_128425_(FULL_CHARGE, 99)) {
            this.fullCharge = tag.m_128471_(FULL_CHARGE);
        }
        if (tag.m_128425_(ENCHANTABLE, 99)) {
            this.enchantable = tag.m_128471_(ENCHANTABLE);
        }
        if (tag.m_128425_(SILENCED, 99)) {
            this.silenced = tag.m_128471_(SILENCED);
        }
        if (tag.m_128425_(RATE, 99)) {
            this.rate = tag.m_128451_(RATE);
        }
        if (tag.m_128425_(FIRE_TIMER, 99)) {
            this.fireTimer = tag.m_128451_(FIRE_TIMER);
        }
        if (tag.m_128425_(GRIP_TYPE, 8)) {
            this.gripType = GripType.getType(ResourceLocation.m_135820_((String)tag.m_128461_(GRIP_TYPE)));
        }
        if (tag.m_128425_(MAX_AMMO, 99)) {
            this.maxAmmo = tag.m_128451_(MAX_AMMO);
        }
        if (tag.m_128425_(RELOAD_SPEED, 99)) {
            this.reloadAmount = tag.m_128451_(RELOAD_SPEED);
        }
        if (tag.m_128425_(RELOAD_START, 99)) {
            this.reloadStart = tag.m_128451_(RELOAD_START);
        }
        if (tag.m_128425_(RELOAD_TIME, 99)) {
            this.reloadTime = tag.m_128451_(RELOAD_TIME);
        }
        if (tag.m_128425_(RELOAD_END, 99)) {
            this.reloadEnd = tag.m_128451_(RELOAD_END);
        }
        if (tag.m_128425_(EQUIP_TIME, 99)) {
            this.equipTime = tag.m_128451_(EQUIP_TIME);
        }
        if (tag.m_128425_(AMMO_PER_SHOT, 99)) {
            this.ammoPerShot = tag.m_128451_(AMMO_PER_SHOT);
        }
        if (tag.m_128425_(LOADING_TYPE, 8)) {
            this.loadingType = LoadingType.getType(tag.m_128461_(LOADING_TYPE));
        }
        if (tag.m_128425_(WEAPON_MODE, 8)) {
            this.weaponMode = WeaponMode.getType(tag.m_128461_(WEAPON_MODE));
        }
        if (tag.m_128425_(AUTO_RELOAD, 1)) {
            this.autoReload = tag.m_128471_(AUTO_RELOAD);
        }
        if (tag.m_128425_(RENDER_HUD, 1)) {
            this.renderHud = tag.m_128471_(RENDER_HUD);
        }
        if (tag.m_128425_(CATEGORY, 8)) {
            this.category = tag.m_128461_(CATEGORY);
        }
        if (tag.m_128425_(RECOIL_ANGLE, 99)) {
            this.recoilAngle = tag.m_128457_(RECOIL_ANGLE);
        }
        if (tag.m_128425_(DAMAGE, 99)) {
            this.damage = tag.m_128457_(DAMAGE);
        }
        if (tag.m_128425_(RECOIL_KICK, 99)) {
            this.recoilKick = tag.m_128457_(RECOIL_KICK);
        }
        if (tag.m_128425_(RECOIL_DURATION_OFFSET, 99)) {
            this.recoilDurationOffset = tag.m_128457_(RECOIL_DURATION_OFFSET);
        }
        if (tag.m_128425_(RECOIL_ADS_REDUCTION, 99)) {
            this.recoilAdsReduction = tag.m_128457_(RECOIL_ADS_REDUCTION);
        }
        if (tag.m_128425_(PROJECTILE_AMOUNT, 99)) {
            this.projectileAmount = tag.m_128451_(PROJECTILE_AMOUNT);
        }
        if (tag.m_128425_(MULTISHOT_AMOUNT, 99)) {
            this.multishotAmount = tag.m_128451_(MULTISHOT_AMOUNT);
        }
        if (tag.m_128441_(ONE_TIME_CHARGE)) {
            this.oneTimeCharge = tag.m_128471_(ONE_TIME_CHARGE);
        }
        if (tag.m_128441_(MELEE)) {
            this.melee = tag.m_128471_(MELEE);
        }
        if (tag.m_128441_(ALWAYS_SPREAD)) {
            this.alwaysSpread = tag.m_128471_(ALWAYS_SPREAD);
        }
        if (tag.m_128425_(SPREAD, 99)) {
            this.spread = tag.m_128457_(SPREAD);
        }
        if (tag.m_128425_(MOVEMENT_MODIFIER, 99)) {
            this.movementSpeed = tag.m_128457_(MOVEMENT_MODIFIER);
        }
        if (tag.m_128425_(AMMO, 10)) {
            this.ammo = NbtUtils.deserializeSet(tag.m_128469_(AMMO), AmmoHolder::getType);
        }
        if (tag.m_128425_(FUEL, 10)) {
            this.fuel = NbtUtils.deserializeSet(tag.m_128469_(FUEL), AmmoHolder::getType);
        }
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.rate > 0 ? 1 : 0) != 0, (Object)"Rate must be more than zero");
        Preconditions.checkArgument((this.maxAmmo > 0 ? 1 : 0) != 0, (Object)"Max projectile must be more than zero");
        Preconditions.checkArgument((this.reloadAmount >= 1 ? 1 : 0) != 0, (Object)"Reload amount must be more than or equal to zero");
        Preconditions.checkArgument((this.reloadTime >= 1 ? 1 : 0) != 0, (Object)"Reload time must be more than or equal to zero");
        Preconditions.checkArgument((this.recoilAngle >= 0.0f ? 1 : 0) != 0, (Object)"Recoil angle must be more than or equal to zero");
        Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage angle must be more than or equal to zero");
        Preconditions.checkArgument((this.recoilKick >= 0.0f ? 1 : 0) != 0, (Object)"Recoil kick must be more than or equal to zero");
        Preconditions.checkArgument((this.recoilDurationOffset >= 0.0f && this.recoilDurationOffset <= 1.0f ? 1 : 0) != 0, (Object)"Recoil duration offset must be between 0.0 and 1.0");
        Preconditions.checkArgument((this.recoilAdsReduction >= 0.0f && this.recoilAdsReduction <= 1.0f ? 1 : 0) != 0, (Object)"Recoil ads reduction must be between 0.0 and 1.0");
        Preconditions.checkArgument((this.projectileAmount >= 1 ? 1 : 0) != 0, (Object)"Projectile amount must be more than or equal to one");
        Preconditions.checkArgument((this.spread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
        Preconditions.checkArgument((this.movementSpeed >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
        JsonObject object = new JsonObject();
        if (this.fullCharge) {
            object.addProperty("fullCharge", Boolean.valueOf(true));
        }
        object.addProperty("fullCharge", Boolean.valueOf(this.fullCharge));
        object.addProperty("rate", (Number)this.rate);
        if (this.fireTimer != 0) {
            object.addProperty("fireTimer", (Number)this.fireTimer);
        }
        object.addProperty("gripType", this.gripType.toString());
        object.addProperty("loadingType", this.loadingType.toString());
        object.addProperty("weaponMode", this.weaponMode.toString());
        object.addProperty("autoReload", Boolean.valueOf(this.autoReload));
        object.addProperty("renderHud", Boolean.valueOf(this.renderHud));
        object.addProperty("maxAmmo", (Number)this.maxAmmo);
        if (this.reloadAmount != 1) {
            object.addProperty("reloadAmount", (Number)this.reloadAmount);
        }
        if (this.reloadStart > 0) {
            object.addProperty(RELOAD_START, (Number)this.reloadStart);
        }
        if (this.reloadTime != 1) {
            object.addProperty("reloadTime", (Number)this.reloadTime);
        }
        if (this.reloadEnd > 0) {
            object.addProperty("reloadEnd", (Number)this.reloadEnd);
        }
        if (this.equipTime > 0) {
            object.addProperty("equipTime", (Number)this.equipTime);
        }
        if (this.ammoPerShot > 0) {
            object.addProperty("ammoPerShot", (Number)this.ammoPerShot);
        }
        if (this.recoilAngle != 0.0f) {
            object.addProperty("recoilAngle", (Number)Float.valueOf(this.recoilAngle));
        }
        if (this.damage != 0.0f) {
            object.addProperty("damage", (Number)Float.valueOf(this.damage));
        }
        if (this.recoilKick != 0.0f) {
            object.addProperty("recoilKick", (Number)Float.valueOf(this.recoilKick));
        }
        if (this.recoilDurationOffset != 0.0f) {
            object.addProperty("recoilDurationOffset", (Number)Float.valueOf(this.recoilDurationOffset));
        }
        if (this.recoilAdsReduction != 0.2f) {
            object.addProperty("recoilAdsReduction", (Number)Float.valueOf(this.recoilAdsReduction));
        }
        if (this.projectileAmount != 1) {
            object.addProperty("projectileAmount", (Number)this.projectileAmount);
        }
        object.addProperty(MULTISHOT_AMOUNT, (Number)this.multishotAmount);
        object.addProperty("alwaysSpread", Boolean.valueOf(this.alwaysSpread));
        object.addProperty("oneTimeCharge", Boolean.valueOf(this.oneTimeCharge));
        object.addProperty(MELEE, Boolean.valueOf(this.melee));
        if (this.movementSpeed != 1.0f) {
            object.addProperty("movementSpeed", Boolean.valueOf(true));
        }
        if (this.spread != 0.0f) {
            object.addProperty("spread", (Number)Float.valueOf(this.spread));
        }
        return object;
    }

    public General copy() {
        General general = new General();
        general.fireMode = this.fireMode;
        general.fullCharge = this.fullCharge;
        general.enchantable = this.enchantable;
        general.silenced = this.silenced;
        general.rate = this.rate;
        general.fireTimer = this.fireTimer;
        general.gripType = this.gripType;
        general.maxAmmo = this.maxAmmo;
        general.reloadAmount = this.reloadAmount;
        general.reloadStart = this.reloadStart;
        general.reloadTime = this.reloadTime;
        general.reloadEnd = this.reloadEnd;
        general.equipTime = this.equipTime;
        general.ammoPerShot = this.ammoPerShot;
        general.loadingType = this.loadingType;
        general.weaponMode = this.weaponMode;
        general.autoReload = this.autoReload;
        general.renderHud = this.renderHud;
        general.category = this.category;
        general.recoilAngle = this.recoilAngle;
        general.damage = this.damage;
        general.recoilKick = this.recoilKick;
        general.recoilDurationOffset = this.recoilDurationOffset;
        general.recoilAdsReduction = this.recoilAdsReduction;
        general.projectileAmount = this.projectileAmount;
        general.multishotAmount = this.multishotAmount;
        general.alwaysSpread = this.alwaysSpread;
        general.spread = this.spread;
        general.oneTimeCharge = this.oneTimeCharge;
        general.melee = this.melee;
        general.movementSpeed = this.movementSpeed;
        general.ammo = new LinkedHashSet<AmmoHolder>(this.ammo);
        general.fuel = new LinkedHashSet<AmmoHolder>(this.fuel);
        return general;
    }

    public static General create(CompoundTag tag) {
        General general = new General();
        general.deserializeNBT(tag);
        return general;
    }

    public Set<AmmoHolder> getAmmo() {
        return this.ammo;
    }

    public Set<AmmoHolder> getFuel() {
        return this.fuel;
    }

    public Set<FireMode> getFireModes() {
        return this.fireMode;
    }

    public boolean isFullCharge() {
        return this.fullCharge;
    }

    public boolean isEnchantable() {
        return this.enchantable;
    }

    public boolean isSilenced() {
        return this.silenced;
    }

    public int getRate() {
        return this.rate;
    }

    public int getFireDelay() {
        return this.fireTimer;
    }

    public GripType getGripType() {
        return this.gripType;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public int getReloadAmount() {
        return this.reloadAmount;
    }

    public int getReloadStart() {
        return this.reloadStart;
    }

    public int getReloadTime() {
        return this.reloadTime;
    }

    public int getReloadEnd() {
        return this.reloadEnd;
    }

    public int getEquipTime() {
        return this.equipTime;
    }

    public int getAmmoPerShot() {
        return this.ammoPerShot;
    }

    public WeaponMode getWeaponMode() {
        return this.weaponMode;
    }

    public LoadingType getLoadingType() {
        return this.loadingType;
    }

    public boolean isAutoReloading() {
        return this.autoReload;
    }

    public boolean shouldRenderHud() {
        return this.renderHud;
    }

    public String getCategory() {
        return this.category;
    }

    public float getRecoilAngle() {
        return this.recoilAngle;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getRecoilKick() {
        return this.recoilKick;
    }

    public float getRecoilDurationOffset() {
        return this.recoilDurationOffset;
    }

    public float getRecoilAdsReduction() {
        return this.recoilAdsReduction;
    }

    public int getProjectileAmount() {
        return this.projectileAmount;
    }

    public int getMultishotAmount() {
        return this.multishotAmount;
    }

    public boolean isAlwaysSpread() {
        return this.alwaysSpread;
    }

    public boolean isOneTimeCharge() {
        return this.oneTimeCharge;
    }

    public boolean canMelee() {
        return this.melee;
    }

    public float getSpread() {
        return this.spread;
    }

    public float getMovementSpeed() {
        return this.movementSpeed;
    }
}

