/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.nukateam.ntgl.common.data.config.gun.Gun;
import com.nukateam.ntgl.common.foundation.entity.AbstractBeamProjectile;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class LaserProjectile
extends AbstractBeamProjectile {
    private static final float GROUND_FIRE_CHANCE = 0.1f;
    private static final float ENTITY_FIRE_CHANCE = 0.1f;

    public LaserProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public LaserProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, WeaponItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        this.trace();
    }

    public float getBlockFireChance() {
        return 0.1f;
    }

    public float getEntityFireChance() {
        return 0.1f;
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        if (this.f_19796_.m_188501_() <= this.getEntityFireChance()) {
            entity.m_7311_(20);
        }
    }

    @Override
    protected void onHitBlock(BlockState blockState, BlockPos blockPos, Direction face, double x, double y, double z) {
        super.onHitBlock(blockState, blockPos, face, x, y, z);
        if (this.f_19796_.m_188501_() <= this.getBlockFireChance()) {
            if (!(CampfireBlock.m_51321_((BlockState)blockState) || CandleBlock.m_152845_((BlockState)blockState) || CandleCakeBlock.m_152910_((BlockState)blockState))) {
                BlockPos relativeBlockPos = blockPos.m_121945_(face);
                if (BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)relativeBlockPos, (Direction)face)) {
                    BlockState fireBlockState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)relativeBlockPos);
                    this.m_9236_().m_7731_(relativeBlockPos, fireBlockState, 11);
                }
            } else {
                this.m_9236_().m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }
}

