/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.item;

import com.nukateam.geo.interfaces.DynamicGeoItem;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.ntgl.client.animators.ThrowableAnimator;
import com.nukateam.ntgl.client.model.gun.ThrowableItemModel;
import com.nukateam.ntgl.client.render.renderers.weapon.ThrowableItemRenderer;
import com.nukateam.ntgl.common.data.config.ExplosionConfig;
import com.nukateam.ntgl.common.data.config.ThrowableConfig;
import com.nukateam.ntgl.common.data.holders.ProjectileType;
import com.nukateam.ntgl.common.foundation.entity.throwable.ThrowableItemEntity;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.util.managers.ProjectileManager;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public class ThrowableItem
extends Item
implements DynamicGeoItem,
IThrowable {
    protected final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Lazy<ThrowableItemRenderer<?>> RENDERER = Lazy.of(() -> new ThrowableItemRenderer(new ThrowableItemModel()));
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private ThrowableConfig projectile = new ThrowableConfig();

    public ThrowableItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ThrowableConfig getConfig() {
        return this.projectile;
    }

    @Override
    public void setConfig(ConfigSupplier<ThrowableConfig> supplier) {
        this.projectile = supplier.getConfig();
    }

    public BiFunction<ItemDisplayContext, ThrowableItemRenderer<ThrowableAnimator>, ThrowableAnimator> getAnimatorFactory() {
        return ThrowableAnimator::new;
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public DynamicGeoItemRenderer getRenderer() {
        return (DynamicGeoItemRenderer)((Object)this.RENDERER.get());
    }

    @Override
    public void expire(LivingEntity entityLiving) {
        ThrowableItemEntity throwableEntity = this.create(entityLiving.m_9236_(), entityLiving, 0);
        throwableEntity.onDeath();
    }

    @Override
    public void throwItem(ItemStack stack, LivingEntity entityLiving, int timeLeft) {
        Player player;
        Level level = entityLiving.m_9236_();
        if (!(entityLiving instanceof Player) || !(player = (Player)entityLiving).m_7500_()) {
            stack.m_41774_(1);
        }
        ThrowableItemEntity grenade = this.create(level, entityLiving, timeLeft);
        grenade.m_37251_((Entity)entityLiving, entityLiving.m_146909_(), entityLiving.m_146908_(), 0.0f, Math.min(1.0f, (float)timeLeft / 20.0f), 1.0f);
        level.m_7967_((Entity)grenade);
        this.onThrown(level, grenade);
        if (entityLiving instanceof Player) {
            ((Player)entityLiving).m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        this.addDamageTip(tooltip);
        ExplosionConfig explosion = this.getConfig().getProjectile().getExplosion();
        if (explosion.getRadius() > 0.0f) {
            ThrowableItem.addExplosionTip(tooltip, explosion);
        }
    }

    public static void addExplosionTip(List<Component> tooltip, ExplosionConfig explosion) {
        float damage = explosion.getDamage();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.explosionDamage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage)}).m_130940_(ChatFormatting.GRAY));
        float radius = explosion.getRadius();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.explosionRadius", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(radius)}).m_130940_(ChatFormatting.GRAY));
    }

    private void addDamageTip(List<Component> tooltip) {
        float damage = this.getConfig().getProjectile().getDamage();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.damage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage)}).m_130940_(ChatFormatting.GRAY));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public ThrowableItemEntity create(Level world, LivingEntity entity, int timeLeft) {
        ProjectileType projectile = this.getConfig().getProjectile().getProjectile();
        return ProjectileManager.getInstance().getFactory(projectile).create(world, entity, this, timeLeft);
    }

    protected void onThrown(Level world, ThrowableItemEntity entity) {
    }
}

