/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.handlers;

import com.nukateam.ntgl.common.data.GunData;
import com.nukateam.ntgl.common.data.holders.AnimationType;
import com.nukateam.ntgl.common.event.AttachmentEvent;
import com.nukateam.ntgl.common.event.GunFireEvent;
import com.nukateam.ntgl.common.event.GunReloadEvent;
import com.nukateam.ntgl.common.foundation.init.NtglGameEvents;
import com.nukateam.ntgl.common.foundation.item.WeaponItem;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.util.trackers.EquipTracker;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.GunModifierHelper;
import com.nukateam.ntgl.common.util.util.GunStateHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ntgl", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GunEventHandler {
    @SubscribeEvent
    public static void attachmentsChanged(AttachmentEvent.ContainerUpdateEvent event) {
    }

    @SubscribeEvent
    public static void preReload(GunReloadEvent.Pre event) {
        if (!event.isClient()) {
            PacketHandler.sendAnimation((LivingEntity)event.getEntity(), event.getHand(), AnimationType.RELOAD);
        }
    }

    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        ItemStack heldItem = entity.m_21120_(event.getHand());
        if (heldItem.m_41720_() instanceof WeaponItem) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && EquipTracker.isEquiping((LivingEntity)(player = (Player)livingEntity), event.getHand())) {
                event.setCanceled(true);
            }
            if (GunEventHandler.isBroken(entity, heldItem)) {
                event.setCanceled(true);
            }
            if (!FuelUtils.hasFuel(event.getGunData(), false)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void postShoot(GunFireEvent.Post event) {
        LivingEntity entity = event.getEntity();
        Level level = event.getEntity().m_9236_();
        ItemStack heldItem = entity.m_21120_(event.getHand());
        CompoundTag tag = heldItem.m_41783_();
        if (heldItem.m_41720_() instanceof WeaponItem) {
            if (heldItem.m_41763_() && tag != null) {
                if (GunStateHelper.hasAmmo(heldItem)) {
                    GunEventHandler.damageGun(heldItem, level, entity);
                }
                if ((double)heldItem.m_41773_() >= (double)heldItem.m_41776_() / 1.5) {
                    level.m_245803_((Entity)entity, entity.m_20183_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 1.75f);
                }
            }
            if (!event.isClient()) {
                PacketHandler.sendAnimation(entity, event.getHand(), AnimationType.FIRE);
                if (!GunModifierHelper.isSilencedFire(new GunData(heldItem, entity))) {
                    NtglGameEvents.gunshotEvent(level, entity);
                    level.m_142346_((Entity)entity, GameEvent.f_157778_, entity.m_20183_());
                }
            }
        }
    }

    private static boolean isBroken(LivingEntity shooter, ItemStack heldItem) {
        Level level = shooter.m_9236_();
        if (heldItem.m_41763_()) {
            int maxDamage = heldItem.m_41776_();
            int currentDamage = heldItem.m_41773_();
            if (currentDamage == maxDamage - 1) {
                level.m_245803_((Entity)shooter, shooter.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            if (currentDamage == maxDamage) {
                GunModifierHelper.getGun(heldItem).playCockSound(shooter);
                return true;
            }
        }
        return false;
    }

    public static void damageGun(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        if (stack.m_41763_()) {
            int maxDamage = stack.m_41776_();
            int currentDamage = stack.m_41773_();
            if (currentDamage >= maxDamage - 1) {
                if (currentDamage >= maxDamage - 2) {
                    level.m_245803_((Entity)entity, entity.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                stack.m_41622_(1, entity, null);
            }
        }
    }
}

